/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.IntermediateStop;
import at.ac.ait.ariadne.routeformat.ModeOfTransport;
import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeatureCollection;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONLineString;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPolygon;
import at.ac.ait.ariadne.routeformat.instruction.Instruction;
import at.ac.ait.ariadne.routeformat.location.Location;
import at.ac.ait.ariadne.routeformat.util.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class RouteSegment
implements Validatable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteSegment.class);
    private Integer nr;
    private Location<?> from;
    private Location<?> to;
    private Integer distanceMeters;
    private Integer durationSeconds;
    private ModeOfTransport modeOfTransport;
    private Optional<Integer> boardingSeconds = Optional.empty();
    private Optional<Integer> alightingSeconds = Optional.empty();
    private ZonedDateTime startTime = null;
    private ZonedDateTime endTime = null;
    private List<IntermediateStop> intermediateStops = new ArrayList<IntermediateStop>();
    private Optional<GeoJSONFeature<GeoJSONPolygon>> boundingBox = Optional.empty();
    private Optional<String> geometryEncodedPolyLine = Optional.empty();
    private Optional<GeoJSONFeature<GeoJSONLineString>> geometryGeoJson = Optional.empty();
    private Optional<GeoJSONFeatureCollection<GeoJSONLineString>> geometryGeoJsonEdges = Optional.empty();
    private List<Instruction<?>> navigationInstructions = new ArrayList();
    private List<Constants.Accessibility> accessibility = new ArrayList<Constants.Accessibility>();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public int getNr() {
        return this.nr;
    }

    @JsonProperty(required=true)
    public Location<?> getFrom() {
        return this.from;
    }

    @JsonProperty(required=true)
    public Location<?> getTo() {
        return this.to;
    }

    @JsonProperty(required=true)
    public int getDistanceMeters() {
        return this.distanceMeters;
    }

    @JsonProperty(required=true)
    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    @JsonIgnore
    public int getTravelTimeSeconds() {
        return this.durationSeconds - this.boardingSeconds.orElse(0) - this.alightingSeconds.orElse(0);
    }

    @JsonProperty(required=true)
    public ModeOfTransport getModeOfTransport() {
        return this.modeOfTransport;
    }

    public Optional<Integer> getBoardingSeconds() {
        return this.boardingSeconds;
    }

    public Optional<Integer> getAlightingSeconds() {
        return this.alightingSeconds;
    }

    public String getStartTime() {
        return Utils.getDateTimeString(this.startTime);
    }

    @JsonIgnore
    public ZonedDateTime getStartTimeAsZonedDateTime() {
        return this.startTime;
    }

    @JsonIgnore
    public ZonedDateTime getDepartureTimeAsZonedDateTime() {
        return this.startTime.plusSeconds(this.boardingSeconds.orElse(0).intValue());
    }

    @JsonIgnore
    public ZonedDateTime getArrivalTimeAsZonedDateTime() {
        return this.endTime.minusSeconds(this.alightingSeconds.orElse(0).intValue());
    }

    public String getEndTime() {
        return Utils.getDateTimeString(this.endTime);
    }

    @JsonIgnore
    public ZonedDateTime getEndTimeAsZonedDateTime() {
        return this.endTime;
    }

    public List<IntermediateStop> getIntermediateStops() {
        return this.intermediateStops;
    }

    public Optional<GeoJSONFeature<GeoJSONPolygon>> getBoundingBox() {
        return this.boundingBox;
    }

    public Optional<String> getGeometryEncodedPolyLine() {
        return this.geometryEncodedPolyLine;
    }

    public Optional<GeoJSONFeature<GeoJSONLineString>> getGeometryGeoJson() {
        return this.geometryGeoJson;
    }

    public Optional<GeoJSONFeatureCollection<GeoJSONLineString>> getGeometryGeoJsonEdges() {
        return this.geometryGeoJsonEdges;
    }

    public List<Instruction<?>> getNavigationInstructions() {
        return this.navigationInstructions;
    }

    public List<Constants.Accessibility> getAccessibility() {
        return this.accessibility;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public RouteSegment setNr(int nr) {
        this.nr = nr;
        return this;
    }

    public RouteSegment setFrom(Location<?> from) {
        this.from = from;
        return this;
    }

    public RouteSegment setTo(Location<?> to) {
        this.to = to;
        return this;
    }

    public RouteSegment setDistanceMeters(int distanceMeters) {
        this.distanceMeters = distanceMeters;
        return this;
    }

    public RouteSegment setDurationSeconds(int durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    public RouteSegment setModeOfTransport(ModeOfTransport modeOfTransport) {
        this.modeOfTransport = modeOfTransport;
        return this;
    }

    public RouteSegment setBoardingSeconds(Integer boardingSeconds) {
        this.boardingSeconds = Optional.ofNullable(boardingSeconds);
        return this;
    }

    public RouteSegment setAlightingSeconds(Integer alightingSeconds) {
        this.alightingSeconds = Optional.ofNullable(alightingSeconds);
        return this;
    }

    @JsonIgnore
    public RouteSegment setStartTime(ZonedDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @JsonProperty
    public RouteSegment setStartTime(String startTime) {
        this.startTime = Utils.parseDateTime(startTime, "startTime");
        return this;
    }

    @JsonIgnore
    public RouteSegment setEndTime(ZonedDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @JsonProperty
    public RouteSegment setEndTime(String endTime) {
        this.endTime = Utils.parseDateTime(endTime, "endTime");
        return this;
    }

    public RouteSegment setIntermediateStops(List<IntermediateStop> intermediateStops) {
        this.intermediateStops = new ArrayList<IntermediateStop>(intermediateStops);
        return this;
    }

    public RouteSegment setBoundingBox(GeoJSONFeature<GeoJSONPolygon> boundingBox) {
        this.boundingBox = Optional.ofNullable(boundingBox);
        return this;
    }

    public RouteSegment setGeometryEncodedPolyLine(String geometryEncodedPolyLine) {
        this.geometryEncodedPolyLine = Optional.ofNullable(geometryEncodedPolyLine);
        return this;
    }

    public RouteSegment setGeometryGeoJson(GeoJSONFeature<GeoJSONLineString> geometryGeoJson) {
        this.geometryGeoJson = Optional.ofNullable(geometryGeoJson);
        return this;
    }

    public RouteSegment setGeometryGeoJsonEdges(GeoJSONFeatureCollection<GeoJSONLineString> geometryGeoJsonEdges) {
        this.geometryGeoJsonEdges = Optional.ofNullable(geometryGeoJsonEdges);
        return this;
    }

    public RouteSegment setNavigationInstructions(List<Instruction<?>> navigationInstructions) {
        this.navigationInstructions = new ArrayList(navigationInstructions);
        return this;
    }

    public RouteSegment setAccessibility(List<Constants.Accessibility> accessibility) {
        this.accessibility = new ArrayList<Constants.Accessibility>(accessibility);
        return this;
    }

    public RouteSegment setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public RouteSegment shiftBySeconds(int amountToAdd) {
        if (this.startTime != null) {
            this.startTime = this.startTime.plus(amountToAdd, ChronoUnit.SECONDS);
        }
        if (this.endTime != null) {
            this.endTime = this.endTime.plus(amountToAdd, ChronoUnit.SECONDS);
        }
        return this;
    }

    public static RouteSegment createShallowCopy(RouteSegment s) {
        RouteSegment copy = new RouteSegment().setNr(s.getNr()).setFrom(s.getFrom()).setTo(s.getTo()).setDistanceMeters(s.getDistanceMeters()).setDurationSeconds(s.getDurationSeconds()).setModeOfTransport(s.getModeOfTransport());
        s.getBoardingSeconds().ifPresent(b -> copy.setBoardingSeconds((Integer)b));
        s.getAlightingSeconds().ifPresent(a -> copy.setAlightingSeconds((Integer)a));
        copy.setStartTime(s.getStartTimeAsZonedDateTime()).setEndTime(s.getEndTimeAsZonedDateTime()).setIntermediateStops(s.getIntermediateStops());
        s.getBoundingBox().ifPresent(b -> copy.setBoundingBox((GeoJSONFeature<GeoJSONPolygon>)b));
        s.getGeometryEncodedPolyLine().ifPresent(g -> copy.setGeometryEncodedPolyLine((String)g));
        s.getGeometryGeoJson().ifPresent(g -> copy.setGeometryGeoJson((GeoJSONFeature<GeoJSONLineString>)g));
        s.getGeometryGeoJsonEdges().ifPresent(g -> copy.setGeometryGeoJsonEdges((GeoJSONFeatureCollection<GeoJSONLineString>)g));
        copy.setNavigationInstructions(s.getNavigationInstructions()).setAccessibility(s.getAccessibility()).setAdditionalInfo(s.getAdditionalInfo());
        return copy;
    }

    @Override
    public void validate() {
        this.validate(false);
    }

    public void validate(boolean strongValidation) {
        Preconditions.checkArgument((this.nr != null ? 1 : 0) != 0, (Object)"nr is mandatory but missing");
        Preconditions.checkArgument((this.from != null ? 1 : 0) != 0, (Object)("from is mandatory but missing for segment #" + this.nr));
        this.from.validate();
        Preconditions.checkArgument((this.to != null ? 1 : 0) != 0, (Object)("to is mandatory but missing for segment #" + this.nr));
        this.to.validate();
        Preconditions.checkArgument((this.distanceMeters != null ? 1 : 0) != 0, (Object)("distanceMeters is mandatory but missing for segment #" + this.nr));
        Preconditions.checkArgument((this.durationSeconds != null ? 1 : 0) != 0, (Object)("durationSeconds is mandatory but missing for segment #" + this.nr));
        Preconditions.checkArgument((this.modeOfTransport != null ? 1 : 0) != 0, (Object)("modeOfTransport is mandatory but missing for segment #" + this.nr));
        Preconditions.checkArgument((this.startTime != null ? 1 : 0) != 0, (Object)("startTime is mandatory but missing for segment #" + this.nr));
        Preconditions.checkArgument((this.endTime != null ? 1 : 0) != 0, (Object)("endTime is mandatory but missing for segment #" + this.nr));
        this.intermediateStops.forEach(s -> s.validate());
        this.boundingBox.ifPresent(b -> b.validate());
        this.geometryGeoJson.ifPresent(g -> g.validate());
        this.geometryGeoJsonEdges.ifPresent(g -> g.validate());
        this.navigationInstructions.forEach(i -> i.validate());
        try {
            Preconditions.checkArgument((this.nr > 0 ? 1 : 0) != 0, (String)"nr must be > 0, but was %s", (Object)this.nr);
            Preconditions.checkArgument((this.distanceMeters >= 0 ? 1 : 0) != 0, (String)"distanceMeters must be >= 0, but was %s for segment #%s", (Object)this.distanceMeters, (Object)this.nr);
            Preconditions.checkArgument((this.durationSeconds >= 0 ? 1 : 0) != 0, (String)"durationSeconds must be >= 0, but was %s for segment #%s", (Object)this.durationSeconds, (Object)this.nr);
            Preconditions.checkArgument((this.alightingSeconds.orElse(0) + this.boardingSeconds.orElse(0) <= this.durationSeconds ? 1 : 0) != 0, (String)"boarding+alighting seconds must be equal to or smaller than the total duration for segment #%s", (Object)this.nr);
            Preconditions.checkArgument((!this.endTime.isBefore(this.startTime) ? 1 : 0) != 0, (String)"startTime must be <= endTime for segment #%s", (Object)this.nr);
            long durationBetweenTimestamps = Duration.between(this.startTime, this.endTime).getSeconds();
            Preconditions.checkArgument(((long)this.durationSeconds.intValue() == durationBetweenTimestamps ? 1 : 0) != 0, (String)"durationSeconds does not match seconds between start & end time: %s!=%s for segment #%s", (Object)this.durationSeconds, (Object)durationBetweenTimestamps, (Object)this.nr);
            String error = "timestamps of intermediate stops must fall in interval between start & end for segment #" + this.nr;
            for (IntermediateStop stop : this.intermediateStops) {
                Preconditions.checkArgument((boolean)Utils.isBetween(this.startTime, stop.getPlannedArrivalTimeAsZonedDateTime(), this.endTime), (Object)error);
                Preconditions.checkArgument((boolean)Utils.isBetween(this.startTime, stop.getPlannedDepartureTimeAsZonedDateTime(), this.endTime), (Object)error);
                Preconditions.checkArgument((boolean)Utils.isBetween(this.startTime, stop.getEstimatedArrivalTimeAsZonedDateTime(), this.endTime), (Object)error);
                Preconditions.checkArgument((boolean)Utils.isBetween(this.startTime, stop.getEstimatedDepartureTimeAsZonedDateTime(), this.endTime), (Object)error);
            }
            boolean geometryPresent = this.geometryEncodedPolyLine.isPresent() || this.geometryGeoJson.isPresent() || this.geometryGeoJsonEdges.isPresent();
            Preconditions.checkArgument((boolean)geometryPresent, (String)"at least one geometry must be present for segment #%s", (Object)this.nr);
        }
        catch (IllegalArgumentException e) {
            if (strongValidation) {
                throw e;
            }
            LOGGER.warn(e.getMessage());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessibility == null ? 0 : this.accessibility.hashCode());
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.alightingSeconds == null ? 0 : this.alightingSeconds.hashCode());
        result = 31 * result + (this.boardingSeconds == null ? 0 : this.boardingSeconds.hashCode());
        result = 31 * result + (this.boundingBox == null ? 0 : this.boundingBox.hashCode());
        result = 31 * result + (this.distanceMeters == null ? 0 : this.distanceMeters.hashCode());
        result = 31 * result + (this.durationSeconds == null ? 0 : this.durationSeconds.hashCode());
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.geometryEncodedPolyLine == null ? 0 : this.geometryEncodedPolyLine.hashCode());
        result = 31 * result + (this.geometryGeoJson == null ? 0 : this.geometryGeoJson.hashCode());
        result = 31 * result + (this.geometryGeoJsonEdges == null ? 0 : this.geometryGeoJsonEdges.hashCode());
        result = 31 * result + (this.intermediateStops == null ? 0 : this.intermediateStops.hashCode());
        result = 31 * result + (this.modeOfTransport == null ? 0 : this.modeOfTransport.hashCode());
        result = 31 * result + (this.navigationInstructions == null ? 0 : this.navigationInstructions.hashCode());
        result = 31 * result + (this.nr == null ? 0 : this.nr.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RouteSegment other = (RouteSegment)obj;
        if (this.accessibility == null ? other.accessibility != null : !this.accessibility.equals(other.accessibility)) {
            return false;
        }
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.alightingSeconds == null ? other.alightingSeconds != null : !this.alightingSeconds.equals(other.alightingSeconds)) {
            return false;
        }
        if (this.boardingSeconds == null ? other.boardingSeconds != null : !this.boardingSeconds.equals(other.boardingSeconds)) {
            return false;
        }
        if (this.boundingBox == null ? other.boundingBox != null : !this.boundingBox.equals(other.boundingBox)) {
            return false;
        }
        if (this.distanceMeters == null ? other.distanceMeters != null : !this.distanceMeters.equals(other.distanceMeters)) {
            return false;
        }
        if (this.durationSeconds == null ? other.durationSeconds != null : !this.durationSeconds.equals(other.durationSeconds)) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.geometryEncodedPolyLine == null ? other.geometryEncodedPolyLine != null : !this.geometryEncodedPolyLine.equals(other.geometryEncodedPolyLine)) {
            return false;
        }
        if (this.geometryGeoJson == null ? other.geometryGeoJson != null : !this.geometryGeoJson.equals(other.geometryGeoJson)) {
            return false;
        }
        if (this.geometryGeoJsonEdges == null ? other.geometryGeoJsonEdges != null : !this.geometryGeoJsonEdges.equals(other.geometryGeoJsonEdges)) {
            return false;
        }
        if (this.intermediateStops == null ? other.intermediateStops != null : !this.intermediateStops.equals(other.intermediateStops)) {
            return false;
        }
        if (this.modeOfTransport == null ? other.modeOfTransport != null : !this.modeOfTransport.equals(other.modeOfTransport)) {
            return false;
        }
        if (this.navigationInstructions == null ? other.navigationInstructions != null : !this.navigationInstructions.equals(other.navigationInstructions)) {
            return false;
        }
        if (this.nr == null ? other.nr != null : !this.nr.equals(other.nr)) {
            return false;
        }
        if (this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime)) {
            return false;
        }
        return !(this.to == null ? other.to != null : !this.to.equals(other.to));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%d: %s %dm %ds (%s ", this.nr, this.modeOfTransport.toString(), this.distanceMeters, this.durationSeconds, Utils.getShortStringDate(this.startTime)));
        if (this.boardingSeconds.isPresent() && this.boardingSeconds.get() > 0) {
            builder.append(String.format("start: %s, departure: %s, ", Utils.getShortStringTime(this.startTime), Utils.getShortStringTime(this.startTime.plus(this.boardingSeconds.get().intValue(), ChronoUnit.SECONDS))));
        } else {
            builder.append(String.format("start: %s, ", Utils.getShortStringTime(this.startTime)));
        }
        if (this.alightingSeconds.isPresent() && this.alightingSeconds.get() > 0) {
            builder.append(String.format("alighting: %s, end: %s", Utils.getShortStringTime(this.endTime.minus(this.alightingSeconds.get().intValue(), ChronoUnit.SECONDS)), Utils.getShortStringTime(this.endTime)));
        } else {
            builder.append(String.format("end: %s", Utils.getShortStringTime(this.endTime)));
        }
        builder.append(")");
        return builder.toString();
    }
}

