/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.RouteSegment;
import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONLineString;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPolygon;
import at.ac.ait.ariadne.routeformat.location.Location;
import at.ac.ait.ariadne.routeformat.util.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class Route
implements Validatable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Route.class);
    private Location<?> from;
    private Location<?> to;
    private int distanceMeters;
    private int durationSeconds;
    private List<RouteSegment> segments = new ArrayList<RouteSegment>();
    private Optional<String> id = Optional.empty();
    private ZonedDateTime startTime = null;
    private ZonedDateTime endTime = null;
    private Optional<String> optimizedFor = Optional.empty();
    private Optional<GeoJSONFeature<GeoJSONPolygon>> boundingBox = Optional.empty();
    private Optional<String> simplifiedGeometryEncodedPolyLine = Optional.empty();
    private Optional<GeoJSONFeature<GeoJSONLineString>> simplifiedGeometryGeoJson = Optional.empty();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public Location<?> getFrom() {
        return this.from;
    }

    @JsonProperty(required=true)
    public Location<?> getTo() {
        return this.to;
    }

    @JsonProperty(required=true)
    public int getDistanceMeters() {
        return this.distanceMeters;
    }

    @JsonProperty(required=true)
    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    @JsonProperty(required=true)
    public List<RouteSegment> getSegments() {
        return this.segments;
    }

    public Optional<String> getId() {
        return this.id;
    }

    public String getStartTime() {
        return Utils.getDateTimeString(this.startTime);
    }

    @JsonIgnore
    public ZonedDateTime getStartTimeAsZonedDateTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return Utils.getDateTimeString(this.endTime);
    }

    @JsonIgnore
    public ZonedDateTime getEndTimeAsZonedDateTime() {
        return this.endTime;
    }

    public Optional<String> getOptimizedFor() {
        return this.optimizedFor;
    }

    public Optional<GeoJSONFeature<GeoJSONPolygon>> getBoundingBox() {
        return this.boundingBox;
    }

    public Optional<String> getSimplifiedGeometryEncodedPolyLine() {
        return this.simplifiedGeometryEncodedPolyLine;
    }

    public Optional<GeoJSONFeature<GeoJSONLineString>> getSimplifiedGeometryGeoJson() {
        return this.simplifiedGeometryGeoJson;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public Route setFrom(Location<?> from) {
        this.from = from;
        return this;
    }

    public Route setTo(Location<?> to) {
        this.to = to;
        return this;
    }

    public Route setDistanceMeters(int distanceMeters) {
        this.distanceMeters = distanceMeters;
        return this;
    }

    public Route setDurationSeconds(int durationSeconds) {
        this.durationSeconds = durationSeconds;
        return this;
    }

    public Route setSegments(List<RouteSegment> segments) {
        this.segments = new ArrayList<RouteSegment>(segments);
        return this;
    }

    public Route setId(String id) {
        this.id = Optional.ofNullable(id);
        return this;
    }

    @JsonIgnore
    public Route setStartTime(ZonedDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @JsonProperty
    public Route setStartTime(String startTime) {
        this.startTime = Utils.parseDateTime(startTime, "startTime");
        return this;
    }

    @JsonIgnore
    public Route setEndTime(ZonedDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    @JsonProperty
    public Route setEndTime(String endTime) {
        this.endTime = Utils.parseDateTime(endTime, "endTime");
        return this;
    }

    public Route setOptimizedFor(String optimizedFor) {
        this.optimizedFor = Optional.ofNullable(optimizedFor);
        return this;
    }

    public Route setBoundingBox(GeoJSONFeature<GeoJSONPolygon> boundingBox) {
        this.boundingBox = Optional.ofNullable(boundingBox);
        return this;
    }

    public Route setSimplifiedGeometryEncodedPolyLine(String simplifiedGeometryEncodedPolyLine) {
        this.simplifiedGeometryEncodedPolyLine = Optional.ofNullable(simplifiedGeometryEncodedPolyLine);
        return this;
    }

    public Route setSimplifiedGeometryGeoJson(GeoJSONFeature<GeoJSONLineString> simplifiedGeometryGeoJson) {
        this.simplifiedGeometryGeoJson = Optional.ofNullable(simplifiedGeometryGeoJson);
        return this;
    }

    public Route setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public static Route createFromLocation(Location<?> location, ZonedDateTime time) {
        return new Route().setFrom(location).setTo(location).setDistanceMeters(0).setDurationSeconds(0).setStartTime(time).setEndTime(time);
    }

    public static Route createFromSegments(List<RouteSegment> segments) {
        Route route = new Route().setSegments(segments);
        if (!segments.isEmpty()) {
            RouteSegment first = segments.get(0);
            RouteSegment last = segments.get(segments.size() - 1);
            route.setFrom(first.getFrom());
            route.setTo(last.getTo());
            route.setStartTime(first.getStartTime());
            route.setEndTime(last.getEndTime());
            route.setDistanceMeters(segments.stream().mapToInt(s -> s.getDistanceMeters()).sum());
            route.setDurationSeconds((int)(Duration.between(route.getStartTimeAsZonedDateTime(), route.getEndTimeAsZonedDateTime()).toMillis() / 1000L));
            Utils.getBoundingBoxFromGeometryGeoJson(segments).ifPresent(b -> route.setBoundingBox((GeoJSONFeature<GeoJSONPolygon>)b));
        }
        return route;
    }

    @Override
    public void validate() {
        this.validate(false);
    }

    public void validate(boolean strongValidation) {
        Preconditions.checkArgument((this.from != null ? 1 : 0) != 0, (Object)"from is mandatory but missing");
        this.from.validate();
        Preconditions.checkArgument((this.to != null ? 1 : 0) != 0, (Object)"to is mandatory but missing");
        this.to.validate();
        Preconditions.checkArgument((this.startTime != null ? 1 : 0) != 0, (Object)"startTime is mandatory but missing");
        Preconditions.checkArgument((this.endTime != null ? 1 : 0) != 0, (Object)"endTime is mandatory but missing");
        this.segments.forEach(s -> s.validate());
        this.boundingBox.ifPresent(b -> b.validate());
        this.simplifiedGeometryGeoJson.ifPresent(g -> g.validate());
        try {
            Preconditions.checkArgument((this.distanceMeters >= 0 ? 1 : 0) != 0, (String)"distanceMeters must be >= 0, but was %s", (int)this.distanceMeters);
            Preconditions.checkArgument((this.durationSeconds >= 0 ? 1 : 0) != 0, (String)"durationSeconds must be >= 0, but was %s", (int)this.durationSeconds);
            Preconditions.checkArgument((!this.endTime.isBefore(this.startTime) ? 1 : 0) != 0, (Object)"startTime must be <= endTime");
            long durationBetweenTimestamps = Duration.between(this.startTime, this.endTime).getSeconds();
            Preconditions.checkArgument(((long)this.durationSeconds == durationBetweenTimestamps ? 1 : 0) != 0, (String)"durationSeconds does not match seconds between start & end time: %s!=%s", (int)this.durationSeconds, (long)durationBetweenTimestamps);
            int durationSecondsSum = this.segments.stream().mapToInt(s -> s.getDurationSeconds()).sum();
            Preconditions.checkArgument((this.durationSeconds == durationSecondsSum ? 1 : 0) != 0, (String)"durationSeconds does not match the sum of durationSeconds of all route segments: %s!=%s", (int)this.durationSeconds, (int)durationSecondsSum);
            int distanceMetersSum = this.segments.stream().mapToInt(s -> s.getDistanceMeters()).sum();
            Preconditions.checkArgument((this.distanceMeters == distanceMetersSum ? 1 : 0) != 0, (String)"distanceMeters does not match the sum of distanceMeters of all route segments: %s!=%s", (int)this.distanceMeters, (int)distanceMetersSum);
        }
        catch (IllegalArgumentException e) {
            if (strongValidation) {
                throw e;
            }
            LOGGER.warn(e.getMessage());
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.boundingBox == null ? 0 : this.boundingBox.hashCode());
        result = 31 * result + this.distanceMeters;
        result = 31 * result + this.durationSeconds;
        result = 31 * result + (this.endTime == null ? 0 : this.endTime.hashCode());
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.optimizedFor == null ? 0 : this.optimizedFor.hashCode());
        result = 31 * result + (this.segments == null ? 0 : this.segments.hashCode());
        result = 31 * result + (this.simplifiedGeometryEncodedPolyLine == null ? 0 : this.simplifiedGeometryEncodedPolyLine.hashCode());
        result = 31 * result + (this.simplifiedGeometryGeoJson == null ? 0 : this.simplifiedGeometryGeoJson.hashCode());
        result = 31 * result + (this.startTime == null ? 0 : this.startTime.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Route other = (Route)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.boundingBox == null ? other.boundingBox != null : !this.boundingBox.equals(other.boundingBox)) {
            return false;
        }
        if (this.distanceMeters != other.distanceMeters) {
            return false;
        }
        if (this.durationSeconds != other.durationSeconds) {
            return false;
        }
        if (this.endTime == null ? other.endTime != null : !this.endTime.equals(other.endTime)) {
            return false;
        }
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.optimizedFor == null ? other.optimizedFor != null : !this.optimizedFor.equals(other.optimizedFor)) {
            return false;
        }
        if (this.segments == null ? other.segments != null : !this.segments.equals(other.segments)) {
            return false;
        }
        if (this.simplifiedGeometryEncodedPolyLine == null ? other.simplifiedGeometryEncodedPolyLine != null : !this.simplifiedGeometryEncodedPolyLine.equals(other.simplifiedGeometryEncodedPolyLine)) {
            return false;
        }
        if (this.simplifiedGeometryGeoJson == null ? other.simplifiedGeometryGeoJson != null : !this.simplifiedGeometryGeoJson.equals(other.simplifiedGeometryGeoJson)) {
            return false;
        }
        if (this.startTime == null ? other.startTime != null : !this.startTime.equals(other.startTime)) {
            return false;
        }
        return !(this.to == null ? other.to != null : !this.to.equals(other.to));
    }

    public String toString() {
        return "Route [from=" + this.from + ", to=" + this.to + ", distanceMeters=" + this.distanceMeters + ", durationSeconds=" + this.durationSeconds + ", id=" + this.id + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", optimizedFor=" + this.optimizedFor + ", segments=" + this.segments.size() + "]";
    }
}

