/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.ModeOfTransport;
import at.ac.ait.ariadne.routeformat.RequestPTModeOfTransport;
import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONMultiPolygon;
import at.ac.ait.ariadne.routeformat.location.Location;
import at.ac.ait.ariadne.routeformat.util.Utils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=RequestModeOfTransport.class, name="RequestModeOfTransport"), @JsonSubTypes.Type(value=RequestPTModeOfTransport.class, name="RequestPTModeOfTransport")})
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class RequestModeOfTransport<T extends RequestModeOfTransport<T>>
implements Validatable {
    ModeOfTransport modeOfTransport;
    private Optional<Integer> maximumDistanceMeters = Optional.empty();
    private Optional<Integer> maximumTravelTimeSeconds = Optional.empty();
    private Optional<Integer> userAffinity = Optional.empty();
    private Optional<String> speed = Optional.empty();
    private List<Location<?>> locations = new ArrayList();
    private Optional<GeoJSONFeature<GeoJSONMultiPolygon>> forbiddenAreas = Optional.empty();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public ModeOfTransport getModeOfTransport() {
        return this.modeOfTransport;
    }

    public Optional<Integer> getMaximumDistanceMeters() {
        return this.maximumDistanceMeters;
    }

    public Optional<Integer> getMaximumTravelTimeSeconds() {
        return this.maximumTravelTimeSeconds;
    }

    public Optional<Integer> getUserAffinity() {
        return this.userAffinity;
    }

    public Optional<String> getSpeed() {
        return this.speed;
    }

    @JsonProperty
    public List<Location<?>> getLocations() {
        return this.locations;
    }

    @JsonProperty
    public Optional<GeoJSONFeature<GeoJSONMultiPolygon>> getForbiddenAreas() {
        return this.forbiddenAreas;
    }

    @JsonProperty
    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public T setModeOfTransport(ModeOfTransport modeOfTransport) {
        this.modeOfTransport = modeOfTransport;
        return (T)this;
    }

    public T setMaximumDistanceMeters(Integer maximumDistanceMeters) {
        this.maximumDistanceMeters = Optional.ofNullable(maximumDistanceMeters);
        return (T)this;
    }

    public T setMaximumTravelTimeSeconds(Integer maximumTravelTimeSeconds) {
        this.maximumTravelTimeSeconds = Optional.ofNullable(maximumTravelTimeSeconds);
        return (T)this;
    }

    public T setUserAffinity(Integer userAffinity) {
        this.userAffinity = Optional.ofNullable(userAffinity);
        return (T)this;
    }

    public T setSpeed(String speed) {
        this.speed = Optional.ofNullable(speed);
        return (T)this;
    }

    public T setLocations(List<Location<?>> locations) {
        this.locations = new ArrayList(locations);
        return (T)this;
    }

    public T setForbiddenAreas(GeoJSONFeature<GeoJSONMultiPolygon> forbiddenAreas) {
        this.forbiddenAreas = Optional.ofNullable(forbiddenAreas);
        return (T)this;
    }

    public T setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return (T)this;
    }

    public static RequestModeOfTransport<?> createMinimal(ModeOfTransport modeOfTransport) {
        return new RequestModeOfTransport().setModeOfTransport(modeOfTransport);
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.modeOfTransport != null ? 1 : 0) != 0, (Object)"modeOfTransport is mandatory but missing");
        this.modeOfTransport.validate();
        this.locations.forEach(l -> l.validate());
        Utils.checkPositiveIntegerOrEmpty(this.maximumDistanceMeters, "maximumDistanceMeters");
        Utils.checkPositiveIntegerOrEmpty(this.maximumTravelTimeSeconds, "maximumTravelTimeSeconds");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.forbiddenAreas == null ? 0 : this.forbiddenAreas.hashCode());
        result = 31 * result + (this.locations == null ? 0 : this.locations.hashCode());
        result = 31 * result + (this.maximumDistanceMeters == null ? 0 : this.maximumDistanceMeters.hashCode());
        result = 31 * result + (this.maximumTravelTimeSeconds == null ? 0 : this.maximumTravelTimeSeconds.hashCode());
        result = 31 * result + (this.userAffinity == null ? 0 : this.userAffinity.hashCode());
        result = 31 * result + (this.modeOfTransport == null ? 0 : this.modeOfTransport.hashCode());
        result = 31 * result + (this.speed == null ? 0 : this.speed.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestModeOfTransport other = (RequestModeOfTransport)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.forbiddenAreas == null ? other.forbiddenAreas != null : !this.forbiddenAreas.equals(other.forbiddenAreas)) {
            return false;
        }
        if (this.locations == null ? other.locations != null : !this.locations.equals(other.locations)) {
            return false;
        }
        if (this.maximumDistanceMeters == null ? other.maximumDistanceMeters != null : !this.maximumDistanceMeters.equals(other.maximumDistanceMeters)) {
            return false;
        }
        if (this.maximumTravelTimeSeconds == null ? other.maximumTravelTimeSeconds != null : !this.maximumTravelTimeSeconds.equals(other.maximumTravelTimeSeconds)) {
            return false;
        }
        if (this.userAffinity == null ? other.userAffinity != null : !this.userAffinity.equals(other.userAffinity)) {
            return false;
        }
        if (this.modeOfTransport == null ? other.modeOfTransport != null : !this.modeOfTransport.equals(other.modeOfTransport)) {
            return false;
        }
        return !(this.speed == null ? other.speed != null : !this.speed.equals(other.speed));
    }

    public String toString() {
        return "RequestModeOfTransport [modeOfTransport=" + this.modeOfTransport + ", maximumDistanceMeters=" + this.maximumDistanceMeters + ", maximumTravelTimeSeconds=" + this.maximumTravelTimeSeconds + ", userAffinity=" + this.userAffinity + ", speed=" + this.speed + ", locations=" + this.locations + ", forbiddenAreas=" + this.forbiddenAreas + ", additionalInfo=" + this.additionalInfo + "]";
    }
}

