/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.Operator;
import at.ac.ait.ariadne.routeformat.Service;
import at.ac.ait.ariadne.routeformat.Validatable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class ModeOfTransport
implements Validatable {
    public static final ModeOfTransport STANDARD_FOOT = ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.FOOT).setId("foot").setColor("#377eb8");
    public static final ModeOfTransport STANDARD_BICYCLE = ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.BICYCLE).setId("bicycle").setColor("#4daf4a");
    public static final ModeOfTransport STANDARD_MOTORCYCLE = ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.MOTORCYCLE).setId("motorcycle").setColor("#ff7f00");
    public static final ModeOfTransport STANDARD_CAR = ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.CAR).setId("car").setColor("#e41a1c");
    public static final ModeOfTransport STANDARD_TRANSFER = ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.TRANSFER).setId("transfer").setColor("#a088a3");
    public static final ModeOfTransport STANDARD_PUBLIC_TRANSPORT = ModeOfTransport.createMinimal(Constants.GeneralizedModeOfTransportType.PUBLIC_TRANSPORT).setId("publictransport").setColor("#984ea3");
    private Constants.GeneralizedModeOfTransportType generalizedType;
    private Optional<Constants.DetailedModeOfTransportType> detailedType = Optional.empty();
    private Optional<String> id = Optional.empty();
    private Optional<Service> service = Optional.empty();
    private Optional<Operator> operator = Optional.empty();
    private Optional<Boolean> electric = Optional.empty();
    private Optional<Integer> weightKg = Optional.empty();
    private Optional<Integer> widthMm = Optional.empty();
    private Optional<Integer> heightMm = Optional.empty();
    private Optional<Integer> lengthMm = Optional.empty();
    private Optional<Constants.Sharing> sharingType = Optional.empty();
    private Set<Constants.VehicleAccessibility> accessibility = new TreeSet<Constants.VehicleAccessibility>();
    private Optional<String> color = Optional.empty();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public Constants.GeneralizedModeOfTransportType getGeneralizedType() {
        return this.generalizedType;
    }

    public Optional<Constants.DetailedModeOfTransportType> getDetailedType() {
        return this.detailedType;
    }

    public Optional<String> getId() {
        return this.id;
    }

    public Optional<Service> getService() {
        return this.service;
    }

    public Optional<Operator> getOperator() {
        return this.operator;
    }

    public Optional<Boolean> getElectric() {
        return this.electric;
    }

    public Optional<Integer> getWeightKg() {
        return this.weightKg;
    }

    public Optional<Integer> getWidthMm() {
        return this.widthMm;
    }

    public Optional<Integer> getHeightMm() {
        return this.heightMm;
    }

    public Optional<Integer> getLengthMm() {
        return this.lengthMm;
    }

    public Optional<Constants.Sharing> getSharingType() {
        return this.sharingType;
    }

    public Set<Constants.VehicleAccessibility> getAccessibility() {
        return this.accessibility;
    }

    public Optional<String> getColor() {
        return this.color;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public ModeOfTransport setGeneralizedType(Constants.GeneralizedModeOfTransportType generalizedType) {
        this.generalizedType = generalizedType;
        return this;
    }

    public ModeOfTransport setDetailedType(Constants.DetailedModeOfTransportType detailedType) {
        this.detailedType = Optional.ofNullable(detailedType);
        this.generalizedType = detailedType == null ? null : detailedType.getGeneralizedType();
        this.detailedType = Optional.ofNullable(detailedType);
        return this;
    }

    public ModeOfTransport setId(String id) {
        this.id = Optional.ofNullable(id);
        return this;
    }

    public ModeOfTransport setService(Service service) {
        this.service = Optional.ofNullable(service);
        return this;
    }

    public ModeOfTransport setOperator(Operator operator) {
        this.operator = Optional.ofNullable(operator);
        return this;
    }

    public ModeOfTransport setElectric(boolean electric) {
        this.electric = Optional.ofNullable(electric);
        return this;
    }

    public ModeOfTransport setWeightKg(Integer weightKg) {
        this.weightKg = Optional.ofNullable(weightKg);
        return this;
    }

    public ModeOfTransport setWidthMm(Integer widthMm) {
        this.widthMm = Optional.ofNullable(widthMm);
        return this;
    }

    public ModeOfTransport setHeightMm(Integer heightMm) {
        this.heightMm = Optional.ofNullable(heightMm);
        return this;
    }

    public ModeOfTransport setLengthMm(Integer lengthMm) {
        this.lengthMm = Optional.ofNullable(lengthMm);
        return this;
    }

    public ModeOfTransport setSharingType(Constants.Sharing sharingType) {
        this.sharingType = Optional.ofNullable(sharingType);
        return this;
    }

    public ModeOfTransport setAccessibility(Set<Constants.VehicleAccessibility> accessibility) {
        this.accessibility = new TreeSet<Constants.VehicleAccessibility>(accessibility);
        return this;
    }

    public ModeOfTransport setColor(String color) {
        this.color = Optional.ofNullable(color);
        return this;
    }

    public ModeOfTransport setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public static ModeOfTransport createMinimal(Constants.GeneralizedModeOfTransportType generalizedType) {
        return new ModeOfTransport().setGeneralizedType(generalizedType);
    }

    public static ModeOfTransport createMinimal(Constants.DetailedModeOfTransportType detailedType) {
        return new ModeOfTransport().setDetailedType(detailedType);
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.generalizedType != null ? 1 : 0) != 0, (Object)"generalizedType is mandatory but missing");
        this.detailedType.ifPresent(d -> Preconditions.checkArgument((d.getGeneralizedType() == this.generalizedType ? 1 : 0) != 0, (Object)"mode of transpor types do not match"));
        this.service.ifPresent(s -> s.validate());
        this.operator.ifPresent(o -> o.validate());
        if (this.color.isPresent()) {
            String colorStr = this.color.get();
            String error = "color must be represented as hash-prepended six-digit hexadecimal String but was %s";
            Preconditions.checkArgument((boolean)colorStr.startsWith("#"), (String)error, (Object)colorStr);
            Preconditions.checkArgument((colorStr.length() == 7 ? 1 : 0) != 0, (String)error, (Object)colorStr);
            try {
                Long.parseLong(colorStr.substring(1, 7), 16);
            }
            catch (NumberFormatException e) {
                Preconditions.checkArgument((boolean)false, (String)error, (Object)colorStr);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessibility == null ? 0 : this.accessibility.hashCode());
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.detailedType == null ? 0 : this.detailedType.hashCode());
        result = 31 * result + (this.electric == null ? 0 : this.electric.hashCode());
        result = 31 * result + (this.generalizedType == null ? 0 : this.generalizedType.hashCode());
        result = 31 * result + (this.heightMm == null ? 0 : this.heightMm.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.lengthMm == null ? 0 : this.lengthMm.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        result = 31 * result + (this.sharingType == null ? 0 : this.sharingType.hashCode());
        result = 31 * result + (this.weightKg == null ? 0 : this.weightKg.hashCode());
        result = 31 * result + (this.widthMm == null ? 0 : this.widthMm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModeOfTransport other = (ModeOfTransport)obj;
        if (this.accessibility == null ? other.accessibility != null : !this.accessibility.equals(other.accessibility)) {
            return false;
        }
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        if (this.detailedType == null ? other.detailedType != null : !this.detailedType.equals(other.detailedType)) {
            return false;
        }
        if (this.electric == null ? other.electric != null : !this.electric.equals(other.electric)) {
            return false;
        }
        if (this.generalizedType != other.generalizedType) {
            return false;
        }
        if (this.heightMm == null ? other.heightMm != null : !this.heightMm.equals(other.heightMm)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.lengthMm == null ? other.lengthMm != null : !this.lengthMm.equals(other.lengthMm)) {
            return false;
        }
        if (this.operator == null ? other.operator != null : !this.operator.equals(other.operator)) {
            return false;
        }
        if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
            return false;
        }
        if (this.sharingType == null ? other.sharingType != null : !this.sharingType.equals(other.sharingType)) {
            return false;
        }
        if (this.weightKg == null ? other.weightKg != null : !this.weightKg.equals(other.weightKg)) {
            return false;
        }
        return !(this.widthMm == null ? other.widthMm != null : !this.widthMm.equals(other.widthMm));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.generalizedType == null ? "null" : this.generalizedType.name());
        this.detailedType.ifPresent(d -> builder.append("-" + (Object)d));
        this.service.ifPresent(s -> builder.append(" " + s.toString()));
        return builder.toString();
    }
}

