/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.location.Location;
import at.ac.ait.ariadne.routeformat.util.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class IntermediateStop
implements Validatable {
    private Location<?> stop;
    private Optional<ZonedDateTime> plannedArrivalTime = Optional.empty();
    private Optional<ZonedDateTime> plannedDepartureTime = Optional.empty();
    private Optional<ZonedDateTime> estimatedArrivalTime = Optional.empty();
    private Optional<ZonedDateTime> estimatedDepartureTime = Optional.empty();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    public Location<?> getStop() {
        return this.stop;
    }

    public Optional<String> getPlannedArrivalTime() {
        return this.plannedArrivalTime.map(time -> Utils.getDateTimeString(time));
    }

    @JsonIgnore
    public Optional<ZonedDateTime> getPlannedArrivalTimeAsZonedDateTime() {
        return this.plannedArrivalTime;
    }

    public Optional<String> getPlannedDepartureTime() {
        return this.plannedDepartureTime.map(time -> Utils.getDateTimeString(time));
    }

    @JsonIgnore
    public Optional<ZonedDateTime> getPlannedDepartureTimeAsZonedDateTime() {
        return this.plannedDepartureTime;
    }

    public Optional<String> getEstimatedArrivalTime() {
        return this.estimatedArrivalTime.map(time -> Utils.getDateTimeString(time));
    }

    @JsonIgnore
    public Optional<ZonedDateTime> getEstimatedArrivalTimeAsZonedDateTime() {
        return this.estimatedArrivalTime;
    }

    public Optional<String> getEstimatedDepartureTime() {
        return this.estimatedDepartureTime.map(time -> Utils.getDateTimeString(time));
    }

    @JsonIgnore
    public Optional<ZonedDateTime> getEstimatedDepartureTimeAsZonedDateTime() {
        return this.estimatedDepartureTime;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public IntermediateStop setStop(Location<?> stop) {
        this.stop = stop;
        return this;
    }

    @JsonIgnore
    public IntermediateStop setPlannedArrivalTime(ZonedDateTime plannedArrivalTime) {
        this.plannedArrivalTime = Optional.ofNullable(plannedArrivalTime);
        return this;
    }

    @JsonProperty
    public IntermediateStop setPlannedArrivalTime(String plannedArrivalTime) {
        this.plannedArrivalTime = Optional.ofNullable(Utils.parseDateTime(plannedArrivalTime, "plannedArrivalTime"));
        return this;
    }

    @JsonIgnore
    public IntermediateStop setPlannedDepartureTime(ZonedDateTime plannedDepartureTime) {
        this.plannedDepartureTime = Optional.ofNullable(plannedDepartureTime);
        return this;
    }

    @JsonProperty
    public IntermediateStop setPlannedDepartureTime(String plannedDepartureTime) {
        this.plannedDepartureTime = Optional.ofNullable(Utils.parseDateTime(plannedDepartureTime, "plannedDepartureTime"));
        return this;
    }

    @JsonIgnore
    public IntermediateStop setEstimatedArrivalTime(ZonedDateTime estimatedArrivalTime) {
        this.estimatedArrivalTime = Optional.ofNullable(estimatedArrivalTime);
        return this;
    }

    @JsonProperty
    public IntermediateStop setEstimatedArrivalTime(String estimatedArrivalTime) {
        this.estimatedArrivalTime = Optional.ofNullable(Utils.parseDateTime(estimatedArrivalTime, "estimatedArrivalTime"));
        return this;
    }

    @JsonIgnore
    public IntermediateStop setEstimatedDepartureTime(ZonedDateTime estimatedDepartureTime) {
        this.estimatedDepartureTime = Optional.ofNullable(estimatedDepartureTime);
        return this;
    }

    @JsonProperty
    public IntermediateStop setEstimatedDepartureTime(String estimatedDepartureTime) {
        this.estimatedDepartureTime = Optional.ofNullable(Utils.parseDateTime(estimatedDepartureTime, "estimatedDepartureTime"));
        return this;
    }

    public IntermediateStop setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public static IntermediateStop createMinimal(Location<?> stop) {
        return new IntermediateStop().setStop(stop);
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.stop != null ? 1 : 0) != 0, (Object)"stop is mandatory but missing");
        this.stop.validate();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.estimatedArrivalTime == null ? 0 : this.estimatedArrivalTime.hashCode());
        result = 31 * result + (this.estimatedDepartureTime == null ? 0 : this.estimatedDepartureTime.hashCode());
        result = 31 * result + (this.plannedArrivalTime == null ? 0 : this.plannedArrivalTime.hashCode());
        result = 31 * result + (this.plannedDepartureTime == null ? 0 : this.plannedDepartureTime.hashCode());
        result = 31 * result + (this.stop == null ? 0 : this.stop.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntermediateStop other = (IntermediateStop)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.estimatedArrivalTime == null ? other.estimatedArrivalTime != null : !this.estimatedArrivalTime.equals(other.estimatedArrivalTime)) {
            return false;
        }
        if (this.estimatedDepartureTime == null ? other.estimatedDepartureTime != null : !this.estimatedDepartureTime.equals(other.estimatedDepartureTime)) {
            return false;
        }
        if (this.plannedArrivalTime == null ? other.plannedArrivalTime != null : !this.plannedArrivalTime.equals(other.plannedArrivalTime)) {
            return false;
        }
        if (this.plannedDepartureTime == null ? other.plannedDepartureTime != null : !this.plannedDepartureTime.equals(other.plannedDepartureTime)) {
            return false;
        }
        return !(this.stop == null ? other.stop != null : !this.stop.equals(other.stop));
    }

    public String toString() {
        return "IntermediateStop [stop=" + this.stop + ", plannedArrivalTime=" + this.plannedArrivalTime + ", plannedDepartureTime=" + this.plannedDepartureTime + ", estimatedArrivalTime=" + this.estimatedArrivalTime + ", estimatedDepartureTime=" + this.estimatedDepartureTime + ", additionalInfo=" + this.additionalInfo + "]";
    }
}

