/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.location;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.location.Location;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class PublicTransportStop
extends Location<PublicTransportStop> {
    private Optional<String> name = Optional.absent();
    private Optional<String> platform = Optional.absent();
    private Map<String, Constants.DetailedModeOfTransportType> relatedLines = new TreeMap<String, Constants.DetailedModeOfTransportType>();
    private List<Constants.Accessibility> accessibility = new ArrayList<Constants.Accessibility>();

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getPlatform() {
        return this.platform;
    }

    public Map<String, Constants.DetailedModeOfTransportType> getRelatedLines() {
        return this.relatedLines;
    }

    public List<Constants.Accessibility> getAccessibility() {
        return this.accessibility;
    }

    public PublicTransportStop setName(String name) {
        this.name = Optional.fromNullable((Object)name);
        return this;
    }

    public PublicTransportStop setPlatform(String platform) {
        this.platform = Optional.fromNullable((Object)platform);
        return this;
    }

    public PublicTransportStop setRelatedLines(Map<String, Constants.DetailedModeOfTransportType> relatedLines) {
        this.relatedLines = new TreeMap<String, Constants.DetailedModeOfTransportType>(relatedLines);
        return this;
    }

    public PublicTransportStop setAccessibility(List<Constants.Accessibility> accessibility) {
        this.accessibility = Lists.newArrayList(accessibility);
        return this;
    }

    public static PublicTransportStop createMinimal(GeoJSONCoordinate position) {
        return (PublicTransportStop)new PublicTransportStop().setCoordinate(position);
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.accessibility == null ? 0 : this.accessibility.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
        result = 31 * result + (this.relatedLines == null ? 0 : this.relatedLines.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PublicTransportStop other = (PublicTransportStop)obj;
        if (this.accessibility == null ? other.accessibility != null : !this.accessibility.equals(other.accessibility)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.platform == null ? other.platform != null : !this.platform.equals(other.platform)) {
            return false;
        }
        return !(this.relatedLines == null ? other.relatedLines != null : !this.relatedLines.equals(other.relatedLines));
    }

    @Override
    public String toString() {
        return super.toString() + " -> PublicTransportStop [name=" + this.name + ", platform=" + this.platform + ", relatedLines=" + this.relatedLines + ", accessibility=" + this.accessibility + "]";
    }
}

