/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.instruction;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.instruction.Instruction;
import at.ac.ait.ariadne.routeformat.instruction.Landmark;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RoadInstruction
extends Instruction<RoadInstruction> {
    private SubType subType;
    private Optional<Constants.GeneralizedModeOfTransportType> modeOfTransport = Optional.absent();
    private Optional<Constants.TurnDirection> turnDirection = Optional.absent();
    private Optional<Constants.CompassDirection> compassDirection = Optional.absent();
    private Optional<Boolean> roadChange = Optional.absent();
    private Optional<String> ontoStreetName = Optional.absent();
    private Optional<Constants.FormOfWay> ontoFormOfWay = Optional.absent();
    private Optional<Boolean> enterBridge = Optional.absent();
    private Optional<Constants.Tunnel> enterTunnel = Optional.absent();
    private Optional<Boolean> ontoRightSideOfRoad = Optional.absent();
    private Optional<Constants.RoadCrossing> crossing = Optional.absent();
    private Optional<Integer> continueMeters = Optional.absent();
    private Optional<Integer> continueSeconds = Optional.absent();
    private Optional<String> continueUntilIntersectingStreetName = Optional.absent();
    private Optional<Landmark> landmark = Optional.absent();
    private Optional<Landmark> confirmationLandmark = Optional.absent();

    @JsonProperty(required=true)
    public SubType getSubType() {
        return this.subType;
    }

    public Optional<Constants.GeneralizedModeOfTransportType> getModeOfTransport() {
        return this.modeOfTransport;
    }

    public Optional<Constants.TurnDirection> getTurnDirection() {
        return this.turnDirection;
    }

    public Optional<Constants.CompassDirection> getCompassDirection() {
        return this.compassDirection;
    }

    public Optional<Boolean> getRoadChange() {
        return this.roadChange;
    }

    public Optional<String> getOntoStreetName() {
        return this.ontoStreetName;
    }

    public Optional<Constants.FormOfWay> getOntoFormOfWay() {
        return this.ontoFormOfWay;
    }

    public Optional<Boolean> getEnterBridge() {
        return this.enterBridge;
    }

    public Optional<Constants.Tunnel> getEnterTunnel() {
        return this.enterTunnel;
    }

    public Optional<Boolean> getOntoRightSideOfRoad() {
        return this.ontoRightSideOfRoad;
    }

    public Optional<Constants.RoadCrossing> getCrossing() {
        return this.crossing;
    }

    public Optional<Integer> getContinueMeters() {
        return this.continueMeters;
    }

    public Optional<Integer> getContinueSeconds() {
        return this.continueSeconds;
    }

    public Optional<String> getContinueUntilIntersectingStreetName() {
        return this.continueUntilIntersectingStreetName;
    }

    public Optional<Landmark> getLandmark() {
        return this.landmark;
    }

    public Optional<Landmark> getConfirmationLandmark() {
        return this.confirmationLandmark;
    }

    public RoadInstruction setSubType(SubType subType) {
        this.subType = subType;
        return this;
    }

    public RoadInstruction setModeOfTransport(Constants.GeneralizedModeOfTransportType modeOfTransport) {
        this.modeOfTransport = Optional.fromNullable((Object)((Object)modeOfTransport));
        return this;
    }

    public RoadInstruction setTurnDirection(Constants.TurnDirection turnDirection) {
        this.turnDirection = Optional.fromNullable((Object)((Object)turnDirection));
        return this;
    }

    public RoadInstruction setCompassDirection(Constants.CompassDirection compassDirection) {
        this.compassDirection = Optional.fromNullable((Object)((Object)compassDirection));
        return this;
    }

    public RoadInstruction setRoadChange(Boolean roadChange) {
        this.roadChange = Optional.fromNullable((Object)roadChange);
        return this;
    }

    public RoadInstruction setOntoStreetName(String ontoStreetName) {
        this.ontoStreetName = Optional.fromNullable((Object)ontoStreetName);
        return this;
    }

    public RoadInstruction setOntoFormOfWay(Constants.FormOfWay ontoFormOfWay) {
        this.ontoFormOfWay = Optional.fromNullable((Object)((Object)ontoFormOfWay));
        return this;
    }

    public RoadInstruction setEnterBridge(Boolean enterBridge) {
        this.enterBridge = Optional.fromNullable((Object)enterBridge);
        return this;
    }

    public RoadInstruction setEnterTunnel(Constants.Tunnel enterTunnel) {
        this.enterTunnel = Optional.fromNullable((Object)((Object)enterTunnel));
        return this;
    }

    public RoadInstruction setOntoRightSideOfRoad(Boolean ontoRightSideOfRoad) {
        this.ontoRightSideOfRoad = Optional.fromNullable((Object)ontoRightSideOfRoad);
        return this;
    }

    public RoadInstruction setCrossing(Constants.RoadCrossing crossing) {
        this.crossing = Optional.fromNullable((Object)((Object)crossing));
        return this;
    }

    public RoadInstruction setContinueMeters(Integer continueMeters) {
        this.continueMeters = Optional.fromNullable((Object)continueMeters);
        return this;
    }

    public RoadInstruction setContinueSeconds(Integer continueSeconds) {
        this.continueSeconds = Optional.fromNullable((Object)continueSeconds);
        return this;
    }

    public RoadInstruction setContinueUntilIntersectingStreetName(String continueUntilIntersectingStreetName) {
        this.continueUntilIntersectingStreetName = Optional.fromNullable((Object)continueUntilIntersectingStreetName);
        return this;
    }

    public RoadInstruction setLandmark(Landmark landmark) {
        this.landmark = Optional.fromNullable((Object)landmark);
        return this;
    }

    public RoadInstruction setConfirmationLandmark(Landmark confirmationLandmark) {
        this.confirmationLandmark = Optional.fromNullable((Object)confirmationLandmark);
        return this;
    }

    public static RoadInstruction createMinimalRouteStart(GeoJSONCoordinate position, Optional<String> ontoStreetName, Optional<Constants.FormOfWay> ontoFormOfWay) {
        return ((RoadInstruction)new RoadInstruction().setPosition(position)).setSubType(SubType.ROUTE_START).setOntoStreetName((String)ontoStreetName.orNull()).setOntoFormOfWay((Constants.FormOfWay)((Object)ontoFormOfWay.orNull()));
    }

    public static RoadInstruction createMinimalOnRoute(GeoJSONCoordinate position, Constants.TurnDirection turnDirection, Optional<String> ontoStreetName, Optional<Constants.FormOfWay> ontoFormOfWay) {
        return ((RoadInstruction)new RoadInstruction().setPosition(position)).setSubType(RoadInstruction.getSubType(turnDirection)).setTurnDirection(turnDirection).setOntoStreetName((String)ontoStreetName.orNull()).setOntoFormOfWay((Constants.FormOfWay)((Object)ontoFormOfWay.orNull()));
    }

    public static RoadInstruction createMinimalRouteEnd(GeoJSONCoordinate position, Optional<String> onStreetName, Optional<Constants.FormOfWay> onFormOfWay) {
        return ((RoadInstruction)new RoadInstruction().setPosition(position)).setSubType(SubType.ROUTE_END).setOntoStreetName((String)onStreetName.orNull()).setOntoFormOfWay((Constants.FormOfWay)((Object)onFormOfWay.orNull()));
    }

    private static SubType getSubType(Constants.TurnDirection turnDirection) {
        if (turnDirection == Constants.TurnDirection.U_TURN) {
            return SubType.U_TURN;
        }
        if (turnDirection == Constants.TurnDirection.STRAIGHT) {
            return SubType.STRAIGHT;
        }
        return SubType.TURN;
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.subType != null ? 1 : 0) != 0, (Object)"subType is mandatory but missing");
        Preconditions.checkArgument((this.ontoStreetName.isPresent() || this.ontoFormOfWay.isPresent() ? 1 : 0) != 0, (Object)"at least one onto-type is required");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.compassDirection == null ? 0 : this.compassDirection.hashCode());
        result = 31 * result + (this.confirmationLandmark == null ? 0 : this.confirmationLandmark.hashCode());
        result = 31 * result + (this.continueMeters == null ? 0 : this.continueMeters.hashCode());
        result = 31 * result + (this.continueSeconds == null ? 0 : this.continueSeconds.hashCode());
        result = 31 * result + (this.continueUntilIntersectingStreetName == null ? 0 : this.continueUntilIntersectingStreetName.hashCode());
        result = 31 * result + (this.crossing == null ? 0 : this.crossing.hashCode());
        result = 31 * result + (this.enterBridge == null ? 0 : this.enterBridge.hashCode());
        result = 31 * result + (this.enterTunnel == null ? 0 : this.enterTunnel.hashCode());
        result = 31 * result + (this.landmark == null ? 0 : this.landmark.hashCode());
        result = 31 * result + (this.modeOfTransport == null ? 0 : this.modeOfTransport.hashCode());
        result = 31 * result + (this.ontoFormOfWay == null ? 0 : this.ontoFormOfWay.hashCode());
        result = 31 * result + (this.ontoRightSideOfRoad == null ? 0 : this.ontoRightSideOfRoad.hashCode());
        result = 31 * result + (this.ontoStreetName == null ? 0 : this.ontoStreetName.hashCode());
        result = 31 * result + (this.roadChange == null ? 0 : this.roadChange.hashCode());
        result = 31 * result + (this.subType == null ? 0 : this.subType.hashCode());
        result = 31 * result + (this.turnDirection == null ? 0 : this.turnDirection.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoadInstruction other = (RoadInstruction)obj;
        if (this.compassDirection == null ? other.compassDirection != null : !this.compassDirection.equals(other.compassDirection)) {
            return false;
        }
        if (this.confirmationLandmark == null ? other.confirmationLandmark != null : !this.confirmationLandmark.equals(other.confirmationLandmark)) {
            return false;
        }
        if (this.continueMeters == null ? other.continueMeters != null : !this.continueMeters.equals(other.continueMeters)) {
            return false;
        }
        if (this.continueSeconds == null ? other.continueSeconds != null : !this.continueSeconds.equals(other.continueSeconds)) {
            return false;
        }
        if (this.continueUntilIntersectingStreetName == null ? other.continueUntilIntersectingStreetName != null : !this.continueUntilIntersectingStreetName.equals(other.continueUntilIntersectingStreetName)) {
            return false;
        }
        if (this.crossing == null ? other.crossing != null : !this.crossing.equals(other.crossing)) {
            return false;
        }
        if (this.enterBridge == null ? other.enterBridge != null : !this.enterBridge.equals(other.enterBridge)) {
            return false;
        }
        if (this.enterTunnel == null ? other.enterTunnel != null : !this.enterTunnel.equals(other.enterTunnel)) {
            return false;
        }
        if (this.landmark == null ? other.landmark != null : !this.landmark.equals(other.landmark)) {
            return false;
        }
        if (this.modeOfTransport == null ? other.modeOfTransport != null : !this.modeOfTransport.equals(other.modeOfTransport)) {
            return false;
        }
        if (this.ontoFormOfWay == null ? other.ontoFormOfWay != null : !this.ontoFormOfWay.equals(other.ontoFormOfWay)) {
            return false;
        }
        if (this.ontoRightSideOfRoad == null ? other.ontoRightSideOfRoad != null : !this.ontoRightSideOfRoad.equals(other.ontoRightSideOfRoad)) {
            return false;
        }
        if (this.ontoStreetName == null ? other.ontoStreetName != null : !this.ontoStreetName.equals(other.ontoStreetName)) {
            return false;
        }
        if (this.roadChange == null ? other.roadChange != null : !this.roadChange.equals(other.roadChange)) {
            return false;
        }
        if (this.subType != other.subType) {
            return false;
        }
        return !(this.turnDirection == null ? other.turnDirection != null : !this.turnDirection.equals(other.turnDirection));
    }

    @Override
    public String toString() {
        return super.toString() + " -> RoadInstruction [subType=" + (Object)((Object)this.subType) + ", modeOfTransport=" + this.modeOfTransport + ", turnDirection=" + this.turnDirection + ", compassDirection=" + this.compassDirection + ", roadChange=" + this.roadChange + ", ontoStreetName=" + this.ontoStreetName + ", ontoFormOfWay=" + this.ontoFormOfWay + ", enterBridge=" + this.enterBridge + ", enterTunnel=" + this.enterTunnel + ", ontoRightSideOfRoad=" + this.ontoRightSideOfRoad + ", continueMeters=" + this.continueMeters + ", continueSeconds=" + this.continueSeconds + ", continueUntilIntersectingStreetName=" + this.continueUntilIntersectingStreetName + ", landmark=" + this.landmark + ", confirmationLandmark=" + this.confirmationLandmark + "]";
    }

    public static enum SubType {
        ROUTE_START,
        ROUTE_START_UNMENTIONED,
        ROUTE_END,
        STRAIGHT,
        TURN,
        U_TURN,
        SWITCH_SIDE_OF_ROAD;

    }
}

