/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.geojson;

import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONGeometryObject;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONUtil;
import at.ac.ait.ariadne.routeformat.geojson.WKTUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class GeoJSONPoint
implements GeoJSONGeometryObject {
    private Optional<GeoJSONCoordinate> coordinates = Optional.absent();

    @JsonProperty(required=true)
    public Optional<GeoJSONCoordinate> getCoordinates() {
        return this.coordinates;
    }

    public GeoJSONPoint setCoordinates(GeoJSONCoordinate coordinates) {
        this.coordinates = Optional.fromNullable((Object)coordinates);
        return this;
    }

    public static GeoJSONPoint create(GeoJSONCoordinate point) {
        return new GeoJSONPoint().setCoordinates(point);
    }

    @Override
    public String getTypeName() {
        return GeoJSONUtil.getTypeName(this.getClass());
    }

    @Override
    public boolean isEmpty() {
        return !this.coordinates.isPresent();
    }

    @Override
    public void validate() {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.coordinates == null ? 0 : this.coordinates.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoJSONPoint other = (GeoJSONPoint)obj;
        return !(this.coordinates == null ? other.coordinates != null : !this.coordinates.equals(other.coordinates));
    }

    @Override
    public String toWKT() {
        List<GeoJSONCoordinate> list = this.coordinates.isPresent() ? Arrays.asList((GeoJSONCoordinate)this.coordinates.get()) : Collections.emptyList();
        return this.getTypeName() + " " + WKTUtil.getCoordinateStringPointOrLineString(list);
    }

    public String toString() {
        return this.toWKT();
    }
}

