/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.example;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.Operator;
import at.ac.ait.ariadne.routeformat.RoutingResponse;
import at.ac.ait.ariadne.routeformat.example.IntermodalRouteExample;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONLineString;
import at.ac.ait.ariadne.routeformat.instruction.Instruction;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import com.fasterxml.jackson.module.jsonSchema.factories.SchemaFactoryWrapper;
import com.kjetland.jackson.jsonSchema.JsonSchemaGenerator;
import java.io.File;
import java.io.IOException;
import scala.Option;

public class JacksonExample {
    public static final String schema3File = "src/main/resources/ariadne-json-route-format_schema_v3.json";
    public static final String schema4File = "src/main/resources/ariadne-json-route-format_schema_v4.json";
    public static final String exampleFile = "src/main/resources/ariadne-json-route-format_example.json";
    public static final String exampleUnknownAttributesFile = "src/main/resources/operator-with-unknown-fields.json";
    private ObjectMapper mapper = new ObjectMapper();

    public JacksonExample() {
        this.mapper.findAndRegisterModules();
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public static void main(String[] args) throws JsonGenerationException, JsonMappingException, IOException {
        JacksonExample main = new JacksonExample();
        main.writeExampleJson();
        main.readExampleJson();
        main.writeSchemav3();
        main.readFileWithUnkownAttributes();
    }

    public void writeExampleJson() throws JsonGenerationException, JsonMappingException, IOException {
        RoutingResponse root = new IntermodalRouteExample().getRoutingResponse();
        System.out.println(this.mapper.writeValueAsString((Object)root));
        System.out.println("##########");
        this.mapper.writeValue(new File(exampleFile), (Object)root);
    }

    public void readExampleJson() throws JsonParseException, JsonMappingException, IOException {
        RoutingResponse root = (RoutingResponse)this.mapper.readValue(new File(exampleFile), RoutingResponse.class);
        Constants.Status status = root.getStatus();
        GeoJSONCoordinate secondGeometryPointOfRoute = ((GeoJSONLineString)((GeoJSONFeature)root.getRoutes().get(0).getSegments().get(0).getGeometryGeoJson().get()).getGeometry()).getCoordinates().get(1);
        System.out.println((Object)status);
        System.out.println(secondGeometryPointOfRoute);
        System.out.println(root.getProcessedTime());
        System.out.println("##########");
        JsonNode rootNode = (JsonNode)this.mapper.readValue(new File(exampleFile), JsonNode.class);
        System.out.println(rootNode.get("status").asText());
        System.out.println(rootNode.get("routes").get(0).get("segments").get(0).get("geometryGeoJson").get("geometry").get("coordinates").get(1));
        System.out.println(rootNode.get("calculationTime"));
        System.out.println("##########");
    }

    public void readFileWithUnkownAttributes() throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Operator operator = (Operator)mapper.readValue(new File(exampleUnknownAttributesFile), Operator.class);
        System.out.println(operator);
        System.out.println("##########");
    }

    public void writeSchemav3() throws JsonGenerationException, IOException {
        SchemaFactoryWrapper visitor = new SchemaFactoryWrapper();
        this.mapper.acceptJsonFormatVisitor(this.mapper.constructType(RoutingResponse.class), (JsonFormatVisitorWrapper)visitor);
        JsonSchema jsonSchema = visitor.finalSchema();
        System.out.println(this.mapper.writeValueAsString((Object)jsonSchema));
        System.out.println("##########");
        this.mapper.writeValue(new File(schema3File), (Object)jsonSchema);
    }

    public void writeSchemav4() throws JsonGenerationException, IOException {
        JsonSchemaGenerator jsonSchemaGenerator = new JsonSchemaGenerator(this.mapper);
        Option emtpyOption = Option.empty();
        JsonNode jsonSchema = jsonSchemaGenerator.generateJsonSchema(Instruction.class, emtpyOption, emtpyOption);
        System.out.println(this.mapper.writeValueAsString((Object)jsonSchema));
        System.out.println("##########");
        this.mapper.writeValue(new File(schema4File), (Object)jsonSchema);
    }
}

