/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

public class Constants {

    public static enum OutputFormat {
        ENCODED_POLYLINE,
        GEOJSON,
        GEOJSON_EDGES,
        SIMPLIFIED_ENCODED_POLYLINE,
        SIMPLIFIED_GEOJSON;

    }

    public static enum SiteFeature {
        MOT_USER_AFFINITY,
        DEPARTURE_TIME,
        ARRIVAL_TIME;

    }

    public static enum Status {
        OK,
        INVALID_REQUEST,
        ERROR;

    }

    public static enum RoadCrossing {
        NO,
        CROSSING,
        UNMARKED,
        UNCONTROLLED,
        TRAFFIC_SIGNALS;

    }

    public static enum ContinueDirection {
        SAME,
        OPPOSITE;

    }

    public static enum Preposition {
        BEFORE,
        AT,
        AFTER,
        TOWARDS,
        THROUGH,
        ALONG,
        PAST;

    }

    public static enum RelativeDirection {
        FRONT,
        FRONT_LEFT,
        FRONT_RIGHT,
        LEFT,
        RIGHT,
        BACK_LEFT,
        BACK_RIGHT,
        BACK;

    }

    public static enum TurnDirection {
        STRAIGHT,
        SLIGHT_LEFT,
        SLIGHT_RIGHT,
        LEFT,
        RIGHT,
        SHARP_LEFT,
        SHARP_RIGHT,
        U_TURN;

    }

    public static enum CompassDirection {
        N,
        NE,
        E,
        SE,
        S,
        SW,
        W,
        NW;

    }

    public static enum Tunnel {
        NO,
        TUNNEL,
        BUILDING_PASSAGE,
        AVALANCHE_PROTECTOR,
        COVERED,
        ARCADE,
        COLONNADE;

    }

    public static enum Area {
        SQUARE,
        PARK,
        DISTRICT;

    }

    public static enum FormOfWay {
        MOTORWAY,
        ROAD,
        ROAD_CROSSING,
        LIVING_STREET,
        CYCLEPATH,
        FOOT_CYCLEPATH,
        FOOTPATH,
        SIDEWALK,
        PEDESTRIAN_ZONE,
        STAIRS,
        PATH;

    }

    public static enum Speed {
        SLOW,
        NORMAL,
        FAST;

    }

    public static enum Sharing {
        STATION_BOUND_VEHICLE_SHARING,
        FREE_FLOATING_VEHICLE_SHARING,
        RIDE_SHARING,
        RIDE_SOURCING;

    }

    public static enum ParkingType {
        SURFACE,
        UNDERGROUND,
        CARPARK;

    }

    public static enum DetailedModeOfTransportType {
        RAILWAY(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        LONG_DISTANCE_RAILWAY(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        SUBURBAN_RAILWAY(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        URBAN_RAILWAY(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        SUBWAY(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        TRAM(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        CABLE_CAR(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        FUNICULAR(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        BUS(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        TROLLEYBUS(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        AERIALWAY(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        SHIP(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        AIRPLANE(GeneralizedModeOfTransportType.PUBLIC_TRANSPORT),
        FOOT(GeneralizedModeOfTransportType.FOOT),
        TRANSFER(GeneralizedModeOfTransportType.FOOT),
        BICYCLE(GeneralizedModeOfTransportType.BICYCLE),
        MOTORCYCLE(GeneralizedModeOfTransportType.MOTORCYCLE),
        CAR(GeneralizedModeOfTransportType.CAR),
        MOTORHOME(GeneralizedModeOfTransportType.CAR),
        HGV(GeneralizedModeOfTransportType.CAR),
        TAXI(GeneralizedModeOfTransportType.CAR);

        private final GeneralizedModeOfTransportType mot;

        private DetailedModeOfTransportType(GeneralizedModeOfTransportType mot) {
            this.mot = mot;
        }

        public GeneralizedModeOfTransportType getGeneralizedType() {
            return this.mot;
        }
    }

    public static enum GeneralizedModeOfTransportType {
        FOOT,
        BICYCLE,
        MOTORCYCLE,
        CAR,
        PUBLIC_TRANSPORT;

    }

    public static enum AccessibilityRestriction {
        NO_STAIRS,
        NO_ESCALATOR,
        NO_ELEVATOR,
        ONLY_LOW_FLOOR_VEHICLE;

    }

    public static enum VehicleAccessibility {
        LOW_FLOOR_VEHICLE,
        HIGH_FLOOR_VEHICLE;

    }

    public static enum Accessibility {
        STAIRS_DOWN,
        STAIRS_UP,
        ESCALATOR_DOWN,
        ESCALATOR_UP,
        ELEVATOR_DOWN,
        ELEVATOR_UP;

    }
}

