/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.util;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.ModeOfTransport;
import at.ac.ait.ariadne.routeformat.RouteSegment;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeatureCollection;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONLineString;
import com.google.common.collect.BoundType;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteSegmentMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteSegmentMerger.class);
    private final List<LinkedList<RouteSegment>> routes;
    private List<Integer> additionalAlightingSecondsBetweenRoutes;
    private boolean mergeSegmentsWithSameMot = true;
    private Set<ModeOfTransport> writeWaitingTimePreferableNotInto;

    public RouteSegmentMerger(List<List<RouteSegment>> routes) {
        this.routes = routes.stream().map(l -> new LinkedList(l)).collect(Collectors.toList());
        this.additionalAlightingSecondsBetweenRoutes = new ArrayList<Integer>();
        for (int i = 0; i < routes.size() - 1; ++i) {
            this.additionalAlightingSecondsBetweenRoutes.add(0);
        }
        this.writeWaitingTimePreferableNotInto = new HashSet<ModeOfTransport>();
        this.writeWaitingTimePreferableNotInto.add(ModeOfTransport.STANDARD_FOOT);
    }

    public boolean isMergeSegmentsWithSameMot() {
        return this.mergeSegmentsWithSameMot;
    }

    public void setMergeSegmentsWithSameMot(boolean mergeSegmentsWithSameMot) {
        this.mergeSegmentsWithSameMot = mergeSegmentsWithSameMot;
    }

    public Set<ModeOfTransport> getWriteWaitingTimePreferableNotInto() {
        return new HashSet<ModeOfTransport>(this.writeWaitingTimePreferableNotInto);
    }

    public void setWriteWaitingTimePreferableNotInto(Set<ModeOfTransport> writeWaitingTimePreferableNotInto) {
        this.writeWaitingTimePreferableNotInto = writeWaitingTimePreferableNotInto;
    }

    public List<Integer> getAdditionalAlightingSecondsBetweenRoutes() {
        return new ArrayList<Integer>(this.additionalAlightingSecondsBetweenRoutes);
    }

    public void setAdditionalAlightingSecondsBetweenRoutes(List<Integer> additionalAlightingSecondsBetweenRoutes) {
        if (additionalAlightingSecondsBetweenRoutes.size() != this.routes.size() - 1) {
            throw new IllegalArgumentException("alighting seconds must be given for exactly each change between routes");
        }
        this.additionalAlightingSecondsBetweenRoutes = additionalAlightingSecondsBetweenRoutes;
    }

    public List<RouteSegment> createMergedSegments() {
        return this.mergeAllSegments();
    }

    List<RouteSegment> mergeAllSegments() {
        int i;
        List<RouteSegment> mergedSegments = new ArrayList<RouteSegment>();
        for (int i2 = 0; i2 < this.routes.size() - 1; ++i2) {
            int alightingSeconds = this.additionalAlightingSecondsBetweenRoutes.get(i2);
            if (alightingSeconds <= 0) continue;
            RouteSegment segmentToProlong = this.routes.get(i2).removeLast();
            RouteSegment prolongedSegment = RouteSegment.createShallowCopy(segmentToProlong).setAlightingSeconds(segmentToProlong.getAlightingSeconds().orElse(0) + alightingSeconds).setDurationSeconds(segmentToProlong.getDurationSeconds() + alightingSeconds).setEndTime(segmentToProlong.getEndTimeAsZonedDateTime().plus(alightingSeconds, ChronoUnit.SECONDS));
            this.routes.get(i2).addLast(prolongedSegment);
        }
        HashMap<Integer, Integer> index2waitingSeconds = new HashMap<Integer, Integer>();
        index2waitingSeconds.put(0, 0);
        ZonedDateTime endOfLastRoute = this.routes.get(0).getLast().getEndTimeAsZonedDateTime();
        for (i = 1; i < this.routes.size(); ++i) {
            int waitingSeconds = (int)Duration.between(endOfLastRoute, this.routes.get(i).getFirst().getStartTimeAsZonedDateTime()).getSeconds();
            index2waitingSeconds.put(i, waitingSeconds);
            int routeSeconds = this.routes.get(i).stream().mapToInt(s -> s.getDurationSeconds()).sum();
            endOfLastRoute = endOfLastRoute.plus(routeSeconds + (waitingSeconds > 0 ? waitingSeconds : 0), ChronoUnit.SECONDS);
        }
        for (i = 0; i < this.routes.size(); ++i) {
            int waitingSeconds = (Integer)index2waitingSeconds.get(i);
            List<RouteSegment> segmentsToAdd = waitingSeconds > 0 ? this.prependWaitingTime((List<RouteSegment>)this.routes.get(i), waitingSeconds) : (waitingSeconds < 0 ? RouteSegmentMerger.shiftInTime((List<RouteSegment>)this.routes.get(i), -waitingSeconds) : (List<RouteSegment>)this.routes.get(i));
            mergedSegments.addAll(segmentsToAdd);
        }
        if (this.mergeSegmentsWithSameMot) {
            mergedSegments = RouteSegmentMerger.mergeSegmentsWithSameMot(mergedSegments);
        }
        RouteSegmentMerger.fixConsecutiveSegmentNrs(mergedSegments);
        return mergedSegments;
    }

    private List<RouteSegment> prependWaitingTime(List<RouteSegment> segments, int waitingSeconds) {
        ModeOfTransport mot;
        int firstMatchingSegmentIndex;
        for (firstMatchingSegmentIndex = 0; firstMatchingSegmentIndex < segments.size() && this.writeWaitingTimePreferableNotInto.contains(mot = segments.get(firstMatchingSegmentIndex).getModeOfTransport()); ++firstMatchingSegmentIndex) {
        }
        if (firstMatchingSegmentIndex >= segments.size()) {
            firstMatchingSegmentIndex = segments.size() - 1;
        }
        ArrayList<RouteSegment> modifiedSegments = new ArrayList<RouteSegment>(segments);
        RouteSegment old = (RouteSegment)modifiedSegments.get(firstMatchingSegmentIndex);
        RouteSegment modifiedCopy = RouteSegment.createShallowCopy(old);
        if (old.getModeOfTransport().getDetailedType().isPresent() && old.getModeOfTransport().getDetailedType().get().equals((Object)Constants.DetailedModeOfTransportType.TRANSFER)) {
            modifiedCopy.setAlightingSeconds(old.getAlightingSeconds().orElse(0) + waitingSeconds);
        } else {
            modifiedCopy.setBoardingSeconds(old.getBoardingSeconds().orElse(0) + waitingSeconds);
        }
        modifiedCopy.setDurationSeconds(old.getDurationSeconds() + waitingSeconds);
        modifiedCopy.setStartTime(old.getStartTimeAsZonedDateTime().minus(waitingSeconds, ChronoUnit.SECONDS));
        modifiedSegments.set(firstMatchingSegmentIndex, modifiedCopy);
        for (int i = 0; i < firstMatchingSegmentIndex; ++i) {
            old = (RouteSegment)modifiedSegments.get(i);
            modifiedCopy = RouteSegment.createShallowCopy(old);
            modifiedCopy.setStartTime(old.getStartTimeAsZonedDateTime().minus(waitingSeconds, ChronoUnit.SECONDS));
            modifiedCopy.setEndTime(old.getEndTimeAsZonedDateTime().minus(waitingSeconds, ChronoUnit.SECONDS));
            modifiedSegments.set(i, modifiedCopy);
        }
        return modifiedSegments;
    }

    private static List<RouteSegment> shiftInTime(List<RouteSegment> segments, int shiftSeconds) {
        ArrayList<RouteSegment> modifiedSegments = new ArrayList<RouteSegment>();
        for (RouteSegment segment : segments) {
            RouteSegment modifiedCopy = RouteSegment.createShallowCopy(segment);
            modifiedCopy.setStartTime(segment.getStartTimeAsZonedDateTime().plus(shiftSeconds, ChronoUnit.SECONDS));
            modifiedCopy.setEndTime(segment.getEndTimeAsZonedDateTime().plus(shiftSeconds, ChronoUnit.SECONDS));
            modifiedSegments.add(modifiedCopy);
            if (segment.getModeOfTransport().equals(ModeOfTransport.STANDARD_FOOT)) continue;
            LOGGER.warn(shiftSeconds + "s shift for mot " + segment.getModeOfTransport());
        }
        return modifiedSegments;
    }

    private static List<RouteSegment> mergeSegmentsWithSameMot(List<RouteSegment> segments) {
        TreeRangeSet rangeSet = TreeRangeSet.create();
        for (int i = 0; i < segments.size() - 1; ++i) {
            if (!segments.get(i).getModeOfTransport().equals(segments.get(i + 1).getModeOfTransport())) continue;
            rangeSet.add(Range.closed((Comparable)Integer.valueOf(i), (Comparable)Integer.valueOf(i + 1)).canonical(DiscreteDomain.integers()));
        }
        HashMap<Integer, Range> start2Range = new HashMap<Integer, Range>();
        for (Range range : rangeSet.asRanges()) {
            start2Range.put(RouteSegmentMerger.lowerBound((Range<Integer>)range), range);
        }
        ArrayList<RouteSegment> mergedSegments = new ArrayList<RouteSegment>();
        for (int i = 0; i < segments.size(); ++i) {
            if (start2Range.containsKey(i)) {
                Range range = (Range)start2Range.get(i);
                RouteSegment prev = segments.get(i);
                while (i < RouteSegmentMerger.upperBound((Range<Integer>)range)) {
                    prev = RouteSegmentMerger.mergeTwoSegments(prev, segments.get(++i));
                }
                mergedSegments.add(prev);
                continue;
            }
            mergedSegments.add(segments.get(i));
        }
        return mergedSegments;
    }

    private static RouteSegment mergeTwoSegments(RouteSegment a, RouteSegment b) {
        RouteSegment merged = RouteSegment.createShallowCopy(a);
        int totalSeconds = a.getDurationSeconds() + b.getDurationSeconds();
        merged.setBoardingSeconds(a.getBoardingSeconds().orElse(0) + b.getBoardingSeconds().orElse(0));
        merged.setAlightingSeconds(a.getAlightingSeconds().orElse(0) + b.getAlightingSeconds().orElse(0));
        merged.setDurationSeconds(totalSeconds);
        merged.setEndTime(a.getStartTimeAsZonedDateTime().plus(totalSeconds, ChronoUnit.SECONDS));
        merged.setTo(b.getTo());
        GeoJSONFeature<GeoJSONLineString> newlineString = GeoJSONFeature.createLineStringFeature(new ArrayList<GeoJSONCoordinate>());
        ArrayList newGeometryGeoJsonEdges = new ArrayList();
        for (RouteSegment routeSegment : new RouteSegment[]{a, b}) {
            routeSegment.getGeometryGeoJson().ifPresent(g -> ((GeoJSONLineString)newlineString.getGeometry()).getCoordinates().addAll(((GeoJSONLineString)g.getGeometry()).getCoordinates()));
            routeSegment.getGeometryGeoJsonEdges().ifPresent(g -> newGeometryGeoJsonEdges.addAll(g.getFeatures()));
        }
        merged.setGeometryGeoJson(newlineString);
        if (!newGeometryGeoJsonEdges.isEmpty()) {
            merged.setGeometryGeoJsonEdges(GeoJSONFeatureCollection.create(newGeometryGeoJsonEdges));
        }
        merged.setDistanceMeters(a.getDistanceMeters() + b.getDistanceMeters());
        return merged;
    }

    private static void fixConsecutiveSegmentNrs(List<RouteSegment> segments) {
        for (int i = 0; i < segments.size(); ++i) {
            segments.get(i).setNr(i + 1);
        }
    }

    static int lowerBound(Range<Integer> range) {
        int lower = (Integer)range.lowerEndpoint();
        if (range.lowerBoundType().equals((Object)BoundType.OPEN)) {
            ++lower;
        }
        return lower;
    }

    static int upperBound(Range<Integer> range) {
        int upper = (Integer)range.upperEndpoint();
        if (range.upperBoundType().equals((Object)BoundType.OPEN)) {
            --upper;
        }
        return upper;
    }
}

