/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.location;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.location.Location;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Parking
extends Location<Parking> {
    private Optional<Constants.ParkingType> parkingType = Optional.empty();
    private Set<Constants.GeneralizedModeOfTransportType> modesOfTransport = new TreeSet<Constants.GeneralizedModeOfTransportType>();
    private Optional<String> name = Optional.empty();
    private Optional<Boolean> fee = Optional.empty();
    private Optional<Boolean> parkAndRide = Optional.empty();
    private Optional<String> openingHours = Optional.empty();

    public Optional<Constants.ParkingType> getParkingType() {
        return this.parkingType;
    }

    public Set<Constants.GeneralizedModeOfTransportType> getModesOfTransport() {
        return this.modesOfTransport;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<Boolean> getFee() {
        return this.fee;
    }

    public Optional<Boolean> getParkAndRide() {
        return this.parkAndRide;
    }

    public Optional<String> getOpeningHours() {
        return this.openingHours;
    }

    public Parking setParkingType(Constants.ParkingType parkingType) {
        this.parkingType = Optional.ofNullable(parkingType);
        return this;
    }

    public Parking setModesOfTransport(Set<Constants.GeneralizedModeOfTransportType> modesOfTransport) {
        this.modesOfTransport = modesOfTransport;
        return this;
    }

    public Parking setName(String name) {
        this.name = Optional.ofNullable(name);
        return this;
    }

    public Parking setFee(Boolean fee) {
        this.fee = Optional.ofNullable(fee);
        return this;
    }

    public Parking setParkAndRide(Boolean parkAndRide) {
        this.parkAndRide = Optional.ofNullable(parkAndRide);
        return this;
    }

    public Parking setOpeningHours(String openingHours) {
        this.openingHours = Optional.ofNullable(openingHours);
        return this;
    }

    public static Parking createMinimal(GeoJSONCoordinate position) {
        return (Parking)new Parking().setCoordinate(position);
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fee == null ? 0 : this.fee.hashCode());
        result = 31 * result + (this.modesOfTransport == null ? 0 : this.modesOfTransport.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.openingHours == null ? 0 : this.openingHours.hashCode());
        result = 31 * result + (this.parkAndRide == null ? 0 : this.parkAndRide.hashCode());
        result = 31 * result + (this.parkingType == null ? 0 : this.parkingType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parking other = (Parking)obj;
        if (this.fee == null ? other.fee != null : !this.fee.equals(other.fee)) {
            return false;
        }
        if (this.modesOfTransport == null ? other.modesOfTransport != null : !this.modesOfTransport.equals(other.modesOfTransport)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.openingHours == null ? other.openingHours != null : !this.openingHours.equals(other.openingHours)) {
            return false;
        }
        if (this.parkAndRide == null ? other.parkAndRide != null : !this.parkAndRide.equals(other.parkAndRide)) {
            return false;
        }
        return !(this.parkingType == null ? other.parkingType != null : !this.parkingType.equals(other.parkingType));
    }

    @Override
    public String toString() {
        return super.toString() + " -> Parking [parkingType=" + this.parkingType + ", modesOfTransport=" + this.modesOfTransport + ", name=" + this.name + ", fee=" + this.fee + ", parkAndRide=" + this.parkAndRide + ", openingHours=" + this.openingHours + "]";
    }
}

