/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.location;

import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPoint;
import at.ac.ait.ariadne.routeformat.location.Address;
import at.ac.ait.ariadne.routeformat.location.Parking;
import at.ac.ait.ariadne.routeformat.location.PointOfInterest;
import at.ac.ait.ariadne.routeformat.location.PublicTransportStop;
import at.ac.ait.ariadne.routeformat.location.SharingStation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Location.class), @JsonSubTypes.Type(value=PointOfInterest.class), @JsonSubTypes.Type(value=PublicTransportStop.class), @JsonSubTypes.Type(value=SharingStation.class), @JsonSubTypes.Type(value=Parking.class)})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Location<T extends Location<T>>
implements Validatable {
    private GeoJSONFeature<GeoJSONPoint> coordinate;
    private Optional<GeoJSONFeature<?>> complexGeometry = Optional.empty();
    private Optional<Address> address = Optional.empty();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonIgnore
    public GeoJSONCoordinate getSimpleCoordinate() {
        return this.coordinate.getGeometry().getCoordinates().get();
    }

    public GeoJSONFeature<GeoJSONPoint> getCoordinate() {
        return this.coordinate;
    }

    public Optional<GeoJSONFeature<?>> getComplexGeometry() {
        return this.complexGeometry;
    }

    public Optional<Address> getAddress() {
        return this.address;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @JsonProperty
    public T setCoordinate(GeoJSONFeature<GeoJSONPoint> coordinate) {
        this.coordinate = coordinate;
        return (T)this;
    }

    @JsonIgnore
    public T setCoordinate(GeoJSONCoordinate coordinate) {
        this.coordinate = GeoJSONFeature.createPointFeature(coordinate);
        return (T)this;
    }

    public T setComplexGeometry(GeoJSONFeature<?> complexGeometry) {
        this.complexGeometry = Optional.ofNullable(complexGeometry);
        return (T)this;
    }

    public T setAddress(Address address) {
        this.address = Optional.ofNullable(address);
        return (T)this;
    }

    public T setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return (T)this;
    }

    public static Location<?> createMinimal(GeoJSONCoordinate position) {
        return new Location().setCoordinate(position);
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.coordinate != null ? 1 : 0) != 0, (Object)"coordinate is mandatory but missing");
        this.coordinate.validate();
        this.complexGeometry.ifPresent(c -> c.validate());
        this.address.ifPresent(a -> a.validate());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.complexGeometry == null ? 0 : this.complexGeometry.hashCode());
        result = 31 * result + (this.coordinate == null ? 0 : this.coordinate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.complexGeometry == null ? other.complexGeometry != null : !this.complexGeometry.equals(other.complexGeometry)) {
            return false;
        }
        return !(this.coordinate == null ? other.coordinate != null : !this.coordinate.equals(other.coordinate));
    }

    public String toString() {
        return "Location [coordinate=" + this.coordinate + ", address=" + this.address + ", additionalInfo=" + this.additionalInfo + "]";
    }
}

