/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.geojson;

import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONGeometryObject;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONUtil;
import at.ac.ait.ariadne.routeformat.geojson.WKTUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class GeoJSONMultiPolygon
implements GeoJSONGeometryObject {
    private List<List<List<GeoJSONCoordinate>>> coordinates = new ArrayList<List<List<GeoJSONCoordinate>>>();

    @JsonProperty(required=true)
    public List<List<List<GeoJSONCoordinate>>> getCoordinates() {
        return this.coordinates;
    }

    public GeoJSONMultiPolygon setCoordinates(List<List<List<GeoJSONCoordinate>>> coordinates) {
        this.coordinates = new ArrayList<List<List<GeoJSONCoordinate>>>();
        for (List<List<GeoJSONCoordinate>> polygon : coordinates) {
            ArrayList<ArrayList<GeoJSONCoordinate>> polyCoordinates = new ArrayList<ArrayList<GeoJSONCoordinate>>();
            for (List<GeoJSONCoordinate> ring : polygon) {
                polyCoordinates.add(new ArrayList<GeoJSONCoordinate>(ring));
            }
            this.coordinates.add(polyCoordinates);
        }
        return this;
    }

    public static GeoJSONMultiPolygon create(List<List<List<GeoJSONCoordinate>>> points) {
        return new GeoJSONMultiPolygon().setCoordinates(points);
    }

    @Override
    public boolean isEmpty() {
        return this.coordinates.isEmpty();
    }

    @Override
    public void validate() {
        for (List<List<GeoJSONCoordinate>> polygon : this.coordinates) {
            for (List<GeoJSONCoordinate> ring : polygon) {
                GeoJSONUtil.assertLinearRing(ring);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.coordinates == null ? 0 : this.coordinates.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoJSONMultiPolygon other = (GeoJSONMultiPolygon)obj;
        return !(this.coordinates == null ? other.coordinates != null : !this.coordinates.equals(other.coordinates));
    }

    @Override
    public String toWKT() {
        return this.getTypeName() + " " + WKTUtil.getCoordinateStringMultiPolygon(this.coordinates);
    }

    public String toString() {
        return this.toWKT();
    }
}

