/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.geojson;

import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONGeometryObject;
import at.ac.ait.ariadne.routeformat.geojson.WKTUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class GeoJSONLineString
implements GeoJSONGeometryObject {
    private List<GeoJSONCoordinate> coordinates = new ArrayList<GeoJSONCoordinate>();

    @JsonProperty(required=true)
    public List<GeoJSONCoordinate> getCoordinates() {
        return this.coordinates;
    }

    public GeoJSONLineString setCoordinates(List<GeoJSONCoordinate> coordinates) {
        this.coordinates = new ArrayList<GeoJSONCoordinate>(coordinates);
        return this;
    }

    public static GeoJSONLineString create(List<GeoJSONCoordinate> points) {
        return new GeoJSONLineString().setCoordinates(points);
    }

    public GeoJSONLineString subLineString(int fromIndex, int toIndex) {
        return GeoJSONLineString.create(this.coordinates.subList(fromIndex, toIndex));
    }

    @Override
    public boolean isEmpty() {
        return this.coordinates.isEmpty();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.isEmpty() || this.coordinates.size() >= 2 ? 1 : 0) != 0, (Object)("coordinates must either be emtpy or >= 2 but was of length " + this.coordinates.size()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.coordinates == null ? 0 : this.coordinates.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoJSONLineString other = (GeoJSONLineString)obj;
        return !(this.coordinates == null ? other.coordinates != null : !this.coordinates.equals(other.coordinates));
    }

    @Override
    public String toWKT() {
        return this.getTypeName() + " " + WKTUtil.getCoordinateStringPointOrLineString(this.coordinates);
    }

    public String toString() {
        return this.toWKT();
    }
}

