/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.example;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.IntermediateStop;
import at.ac.ait.ariadne.routeformat.ModeOfTransport;
import at.ac.ait.ariadne.routeformat.Operator;
import at.ac.ait.ariadne.routeformat.RequestModeOfTransport;
import at.ac.ait.ariadne.routeformat.RequestPTModeOfTransport;
import at.ac.ait.ariadne.routeformat.Route;
import at.ac.ait.ariadne.routeformat.RouteFormatRoot;
import at.ac.ait.ariadne.routeformat.RouteSegment;
import at.ac.ait.ariadne.routeformat.RoutingRequest;
import at.ac.ait.ariadne.routeformat.Service;
import at.ac.ait.ariadne.routeformat.features.OptimizedFor;
import at.ac.ait.ariadne.routeformat.features.RoutingFeatures;
import at.ac.ait.ariadne.routeformat.features.Site;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeatureCollection;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONLineString;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONMultiPolygon;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPolygon;
import at.ac.ait.ariadne.routeformat.instruction.Landmark;
import at.ac.ait.ariadne.routeformat.instruction.RoadInstruction;
import at.ac.ait.ariadne.routeformat.instruction.RoundaboutInstruction;
import at.ac.ait.ariadne.routeformat.location.Address;
import at.ac.ait.ariadne.routeformat.location.Location;
import at.ac.ait.ariadne.routeformat.location.Parking;
import at.ac.ait.ariadne.routeformat.location.PointOfInterest;
import at.ac.ait.ariadne.routeformat.location.PublicTransportStop;
import at.ac.ait.ariadne.routeformat.location.SharingStation;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class IntermodalRouteExample {
    private Operator wienerLinienOperator;
    private Operator citybikeOperator;
    private Operator car2goOperator;
    private Operator flincOperator;
    private ModeOfTransport wienerLinienMot;
    private ModeOfTransport citybikeMot;
    private ModeOfTransport car2goMot;
    private ModeOfTransport flincMot;
    private ModeOfTransport hgvMot;
    private Location<?> giefinggasseAit;
    private Location<?> heinrichVonBuolGasseBusStop;
    private Location<?> floridsdorfBusStop;
    private Location<?> floridsdorfSubwayStop;
    private Location<?> neueDonauSubwayStop;
    private Location<?> handelskaiSubwayStop;
    private Location<?> handelskaiSubwayEntry;
    private Location<?> handelskaiCitybike;
    private Location<?> friedrichEngelsPlatzCitybike;
    private Location<?> car2goPickup;
    private Location<?> adalbertStifterStrasse15;
    private Location<?> privateBicycleHopsagasse;
    private Location<?> antonKummererPark;
    private Location<?> treustrasse92;
    private Location<?> gaussplatz;
    private Location<?> scholzgasse1Parking;
    private Location<?> brigittenauerLaende40;
    private Service service28A;
    private Service serviceU6;
    private RouteSegment walkToBusStopHeinrichVonBuolGasse;
    private RouteSegment transferToBusHeinrichVonBuolGasse;
    private RouteSegment busFromHeinrichVonBuolGgasseToFloridsdorf;
    private RouteSegment citybikeFromHandelskaiToFriedrichEngelsPlatz;
    private RouteSegment car2goAlongAdalbertStifterStrasse;
    private RouteSegment bicycleFromAdalbertStifterStrasseToTreugasse;
    private RouteSegment rideSharingFromTreugasseToGaussplatz;
    private RouteSegment carFromGaussplatzToScholzgasse;
    private RouteSegment hgvFromScholzGasseToBrigittenauerLaende;
    private RouteFormatRoot root;
    private RoutingFeatures routingFeatures = this.createRoutingFeatures();

    public IntermodalRouteExample() throws JsonGenerationException, JsonMappingException, IOException {
        this.initializeOperators();
        this.initializeComplexModesOfTransport();
        this.initializeLocations();
        this.initializePublicTransportServices();
        this.root = this.createRouteFormatRoot();
    }

    private void initializeOperators() {
        this.wienerLinienOperator = Operator.createMinimal("Wiener Linien").setWebsite("http://www.wienerlinien.at").setCustomerServiceEmail("post@wienerlinien.at").setAdditionalInfo((Map<String, Object>)ImmutableMap.of((Object)"email_ticketshop", (Object)"ticketshop@wienerlinien.at"));
        this.citybikeOperator = Operator.createMinimal("Citybike Wien").setWebsite("http://citybikewien.at").setCustomerServiceEmail("kontakt@citybikewien.at").setCustomerServicePhone("0810 500 500").setAddress(new Address().setStreetName("Litfa\u00dfstra\u00dfe").setHouseNumber("6").setPostCode("1030").setCity("Wien"));
        this.car2goOperator = Operator.createMinimal("Car2Go").setWebsite("https://www.car2go.com/de/wien").setCustomerServiceEmail("wien@car2go.com");
        this.flincOperator = Operator.createMinimal("Flinc").setWebsite("https://flinc.org");
    }

    private void initializeComplexModesOfTransport() {
        this.wienerLinienMot = ModeOfTransport.createMinimal(Constants.GeneralizedModeOfTransportType.PUBLIC_TRANSPORT).setId("wiener_linien").setOperator(this.wienerLinienOperator);
        this.citybikeMot = ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.BICYCLE).setId("citybike").setSharingType(Constants.Sharing.STATION_BOUND_VEHICLE_SHARING).setOperator(this.citybikeOperator);
        this.car2goMot = ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.CAR).setId("car2go").setSharingType(Constants.Sharing.FREE_FLOATING_VEHICLE_SHARING).setElectric(true).setOperator(this.car2goOperator);
        this.flincMot = ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.CAR).setId("flinc").setSharingType(Constants.Sharing.RIDE_SHARING).setOperator(this.flincOperator);
        this.hgvMot = ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.HGV).setWeightKg(7000).setLengthMm(5925).setHeightMm(2750).setWidthMm(2400);
    }

    private void initializeLocations() {
        Address giefinggasse = new Address().setCountry("Austria").setCity("Wien").setPostCode("1210").setStreetName("Giefinggasse").setHouseNumber("2b").setAdditionalInfo((Map<String, Object>)ImmutableMap.of((Object)"floor", (Object)"3", (Object)"room", (Object)"S313"));
        this.giefinggasseAit = ((PointOfInterest)PointOfInterest.createMinimal(GeoJSONCoordinate.create("16.4265263", "48.2686617")).setAddress(giefinggasse)).setName("AIT").setPoiType("company");
        this.heinrichVonBuolGasseBusStop = PublicTransportStop.createMinimal(GeoJSONCoordinate.create("16.42791", "48.26680")).setName("Heinrich-von-Buol-Gasse/Siemensstra\u00dfe");
        this.floridsdorfBusStop = PublicTransportStop.createMinimal(GeoJSONCoordinate.create("16.40073", "48.25625")).setName("Floridsdorf").setPlatform("C");
        this.floridsdorfSubwayStop = PublicTransportStop.createMinimal(GeoJSONCoordinate.create("16.40050", "48.25618")).setName("Floridsdorf").setPlatform("2 (U-Bahn)");
        this.neueDonauSubwayStop = PublicTransportStop.createMinimal(GeoJSONCoordinate.create("16.39468", "48.24630")).setName("Neue Donau").setPlatform("2").setRelatedLines((Map<String, Constants.DetailedModeOfTransportType>)ImmutableMap.of((Object)"20A", (Object)((Object)Constants.DetailedModeOfTransportType.BUS), (Object)"20B", (Object)((Object)Constants.DetailedModeOfTransportType.BUS)));
        this.handelskaiSubwayStop = PublicTransportStop.createMinimal(GeoJSONCoordinate.create("16.38541", "48.24173")).setName("Handelskai").setPlatform("2");
        this.handelskaiSubwayEntry = PublicTransportStop.createMinimal(GeoJSONCoordinate.create("16.3848877", "48.2416471")).setName("Handelskai (Stationseingang)");
        this.handelskaiCitybike = SharingStation.createMinimal(GeoJSONCoordinate.create("16.3847976", "48.2420356")).setName("Millennium Tower").setId("2005").setModesOfTransport(Arrays.asList(Constants.GeneralizedModeOfTransportType.BICYCLE)).setOperator(this.citybikeOperator).setAdditionalInfo((Map<String, Object>)ImmutableMap.of((Object)"capacity", (Object)"35", (Object)"bikes_available", (Object)"10", (Object)"boxes_available", (Object)"25"));
        this.friedrichEngelsPlatzCitybike = SharingStation.createMinimal(GeoJSONCoordinate.create("16.3792033", "48.2441354")).setName("Friedrich Engels Platz").setId("2006").setModesOfTransport(Arrays.asList(Constants.GeneralizedModeOfTransportType.BICYCLE)).setOperator(this.citybikeOperator).setAdditionalInfo((Map<String, Object>)ImmutableMap.of((Object)"capacity", (Object)"27", (Object)"bikes_available", (Object)"27", (Object)"boxes_available", (Object)"0"));
        this.car2goPickup = Location.createMinimal(GeoJSONCoordinate.create("16.377454", "48.24386")).setAddress(new Address().setStreetName("Adalbert-Stifter-Stra\u00dfe").setHouseNumber("71"));
        this.adalbertStifterStrasse15 = Location.createMinimal(GeoJSONCoordinate.create("16.3655", "48.23752")).setAddress(new Address().setStreetName("Adalbert-Stifter-Stra\u00dfe").setHouseNumber("15"));
        this.privateBicycleHopsagasse = Location.createMinimal(GeoJSONCoordinate.create("16.3715916", "48.246609")).setAddress(new Address().setStreetName("Hopsagasse").setHouseNumber("5").setPostCode("1200"));
        this.antonKummererPark = PointOfInterest.createMinimal(GeoJSONCoordinate.create("16.364074", "48.2350109")).setPoiType("park").setName("Anton-Kummerer-Park");
        this.treustrasse92 = Location.createMinimal(GeoJSONCoordinate.create("16.36329", "48.234077")).setAddress(new Address().setStreetName("Treustra\u00dfe").setHouseNumber("92").setPostCode("1200"));
        this.gaussplatz = Location.createMinimal(GeoJSONCoordinate.create("16.369045", "48.2267")).setAddress(new Address().setStreetName("Gau\u00dfplatz"));
        this.scholzgasse1Parking = ((Parking)Parking.createMinimal(GeoJSONCoordinate.create("16.3695", "48.2243")).setAddress(new Address().setStreetName("Scholzgasse").setHouseNumber("1").setPostCode("1020"))).setFee(true).setName("Virtuelle Parkgarage Scholzgasse").setModesOfTransport((Set<Constants.GeneralizedModeOfTransportType>)ImmutableSet.of((Object)((Object)Constants.GeneralizedModeOfTransportType.CAR), (Object)((Object)Constants.GeneralizedModeOfTransportType.BICYCLE))).setParkingType(Constants.ParkingType.UNDERGROUND).setParkAndRide(false);
        this.brigittenauerLaende40 = Location.createMinimal(GeoJSONCoordinate.create("16.36621", "48.2276")).setAddress(Address.create("Brigittenauer L\u00e4nde", "40"));
    }

    private void initializePublicTransportServices() {
        this.service28A = Service.createMinimal("28A").setTowards("Floridsdorf");
        this.serviceU6 = Service.createMinimal("U6").setTowards("Siebenhirten");
    }

    public RoutingFeatures getRoutingFeatures() {
        return this.routingFeatures;
    }

    public RouteFormatRoot getRouteFormatRoot() {
        return this.root;
    }

    private RoutingFeatures createRoutingFeatures() {
        ArrayList<Site> sites = new ArrayList<Site>();
        OptimizedFor distance = OptimizedFor.createMinimal("DISTANCE").setDescription("shortest distance");
        OptimizedFor travelTime = OptimizedFor.createMinimal("TRAVELTIME").setDescription("minimum travel time");
        sites.add(Site.createMinimal("test_vienna").setName("Wien").setOptimizedFor(Arrays.asList(distance, travelTime)).setModesOfTransport(Arrays.asList(ModeOfTransport.STANDARD_FOOT, ModeOfTransport.STANDARD_BICYCLE, ModeOfTransport.STANDARD_CAR, this.wienerLinienMot, this.citybikeMot, this.car2goMot, this.flincMot)));
        RoutingFeatures routingFeatures = RoutingFeatures.createMinimal("en", "Example", sites).setUrl("http://www.ait.ac.at").setCredits("(c) by Austrian Institute of Technology GmbH");
        routingFeatures.validate();
        return routingFeatures;
    }

    private RouteFormatRoot createRouteFormatRoot() throws JsonGenerationException, JsonMappingException, IOException {
        RouteFormatRoot root = new RouteFormatRoot().setRouteFormatVersion("X.Y-UNKNOWN").setRequestId("999").setProcessedTime("1970-01-01T00:00:00Z").setStatus(Constants.Status.OK).setDebugMessage("Route calculated in 0.002 seconds").setCoordinateReferenceSystem("EPSG:4326").setRequest(this.createRoutingRequest()).setRoutes(Arrays.asList(Route.createFromSegments(this.createRouteSegments()).setOptimizedFor("travel time and low costs")));
        root.validate();
        return root;
    }

    private RoutingRequest createRoutingRequest() {
        HashMap<String, Object> additionalInfoRouteRequest = new HashMap<String, Object>();
        additionalInfoRouteRequest.put("ait:additionalTestBigDecimal", new BigDecimal("12.34567"));
        additionalInfoRouteRequest.put("ait:additionalTestObject", this.wienerLinienOperator);
        additionalInfoRouteRequest.put("ait:additionalTestList", Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7}));
        additionalInfoRouteRequest.put("ait:additionalTestString", "hello this is a String");
        GeoJSONFeature<GeoJSONPolygon> forbiddenPolygon = GeoJSONFeature.createPolygonFeatureFromCoordinatePoints(Arrays.asList(Arrays.asList(GeoJSONCoordinate.create("16", "48"), GeoJSONCoordinate.create("16.1", "48"), GeoJSONCoordinate.create("16.1", "48.1"), GeoJSONCoordinate.create("16.1", "48"), GeoJSONCoordinate.create("16", "48"))));
        GeoJSONFeature<GeoJSONMultiPolygon> forbiddenAreas = GeoJSONFeature.createMultiPolygonFeatureFromPolygons(Arrays.asList(forbiddenPolygon));
        ArrayList requestModes = new ArrayList();
        requestModes.add((RequestModeOfTransport<?>)((RequestModeOfTransport)((RequestModeOfTransport)RequestModeOfTransport.createMinimal(ModeOfTransport.STANDARD_FOOT).setMaximumDistanceMeters(2000)).setSpeed(Constants.Speed.FAST.name())).setForbiddenAreas(forbiddenAreas));
        requestModes.add((RequestModeOfTransport<?>)((RequestModeOfTransport)((RequestModeOfTransport)RequestModeOfTransport.createMinimal(ModeOfTransport.STANDARD_BICYCLE).setMaximumTravelTimeSeconds(2700)).setSpeed(Constants.Speed.SLOW.name())).setLocations(Arrays.asList(this.adalbertStifterStrasse15, this.privateBicycleHopsagasse)));
        requestModes.add(RequestModeOfTransport.createMinimal(ModeOfTransport.STANDARD_MOTORCYCLE));
        Object carMot = RequestModeOfTransport.createMinimal(ModeOfTransport.STANDARD_CAR).setLocations(Arrays.asList(this.treustrasse92));
        requestModes.add((RequestModeOfTransport<?>)carMot);
        requestModes.add(RequestPTModeOfTransport.createMinimal(this.wienerLinienMot).setExcludedPublicTransportModes((Set<Constants.DetailedModeOfTransportType>)ImmutableSet.of((Object)((Object)Constants.DetailedModeOfTransportType.AERIALWAY), (Object)((Object)Constants.DetailedModeOfTransportType.AIRPLANE), (Object)((Object)Constants.DetailedModeOfTransportType.SHIP))));
        requestModes.add(RequestModeOfTransport.createMinimal(this.citybikeMot));
        requestModes.add(RequestModeOfTransport.createMinimal(this.car2goMot));
        requestModes.add(RequestModeOfTransport.createMinimal(this.flincMot));
        requestModes.add(RequestModeOfTransport.createMinimal(this.flincMot));
        Location<?> from = this.giefinggasseAit;
        Location<?> to = this.brigittenauerLaende40;
        return RoutingRequest.createMinimal(from, to, requestModes).setDepartureTime("2016-01-01T15:00:00+01:00").setLanguages(Arrays.asList("de")).setAccessibilityRestrictions((Set<Constants.AccessibilityRestriction>)ImmutableSet.of((Object)((Object)Constants.AccessibilityRestriction.NO_ELEVATOR))).setOptimizedFor("ENERGY").setMaximumTransfers(10).setEndModeOfTransport((RequestModeOfTransport<?>)carMot).setAdditionalInfo(additionalInfoRouteRequest);
    }

    private LinkedList<RouteSegment> createRouteSegments() {
        LinkedList<RouteSegment> segments = new LinkedList<RouteSegment>();
        int segmentNr = 0;
        GeoJSONFeature<GeoJSONLineString> geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.giefinggasseAit, this.heinrichVonBuolGasseBusStop, GeoJSONCoordinate.create("16.4263", "48.2682"), GeoJSONCoordinate.create("16.42824", "48.26719"));
        GeoJSONFeatureCollection<GeoJSONLineString> geometryGeoJsonEdges = this.createGeometryGeoJsonEdgesFromGiefinggasseToHeinrichVonBuolGasse(geometryGeoJson);
        this.walkToBusStopHeinrichVonBuolGasse = new RouteSegment().setNr(++segmentNr).setFrom(this.giefinggasseAit).setTo(this.heinrichVonBuolGasseBusStop).setDistanceMeters(200).setDurationSeconds(60).setStartTime("2016-01-01T15:00:00+01:00").setEndTime("2016-01-01T15:01:00+01:00").setModeOfTransport(ModeOfTransport.STANDARD_FOOT).setGeometryGeoJson(geometryGeoJson).setGeometryGeoJsonEdges(geometryGeoJsonEdges);
        segments.add(this.walkToBusStopHeinrichVonBuolGasse);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.heinrichVonBuolGasseBusStop, this.heinrichVonBuolGasseBusStop, new GeoJSONCoordinate[0]);
        this.transferToBusHeinrichVonBuolGasse = new RouteSegment().setNr(++segmentNr).setFrom(this.heinrichVonBuolGasseBusStop).setTo(this.heinrichVonBuolGasseBusStop).setDistanceMeters(0).setDurationSeconds(300).setBoardingSeconds(300).setStartTime("2016-01-01T15:01:00+01:00").setEndTime("2016-01-01T15:06:00+01:00").setModeOfTransport(ModeOfTransport.STANDARD_TRANSFER).setGeometryGeoJson(geometryGeoJson);
        segments.add(this.transferToBusHeinrichVonBuolGasse);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.heinrichVonBuolGasseBusStop, this.floridsdorfBusStop, GeoJSONCoordinate.create("16.42354", "48.26306"), GeoJSONCoordinate.create("16.4236", "48.2621"), GeoJSONCoordinate.create("16.4044", "48.2576"), GeoJSONCoordinate.create("16.40305", "48.25621"), GeoJSONCoordinate.create("16.40127", "48.25698"));
        this.busFromHeinrichVonBuolGgasseToFloridsdorf = new RouteSegment().setNr(++segmentNr).setFrom(this.heinrichVonBuolGasseBusStop).setTo(this.floridsdorfBusStop).setDistanceMeters(2500).setDurationSeconds(630).setStartTime("2016-01-01T15:06:00+01:00").setEndTime("2016-01-01T15:16:30+01:00").setModeOfTransport(ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.BUS).setAccessibility(Sets.newHashSet((Object[])new Constants.VehicleAccessibility[]{Constants.VehicleAccessibility.HIGH_FLOOR_VEHICLE})).setService(this.service28A).setOperator(this.wienerLinienOperator)).setGeometryGeoJson(geometryGeoJson);
        segments.add(this.busFromHeinrichVonBuolGgasseToFloridsdorf);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.floridsdorfBusStop, this.floridsdorfSubwayStop, new GeoJSONCoordinate[0]);
        RouteSegment transferFloridsdorfFromBusToSubway = new RouteSegment().setNr(++segmentNr).setFrom(this.floridsdorfBusStop).setTo(this.floridsdorfSubwayStop).setDistanceMeters(40).setDurationSeconds(240).setBoardingSeconds(180).setStartTime("2016-01-01T15:16:30+01:00").setEndTime("2016-01-01T15:20:30+01:00").setModeOfTransport(ModeOfTransport.STANDARD_TRANSFER).setAccessibility(Arrays.asList(Constants.Accessibility.STAIRS_DOWN)).setGeometryGeoJson(geometryGeoJson);
        segments.add(transferFloridsdorfFromBusToSubway);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.floridsdorfSubwayStop, this.handelskaiSubwayStop, GeoJSONCoordinate.create("16.39468", "48.24630"));
        RouteSegment subwayFromFloridsdorfToHandelskai = new RouteSegment().setNr(++segmentNr).setFrom(this.floridsdorfSubwayStop).setTo(this.handelskaiSubwayStop).setDistanceMeters(2000).setDurationSeconds(240).setStartTime("2016-01-01T15:20:30+01:00").setEndTime("2016-01-01T15:24:30+01:00").setIntermediateStops(Arrays.asList(this.createIntermediateStopNeueDonau())).setModeOfTransport(ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.SUBWAY).setAccessibility(Sets.newHashSet((Object[])new Constants.VehicleAccessibility[]{Constants.VehicleAccessibility.LOW_FLOOR_VEHICLE})).setService(this.serviceU6).setOperator(this.wienerLinienOperator).setColor("#bf7700")).setGeometryGeoJson(geometryGeoJson);
        segments.add(subwayFromFloridsdorfToHandelskai);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.handelskaiSubwayStop, this.handelskaiSubwayEntry, new GeoJSONCoordinate[0]);
        RouteSegment transferHandelskaiFromSubwayToExit = new RouteSegment().setNr(++segmentNr).setFrom(this.handelskaiSubwayStop).setTo(this.handelskaiSubwayEntry).setDistanceMeters(40).setDurationSeconds(180).setStartTime("2016-01-01T15:24:30+01:00").setEndTime("2016-01-01T15:27:30+01:00").setModeOfTransport(ModeOfTransport.STANDARD_TRANSFER).setAccessibility(Arrays.asList(Constants.Accessibility.ESCALATOR_DOWN, Constants.Accessibility.STAIRS_DOWN)).setGeometryGeoJson(geometryGeoJson);
        segments.add(transferHandelskaiFromSubwayToExit);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.handelskaiSubwayEntry, this.handelskaiCitybike, GeoJSONCoordinate.create("16.3845846", "48.2418792"));
        RouteSegment walkToCitybikeHandelskai = new RouteSegment().setNr(++segmentNr).setFrom(this.handelskaiSubwayEntry).setTo(this.handelskaiCitybike).setDistanceMeters(57).setDurationSeconds(40).setStartTime("2016-01-01T15:27:30+01:00").setEndTime("2016-01-01T15:28:10+01:00").setModeOfTransport(ModeOfTransport.STANDARD_FOOT).setGeometryGeoJson(geometryGeoJson);
        segments.add(walkToCitybikeHandelskai);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.handelskaiCitybike, this.friedrichEngelsPlatzCitybike, GeoJSONCoordinate.create("16.3838145", "48.2413853"), GeoJSONCoordinate.create("16.3807639", "48.2442201"), GeoJSONCoordinate.create("16.3793906", "48.2438237"));
        geometryGeoJson.getProperties().put("color", "#FFBBCC");
        geometryGeoJson.getProperties().put("weight", "7");
        geometryGeoJson.getProperties().put("opacity", "0.9");
        this.citybikeFromHandelskaiToFriedrichEngelsPlatz = new RouteSegment().setNr(++segmentNr).setFrom(this.handelskaiCitybike).setTo(this.friedrichEngelsPlatzCitybike).setDistanceMeters(692).setDurationSeconds(360).setBoardingSeconds(120).setAlightingSeconds(60).setStartTime("2016-01-01T15:28:10+01:00").setEndTime("2016-01-01T15:34:10+01:00").setModeOfTransport(this.citybikeMot).setGeometryGeoJson(geometryGeoJson);
        segments.add(this.citybikeFromHandelskaiToFriedrichEngelsPlatz);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.friedrichEngelsPlatzCitybike, this.car2goPickup, GeoJSONCoordinate.create("16.37763", "48.24369"));
        RouteSegment walkToCar2go = new RouteSegment().setNr(++segmentNr).setFrom(this.friedrichEngelsPlatzCitybike).setTo(this.car2goPickup).setDistanceMeters(150).setDurationSeconds(115).setStartTime("2016-01-01T15:34:10+01:00").setEndTime("2016-01-01T15:36:05+01:00").setAccessibility(Arrays.asList(Constants.Accessibility.STAIRS_UP)).setModeOfTransport(ModeOfTransport.STANDARD_FOOT).setGeometryGeoJson(geometryGeoJson);
        segments.add(walkToCar2go);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.car2goPickup, this.adalbertStifterStrasse15, GeoJSONCoordinate.create("16.373601", "48.24218"));
        this.car2goAlongAdalbertStifterStrasse = new RouteSegment().setNr(++segmentNr).setFrom(this.car2goPickup).setTo(this.adalbertStifterStrasse15).setDistanceMeters(692).setDurationSeconds(420).setBoardingSeconds(120).setAlightingSeconds(60).setStartTime("2016-01-01T15:36:05+01:00").setEndTime("2016-01-01T15:43:05+01:00").setModeOfTransport(ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.CAR).setSharingType(Constants.Sharing.FREE_FLOATING_VEHICLE_SHARING).setElectric(true).setOperator(this.car2goOperator).setAdditionalInfo((Map<String, Object>)ImmutableMap.of((Object)"licensePlate", (Object)"W-123456", (Object)"fuelPercentage", (Object)"80", (Object)"interiorState", (Object)"good", (Object)"exteriorState", (Object)"unacceptable"))).setGeometryGeoJson(geometryGeoJson);
        segments.add(this.car2goAlongAdalbertStifterStrasse);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.adalbertStifterStrasse15, this.treustrasse92, GeoJSONCoordinate.create("16.36515", "48.23729"), GeoJSONCoordinate.create("16.3656", "48.23515"), GeoJSONCoordinate.create("16.36288", "48.23509"));
        ArrayList navigationInstructions = new ArrayList();
        navigationInstructions.add(RoadInstruction.createMinimalRouteStart(this.adalbertStifterStrasse15.getSimpleCoordinate(), Optional.of("Adalbert-Stifter-Stra\u00dfe"), Optional.of(Constants.FormOfWay.ROAD)));
        navigationInstructions.add(RoadInstruction.createMinimalOnRoute(GeoJSONCoordinate.create("16.3651564", "48.2372703"), Constants.TurnDirection.SLIGHT_LEFT, Optional.of("Klosterneuburger Stra\u00dfe"), Optional.of(Constants.FormOfWay.ROAD)).setLandmark(Landmark.createMinimal(Constants.Preposition.AFTER, PointOfInterest.createMinimal(GeoJSONCoordinate.create("16.3653027", "48.2374996")).setName("Wiener Backstube").setPoiType("amenity=bakery"))));
        navigationInstructions.add(RoundaboutInstruction.createMinimalEnter(GeoJSONCoordinate.create("16.36560", "48.23511")).setExitNr(2).setRoundaboutStreetName("Rondeauplatz").setOntoStreetName("Leiziger Stra\u00dfe"));
        navigationInstructions.add(RoundaboutInstruction.createMinimalExit(GeoJSONCoordinate.create("16.36560", "48.23511")).setOntoStreetName("Leipziger Stra\u00dfe").setOntoFormOfWay(Constants.FormOfWay.FOOT_CYCLEPATH));
        navigationInstructions.add(RoadInstruction.createMinimalOnRoute(GeoJSONCoordinate.create("16.36292", "48.23504"), Constants.TurnDirection.LEFT, Optional.of("Treustra\u00dfe"), Optional.of(Constants.FormOfWay.ROAD)).setContinueMeters(110));
        navigationInstructions.add(RoadInstruction.createMinimalRouteEnd(this.treustrasse92.getSimpleCoordinate(), Optional.of("Treustra\u00dfe"), Optional.of(Constants.FormOfWay.ROAD)));
        this.bicycleFromAdalbertStifterStrasseToTreugasse = new RouteSegment().setNr(++segmentNr).setFrom(this.adalbertStifterStrasse15).setTo(this.treustrasse92).setDistanceMeters(597).setDurationSeconds(226).setBoardingSeconds(60).setAlightingSeconds(60).setStartTime("2016-01-01T15:43:05+01:00").setEndTime("2016-01-01T15:46:51+01:00").setIntermediateStops(Arrays.asList(IntermediateStop.createMinimal(this.antonKummererPark))).setAdditionalInfo((Map<String, Object>)ImmutableMap.of((Object)"name", (Object)"Univega Mountainbike")).setModeOfTransport(ModeOfTransport.STANDARD_BICYCLE).setGeometryGeoJson(geometryGeoJson).setNavigationInstructions(navigationInstructions);
        segments.add(this.bicycleFromAdalbertStifterStrasseToTreugasse);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.treustrasse92, this.gaussplatz, GeoJSONCoordinate.create("16.3644", "48.2311"), GeoJSONCoordinate.create("16.36638", "48.22886"));
        this.rideSharingFromTreugasseToGaussplatz = new RouteSegment().setNr(++segmentNr).setFrom(this.treustrasse92).setTo(this.gaussplatz).setDistanceMeters(941).setDurationSeconds(292).setBoardingSeconds(180).setStartTime("2016-01-01T15:46:51+01:00").setEndTime("2016-01-01T15:51:43+01:00").setModeOfTransport(ModeOfTransport.createMinimal(Constants.DetailedModeOfTransportType.CAR).setSharingType(Constants.Sharing.RIDE_SHARING).setOperator(this.flincOperator).setAdditionalInfo((Map<String, Object>)ImmutableMap.of((Object)"userName", (Object)"herbertWien78", (Object)"phoneNumber", (Object)"+43 650 7734343"))).setGeometryGeoJson(geometryGeoJson);
        segments.add(this.rideSharingFromTreugasseToGaussplatz);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.gaussplatz, this.scholzgasse1Parking, GeoJSONCoordinate.create("16.3688", "48.2263"), GeoJSONCoordinate.create("16.3693", "48.2257"), GeoJSONCoordinate.create("16.3697", "48.2256"));
        this.carFromGaussplatzToScholzgasse = new RouteSegment().setNr(++segmentNr).setFrom(this.gaussplatz).setTo(this.scholzgasse1Parking).setDistanceMeters(299).setDurationSeconds(417).setBoardingSeconds(60).setAlightingSeconds(300).setStartTime("2016-01-01T15:51:43+01:00").setEndTime("2016-01-01T15:58:40+01:00").setModeOfTransport(ModeOfTransport.STANDARD_CAR).setGeometryGeoJson(geometryGeoJson);
        segments.add(this.carFromGaussplatzToScholzgasse);
        geometryGeoJson = GeoJSONFeature.createLineStringFeature(this.scholzgasse1Parking, this.brigittenauerLaende40, GeoJSONCoordinate.create("16.3691", "48.2243"), GeoJSONCoordinate.create("16.3681", "48.2261"));
        this.hgvFromScholzGasseToBrigittenauerLaende = new RouteSegment().setNr(++segmentNr).setFrom(this.scholzgasse1Parking).setTo(this.brigittenauerLaende40).setDistanceMeters(490).setDurationSeconds(179).setBoardingSeconds(60).setAlightingSeconds(60).setStartTime("2016-01-01T15:58:40+01:00").setEndTime("2016-01-01T16:01:39+01:00").setModeOfTransport(this.hgvMot).setGeometryGeoJson(geometryGeoJson);
        segments.add(this.hgvFromScholzGasseToBrigittenauerLaende);
        return segments;
    }

    private GeoJSONFeatureCollection<GeoJSONLineString> createGeometryGeoJsonEdgesFromGiefinggasseToHeinrichVonBuolGasse(GeoJSONFeature<GeoJSONLineString> geometryGeoJson) {
        GeoJSONFeatureCollection<GeoJSONLineString> geometryGeoJsonEdges = new GeoJSONFeatureCollection<GeoJSONLineString>();
        GeoJSONFeature<GeoJSONLineString> lineStringFeature = GeoJSONFeature.createLineStringFeature(geometryGeoJson.getGeometry().subLineString(0, 2));
        lineStringFeature.getProperties().put("name", "Giefinggasse");
        lineStringFeature.getProperties().put("frc", "6");
        lineStringFeature.getProperties().put("edgeWeight", "54.1");
        geometryGeoJsonEdges.getFeatures().add(lineStringFeature);
        lineStringFeature = GeoJSONFeature.createLineStringFeature(geometryGeoJson.getGeometry().subLineString(1, 3));
        lineStringFeature.getProperties().put("name", "Siemensstra\u00dfe");
        lineStringFeature.getProperties().put("frc", "2");
        lineStringFeature.getProperties().put("edgeWeight", "182.5");
        geometryGeoJsonEdges.getFeatures().add(lineStringFeature);
        lineStringFeature = GeoJSONFeature.createLineStringFeature(geometryGeoJson.getGeometry().subLineString(2, 4));
        lineStringFeature.getProperties().put("name", "Heinrich-von-Buol-Gasse");
        lineStringFeature.getProperties().put("frc", "3");
        lineStringFeature.getProperties().put("edgeWeight", "49.8");
        geometryGeoJsonEdges.getFeatures().add(lineStringFeature);
        return geometryGeoJsonEdges;
    }

    private IntermediateStop createIntermediateStopNeueDonau() {
        ZonedDateTime arrivalTime = ZonedDateTime.parse("2016-01-01T15:22:30+01:00");
        ZonedDateTime departureTime = arrivalTime.plus(60L, ChronoUnit.SECONDS);
        return IntermediateStop.createMinimal(this.neueDonauSubwayStop).setPlannedArrivalTime(arrivalTime).setPlannedDepartureTime(departureTime).setEstimatedArrivalTime(arrivalTime).setEstimatedDepartureTime(departureTime);
    }

    public RouteSegment getFootSegment() {
        return this.walkToBusStopHeinrichVonBuolGasse;
    }

    public RouteSegment getPrivateBicycleSegmentWithNavigationInstructions() {
        return this.bicycleFromAdalbertStifterStrasseToTreugasse;
    }

    public RouteSegment getPrivateCarSegment() {
        return this.carFromGaussplatzToScholzgasse;
    }

    public RouteSegment getTransferToPublicTransportSegment() {
        return this.transferToBusHeinrichVonBuolGasse;
    }

    public RouteSegment getBusSegment() {
        return this.busFromHeinrichVonBuolGgasseToFloridsdorf;
    }

    public RouteSegment getBikeSharingSegment() {
        return this.citybikeFromHandelskaiToFriedrichEngelsPlatz;
    }

    public RouteSegment getCarSharingSegment() {
        return this.car2goAlongAdalbertStifterStrasse;
    }

    public RouteSegment getRideSharingSegment() {
        return this.rideSharingFromTreugasseToGaussplatz;
    }
}

