/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.ModeOfTransport;
import at.ac.ait.ariadne.routeformat.RequestModeOfTransport;
import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.location.Location;
import at.ac.ait.ariadne.routeformat.util.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RoutingRequest
implements Validatable {
    public static final String NOW = "NOW";
    public static final String DEFAULT_DEPARTURE_TIME = "NOW";
    public static final String DEFAULT_OPTIMIZED_FOR = "TRAVELTIME";
    private Location<?> from;
    private List<Location<?>> via = new ArrayList();
    private Location<?> to;
    private List<RequestModeOfTransport<?>> modesOfTransport = new ArrayList();
    private Optional<RequestModeOfTransport<?>> startModeOfTransport = Optional.empty();
    private Optional<RequestModeOfTransport<?>> endModeOfTransport = Optional.empty();
    private String optimizedFor;
    private Optional<String> siteId = Optional.empty();
    private Optional<Integer> maximumTransfers = Optional.empty();
    private Optional<ZonedDateTime> departureTime = Optional.empty();
    private Optional<ZonedDateTime> arrivalTime = Optional.empty();
    private Set<Constants.AccessibilityRestriction> accessibilityRestrictions = new TreeSet<Constants.AccessibilityRestriction>();
    private List<String> languages = new ArrayList<String>();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    public RoutingRequest() {
        this.setDepartureTime("NOW");
        this.setOptimizedFor(DEFAULT_OPTIMIZED_FOR);
    }

    @Deprecated
    @JsonProperty(required=false)
    public String getServiceId() {
        return this.getSiteId().orElse("");
    }

    @JsonProperty(required=true)
    public Location<?> getFrom() {
        return this.from;
    }

    public List<Location<?>> getVia() {
        return this.via;
    }

    @JsonProperty(required=true)
    public Location<?> getTo() {
        return this.to;
    }

    @JsonProperty(required=true)
    public List<RequestModeOfTransport<?>> getModesOfTransport() {
        return this.modesOfTransport;
    }

    @JsonProperty
    public Optional<RequestModeOfTransport<?>> getStartModeOfTransport() {
        return this.startModeOfTransport;
    }

    @JsonProperty
    public Optional<RequestModeOfTransport<?>> getEndModeOfTransport() {
        return this.endModeOfTransport;
    }

    @JsonProperty(required=true)
    public String getOptimizedFor() {
        return this.optimizedFor;
    }

    public Optional<String> getSiteId() {
        return this.siteId;
    }

    @JsonProperty
    public Optional<Integer> getMaximumTransfers() {
        return this.maximumTransfers;
    }

    @JsonProperty
    public Optional<String> getDepartureTime() {
        return this.departureTime.map(time -> time.toString());
    }

    @JsonIgnore
    public Optional<ZonedDateTime> getDepartureTimeAsZonedDateTime() {
        return this.departureTime;
    }

    @JsonProperty
    public Optional<String> getArrivalTime() {
        return this.arrivalTime.map(time -> time.toString());
    }

    @JsonIgnore
    public Optional<ZonedDateTime> getArrivalTimeAsZonedDateTime() {
        return this.arrivalTime;
    }

    public Set<Constants.AccessibilityRestriction> getAccessibilityRestrictions() {
        return this.accessibilityRestrictions;
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    @JsonIgnore
    public List<Locale> getLanguagesAsLocales() {
        return this.languages.stream().map(l -> Locale.forLanguageTag(l)).collect(Collectors.toList());
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @Deprecated
    public RoutingRequest setServiceId(String serviceId) {
        return this.setSiteId(serviceId);
    }

    public RoutingRequest setFrom(Location<?> from) {
        this.from = from;
        return this;
    }

    public RoutingRequest setVia(List<Location<?>> via) {
        this.via = new ArrayList(via);
        return this;
    }

    public RoutingRequest setTo(Location<?> to) {
        this.to = to;
        return this;
    }

    public RoutingRequest setModesOfTransport(List<RequestModeOfTransport<?>> modesOfTransport) {
        Set types;
        this.modesOfTransport = new ArrayList(modesOfTransport);
        if (this.modesOfTransport.size() > 1 && !(types = this.modesOfTransport.stream().map(m -> m.getModeOfTransport().getGeneralizedType()).collect(Collectors.toSet())).contains((Object)Constants.GeneralizedModeOfTransportType.FOOT)) {
            this.modesOfTransport.add(RequestModeOfTransport.createMinimal(ModeOfTransport.STANDARD_FOOT));
        }
        return this;
    }

    public RoutingRequest setStartModeOfTransport(RequestModeOfTransport<?> startModeOfTransport) {
        this.startModeOfTransport = Optional.ofNullable(startModeOfTransport);
        return this;
    }

    public RoutingRequest setEndModeOfTransport(RequestModeOfTransport<?> endModeOfTransport) {
        this.endModeOfTransport = Optional.ofNullable(endModeOfTransport);
        return this;
    }

    public RoutingRequest setOptimizedFor(String optimizedFor) {
        this.optimizedFor = optimizedFor;
        return this;
    }

    public RoutingRequest setSiteId(String siteId) {
        this.siteId = Optional.ofNullable(siteId);
        return this;
    }

    public RoutingRequest setMaximumTransfers(Integer maximumTransfers) {
        this.maximumTransfers = Optional.ofNullable(maximumTransfers);
        return this;
    }

    @JsonIgnore
    public RoutingRequest setDepartureTime(ZonedDateTime departureTime) {
        if (departureTime == null) {
            this.departureTime = Optional.empty();
        } else {
            this.departureTime = Optional.ofNullable(departureTime.truncatedTo(ChronoUnit.SECONDS));
            this.arrivalTime = Optional.empty();
        }
        return this;
    }

    @JsonProperty
    public RoutingRequest setDepartureTime(String departureTime) {
        if (departureTime == null) {
            this.departureTime = Optional.empty();
        } else if (departureTime.equalsIgnoreCase("NOW")) {
            this.departureTime = Optional.of(ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS));
            this.arrivalTime = Optional.empty();
        } else {
            this.departureTime = Optional.of(Utils.parseZonedDateTime(departureTime, "departureTime"));
            this.arrivalTime = Optional.empty();
        }
        return this;
    }

    @JsonIgnore
    public RoutingRequest setArrivalTime(ZonedDateTime arrivalTime) {
        if (arrivalTime == null) {
            this.arrivalTime = Optional.empty();
        } else {
            this.arrivalTime = Optional.ofNullable(arrivalTime.truncatedTo(ChronoUnit.SECONDS));
            this.departureTime = Optional.empty();
        }
        return this;
    }

    @JsonProperty
    public RoutingRequest setArrivalTime(String arrivalTime) {
        if (arrivalTime == null) {
            this.arrivalTime = Optional.empty();
        } else if (arrivalTime.equalsIgnoreCase("NOW")) {
            this.arrivalTime = Optional.of(ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS));
            this.departureTime = Optional.empty();
        } else {
            this.arrivalTime = Optional.of(Utils.parseZonedDateTime(arrivalTime, "arrivalTime"));
            this.departureTime = Optional.empty();
        }
        return this;
    }

    public RoutingRequest setAccessibilityRestrictions(Set<Constants.AccessibilityRestriction> accessibilityRestrictions) {
        this.accessibilityRestrictions = new TreeSet<Constants.AccessibilityRestriction>(accessibilityRestrictions);
        return this;
    }

    public RoutingRequest setLanguages(List<String> languages) {
        this.languages = new ArrayList<String>(languages);
        return this;
    }

    public RoutingRequest setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public static RoutingRequest createMinimal(Location<?> from, Location<?> to, List<RequestModeOfTransport<?>> modesOfTransport) {
        return new RoutingRequest().setFrom(from).setTo(to).setModesOfTransport(modesOfTransport);
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.from != null ? 1 : 0) != 0, (Object)"from is mandatory but missing");
        this.from.validate();
        this.via.forEach(v -> v.validate());
        Preconditions.checkArgument((this.to != null ? 1 : 0) != 0, (Object)"to is mandatory but missing");
        this.to.validate();
        Preconditions.checkArgument((this.modesOfTransport != null && !this.modesOfTransport.isEmpty() ? 1 : 0) != 0, (Object)"modesOfTransport is mandatory but missing/empty");
        if (this.modesOfTransport.size() > 1) {
            Set types = this.modesOfTransport.stream().map(m -> m.getModeOfTransport().getGeneralizedType()).collect(Collectors.toSet());
            Preconditions.checkArgument((boolean)types.contains((Object)Constants.GeneralizedModeOfTransportType.FOOT), (Object)"intermodal routing without walking is not possible");
        }
        this.modesOfTransport.forEach(m -> m.validate());
        this.startModeOfTransport.ifPresent(s -> {
            Preconditions.checkArgument((boolean)this.modesOfTransport.contains(s), (Object)"startModeOfTransport is not contained in the available modes of transport");
            s.validate();
        });
        this.endModeOfTransport.ifPresent(e -> {
            Preconditions.checkArgument((boolean)this.modesOfTransport.contains(e), (Object)"endModeOfTransport is not contained in the available modes of transport");
            e.validate();
        });
        Preconditions.checkArgument((this.optimizedFor != null ? 1 : 0) != 0, (Object)"optimizedFor is mandatory but missing");
        Utils.checkPositiveIntegerOrEmpty(this.maximumTransfers, "maximumTransfers");
        Preconditions.checkArgument((this.departureTime.isPresent() && !this.arrivalTime.isPresent() || !this.departureTime.isPresent() && this.arrivalTime.isPresent() ? 1 : 0) != 0, (Object)"either departureTime or arrivalTime must be set");
        Preconditions.checkArgument((!this.departureTime.isPresent() || !this.arrivalTime.isPresent() ? 1 : 0) != 0, (Object)"departureTime and arrivalTime are mutually exclusive, only one can be set at once");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accessibilityRestrictions == null ? 0 : this.accessibilityRestrictions.hashCode());
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.arrivalTime == null ? 0 : this.arrivalTime.hashCode());
        result = 31 * result + (this.departureTime == null ? 0 : this.departureTime.hashCode());
        result = 31 * result + (this.endModeOfTransport == null ? 0 : this.endModeOfTransport.hashCode());
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.languages == null ? 0 : this.languages.hashCode());
        result = 31 * result + (this.maximumTransfers == null ? 0 : this.maximumTransfers.hashCode());
        result = 31 * result + (this.modesOfTransport == null ? 0 : this.modesOfTransport.hashCode());
        result = 31 * result + (this.optimizedFor == null ? 0 : this.optimizedFor.hashCode());
        result = 31 * result + (this.siteId == null ? 0 : this.siteId.hashCode());
        result = 31 * result + (this.startModeOfTransport == null ? 0 : this.startModeOfTransport.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        result = 31 * result + (this.via == null ? 0 : this.via.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RoutingRequest other = (RoutingRequest)obj;
        if (this.accessibilityRestrictions == null ? other.accessibilityRestrictions != null : !this.accessibilityRestrictions.equals(other.accessibilityRestrictions)) {
            return false;
        }
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.arrivalTime == null ? other.arrivalTime != null : !this.arrivalTime.equals(other.arrivalTime)) {
            return false;
        }
        if (this.departureTime == null ? other.departureTime != null : !this.departureTime.equals(other.departureTime)) {
            return false;
        }
        if (this.endModeOfTransport == null ? other.endModeOfTransport != null : !this.endModeOfTransport.equals(other.endModeOfTransport)) {
            return false;
        }
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        if (this.languages == null ? other.languages != null : !this.languages.equals(other.languages)) {
            return false;
        }
        if (this.maximumTransfers == null ? other.maximumTransfers != null : !this.maximumTransfers.equals(other.maximumTransfers)) {
            return false;
        }
        if (this.modesOfTransport == null ? other.modesOfTransport != null : !this.modesOfTransport.equals(other.modesOfTransport)) {
            return false;
        }
        if (this.optimizedFor == null ? other.optimizedFor != null : !this.optimizedFor.equals(other.optimizedFor)) {
            return false;
        }
        if (this.siteId == null ? other.siteId != null : !this.siteId.equals(other.siteId)) {
            return false;
        }
        if (this.startModeOfTransport == null ? other.startModeOfTransport != null : !this.startModeOfTransport.equals(other.startModeOfTransport)) {
            return false;
        }
        if (this.to == null ? other.to != null : !this.to.equals(other.to)) {
            return false;
        }
        return !(this.via == null ? other.via != null : !this.via.equals(other.via));
    }

    public String toString() {
        return "RoutingRequest [from=" + this.from + ", via=" + this.via + ", to=" + this.to + ", modesOfTransport=" + this.modesOfTransport + ", startModeOfTransport=" + this.startModeOfTransport + ", endModeOfTransport=" + this.endModeOfTransport + ", optimizedFor=" + this.optimizedFor + ", siteId=" + this.siteId + ", maximumTransfers=" + this.maximumTransfers + ", departureTime=" + this.departureTime + ", arrivalTime=" + this.arrivalTime + ", accessibilityRestrictions=" + this.accessibilityRestrictions + ", languages=" + this.languages + ", additionalInfo=" + this.additionalInfo + "]";
    }
}

