/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.location;

import at.ac.ait.ariadne.routeformat.Validatable;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Address
implements Validatable {
    private Optional<String> country = Optional.empty();
    private Optional<String> city = Optional.empty();
    private Optional<String> postCode = Optional.empty();
    private Optional<String> streetName = Optional.empty();
    private Optional<String> houseNumber = Optional.empty();
    private Map<String, String> additionalInfo = new TreeMap<String, String>();

    public Optional<String> getCountry() {
        return this.country;
    }

    public Optional<String> getCity() {
        return this.city;
    }

    public Optional<String> getPostCode() {
        return this.postCode;
    }

    public Optional<String> getStreetName() {
        return this.streetName;
    }

    public Optional<String> getHouseNumber() {
        return this.houseNumber;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public Address setCountry(String country) {
        this.country = Optional.ofNullable(country);
        return this;
    }

    public Address setCity(String city) {
        this.city = Optional.ofNullable(city);
        return this;
    }

    public Address setPostCode(String postCode) {
        this.postCode = Optional.ofNullable(postCode);
        return this;
    }

    public Address setStreetName(String streetName) {
        this.streetName = Optional.ofNullable(streetName);
        return this;
    }

    public Address setHouseNumber(String houseNumber) {
        this.houseNumber = Optional.ofNullable(houseNumber);
        return this;
    }

    public Address setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = new TreeMap<String, String>(additionalInfo);
        return this;
    }

    public static Address create(String streetName, String houseNumber) {
        return new Address().setStreetName(streetName).setHouseNumber(houseNumber);
    }

    @Override
    public void validate() {
    }

    public String toString() {
        ArrayList fields = new ArrayList();
        this.country.ifPresent(f -> fields.add(f));
        this.city.ifPresent(f -> fields.add(f));
        this.postCode.ifPresent(f -> fields.add(f));
        this.streetName.ifPresent(f -> fields.add(f));
        this.houseNumber.ifPresent(f -> fields.add(f));
        return Joiner.on((String)"|").join(fields);
    }
}

