/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.instruction;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.instruction.Instruction;
import at.ac.ait.ariadne.routeformat.instruction.Landmark;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RoadInstruction
extends Instruction<RoadInstruction> {
    private SubType subType;
    private Optional<Constants.GeneralizedModeOfTransportType> modeOfTransport = Optional.empty();
    private Optional<Constants.TurnDirection> turnDirection = Optional.empty();
    private Optional<Constants.CompassDirection> compassDirection = Optional.empty();
    private Optional<Boolean> roadChange = Optional.empty();
    private Optional<String> ontoStreetName = Optional.empty();
    private Optional<Constants.FormOfWay> ontoFormOfWay = Optional.empty();
    private Optional<Boolean> enterBridge = Optional.empty();
    private Optional<Constants.Tunnel> enterTunnel = Optional.empty();
    private Optional<Boolean> ontoRightSideOfRoad = Optional.empty();
    private Optional<Constants.RoadCrossing> crossing = Optional.empty();
    private Optional<Integer> continueMeters = Optional.empty();
    private Optional<Integer> continueSeconds = Optional.empty();
    private Optional<String> continueUntilIntersectingStreetName = Optional.empty();
    private Optional<Landmark> landmark = Optional.empty();
    private Optional<Landmark> confirmationLandmark = Optional.empty();

    @JsonProperty(required=true)
    public SubType getSubType() {
        return this.subType;
    }

    public Optional<Constants.GeneralizedModeOfTransportType> getModeOfTransport() {
        return this.modeOfTransport;
    }

    public Optional<Constants.TurnDirection> getTurnDirection() {
        return this.turnDirection;
    }

    public Optional<Constants.CompassDirection> getCompassDirection() {
        return this.compassDirection;
    }

    public Optional<Boolean> getRoadChange() {
        return this.roadChange;
    }

    public Optional<String> getOntoStreetName() {
        return this.ontoStreetName;
    }

    public Optional<Constants.FormOfWay> getOntoFormOfWay() {
        return this.ontoFormOfWay;
    }

    public Optional<Boolean> getEnterBridge() {
        return this.enterBridge;
    }

    public Optional<Constants.Tunnel> getEnterTunnel() {
        return this.enterTunnel;
    }

    public Optional<Boolean> getOntoRightSideOfRoad() {
        return this.ontoRightSideOfRoad;
    }

    public Optional<Constants.RoadCrossing> getCrossing() {
        return this.crossing;
    }

    public Optional<Integer> getContinueMeters() {
        return this.continueMeters;
    }

    public Optional<Integer> getContinueSeconds() {
        return this.continueSeconds;
    }

    public Optional<String> getContinueUntilIntersectingStreetName() {
        return this.continueUntilIntersectingStreetName;
    }

    public Optional<Landmark> getLandmark() {
        return this.landmark;
    }

    public Optional<Landmark> getConfirmationLandmark() {
        return this.confirmationLandmark;
    }

    public RoadInstruction setSubType(SubType subType) {
        this.subType = subType;
        return this;
    }

    public RoadInstruction setModeOfTransport(Constants.GeneralizedModeOfTransportType modeOfTransport) {
        this.modeOfTransport = Optional.ofNullable(modeOfTransport);
        return this;
    }

    public RoadInstruction setTurnDirection(Constants.TurnDirection turnDirection) {
        this.turnDirection = Optional.ofNullable(turnDirection);
        return this;
    }

    public RoadInstruction setCompassDirection(Constants.CompassDirection compassDirection) {
        this.compassDirection = Optional.ofNullable(compassDirection);
        return this;
    }

    public RoadInstruction setRoadChange(Boolean roadChange) {
        this.roadChange = Optional.ofNullable(roadChange);
        return this;
    }

    public RoadInstruction setOntoStreetName(String ontoStreetName) {
        this.ontoStreetName = Optional.ofNullable(ontoStreetName);
        return this;
    }

    public RoadInstruction setOntoFormOfWay(Constants.FormOfWay ontoFormOfWay) {
        this.ontoFormOfWay = Optional.ofNullable(ontoFormOfWay);
        return this;
    }

    public RoadInstruction setEnterBridge(Boolean enterBridge) {
        this.enterBridge = Optional.ofNullable(enterBridge);
        return this;
    }

    public RoadInstruction setEnterTunnel(Constants.Tunnel enterTunnel) {
        this.enterTunnel = Optional.ofNullable(enterTunnel);
        return this;
    }

    public RoadInstruction setOntoRightSideOfRoad(Boolean ontoRightSideOfRoad) {
        this.ontoRightSideOfRoad = Optional.ofNullable(ontoRightSideOfRoad);
        return this;
    }

    public RoadInstruction setCrossing(Constants.RoadCrossing crossing) {
        this.crossing = Optional.ofNullable(crossing);
        return this;
    }

    public RoadInstruction setContinueMeters(Integer continueMeters) {
        this.continueMeters = Optional.ofNullable(continueMeters);
        return this;
    }

    public RoadInstruction setContinueSeconds(Integer continueSeconds) {
        this.continueSeconds = Optional.ofNullable(continueSeconds);
        return this;
    }

    public RoadInstruction setContinueUntilIntersectingStreetName(String continueUntilIntersectingStreetName) {
        this.continueUntilIntersectingStreetName = Optional.ofNullable(continueUntilIntersectingStreetName);
        return this;
    }

    public RoadInstruction setLandmark(Landmark landmark) {
        this.landmark = Optional.ofNullable(landmark);
        return this;
    }

    public RoadInstruction setConfirmationLandmark(Landmark confirmationLandmark) {
        this.confirmationLandmark = Optional.ofNullable(confirmationLandmark);
        return this;
    }

    public static RoadInstruction createMinimalRouteStart(GeoJSONCoordinate position, Optional<String> ontoStreetName, Optional<Constants.FormOfWay> ontoFormOfWay) {
        return ((RoadInstruction)new RoadInstruction().setPosition(position)).setSubType(SubType.ROUTE_START).setOntoStreetName(ontoStreetName.orElse(null)).setOntoFormOfWay(ontoFormOfWay.orElse(null));
    }

    public static RoadInstruction createMinimalOnRoute(GeoJSONCoordinate position, Constants.TurnDirection turnDirection, Optional<String> ontoStreetName, Optional<Constants.FormOfWay> ontoFormOfWay) {
        return ((RoadInstruction)new RoadInstruction().setPosition(position)).setSubType(RoadInstruction.getSubType(turnDirection)).setTurnDirection(turnDirection).setOntoStreetName(ontoStreetName.orElse(null)).setOntoFormOfWay(ontoFormOfWay.orElse(null));
    }

    public static RoadInstruction createMinimalRouteEnd(GeoJSONCoordinate position, Optional<String> onStreetName, Optional<Constants.FormOfWay> onFormOfWay) {
        return ((RoadInstruction)new RoadInstruction().setPosition(position)).setSubType(SubType.ROUTE_END).setOntoStreetName(onStreetName.orElse(null)).setOntoFormOfWay(onFormOfWay.orElse(null));
    }

    private static SubType getSubType(Constants.TurnDirection turnDirection) {
        if (turnDirection == Constants.TurnDirection.U_TURN) {
            return SubType.U_TURN;
        }
        if (turnDirection == Constants.TurnDirection.STRAIGHT) {
            return SubType.STRAIGHT;
        }
        return SubType.TURN;
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.subType != null ? 1 : 0) != 0, (Object)"subType is mandatory but missing");
        Preconditions.checkArgument((this.ontoStreetName.isPresent() || this.ontoFormOfWay.isPresent() ? 1 : 0) != 0, (Object)"at least one onto-type is required");
    }

    @Override
    public String toString() {
        return super.toString() + " -> RoadInstruction [subType=" + (Object)((Object)this.subType) + ", modeOfTransport=" + this.modeOfTransport + ", turnDirection=" + this.turnDirection + ", compassDirection=" + this.compassDirection + ", roadChange=" + this.roadChange + ", ontoStreetName=" + this.ontoStreetName + ", ontoFormOfWay=" + this.ontoFormOfWay + ", enterBridge=" + this.enterBridge + ", enterTunnel=" + this.enterTunnel + ", ontoRightSideOfRoad=" + this.ontoRightSideOfRoad + ", continueMeters=" + this.continueMeters + ", continueSeconds=" + this.continueSeconds + ", continueUntilIntersectingStreetName=" + this.continueUntilIntersectingStreetName + ", landmark=" + this.landmark + ", confirmationLandmark=" + this.confirmationLandmark + "]";
    }

    public static enum SubType {
        ROUTE_START,
        ROUTE_END,
        STRAIGHT,
        TURN,
        U_TURN,
        SWITCH_SIDE_OF_ROAD;

    }
}

