/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.instruction;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.instruction.Instruction;
import at.ac.ait.ariadne.routeformat.instruction.Landmark;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Preconditions;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class AreaInstruction
extends Instruction<AreaInstruction> {
    private SubType subType;
    private Optional<String> areaName = Optional.empty();
    private Optional<Constants.Area> areaType = Optional.empty();
    private Optional<String> exitStreetName = Optional.empty();
    private Optional<Landmark> exitLandmark = Optional.empty();

    public SubType getSubType() {
        return this.subType;
    }

    public Optional<String> getAreaName() {
        return this.areaName;
    }

    public Optional<Constants.Area> getAreaType() {
        return this.areaType;
    }

    public Optional<String> getExitStreetName() {
        return this.exitStreetName;
    }

    public Optional<Landmark> getExitLandmark() {
        return this.exitLandmark;
    }

    public AreaInstruction setSubType(SubType subType) {
        this.subType = subType;
        return this;
    }

    public AreaInstruction setAreaName(String areaName) {
        this.areaName = Optional.ofNullable(areaName);
        return this;
    }

    public AreaInstruction setAreaType(Constants.Area areaType) {
        this.areaType = Optional.ofNullable(areaType);
        return this;
    }

    public AreaInstruction setExitStreetName(String exitStreetName) {
        this.exitStreetName = Optional.ofNullable(exitStreetName);
        return this;
    }

    public AreaInstruction setExitLandmark(Landmark exitLandmark) {
        this.exitLandmark = Optional.ofNullable(exitLandmark);
        return this;
    }

    public static AreaInstruction createMinimalEnter(GeoJSONCoordinate position) {
        return ((AreaInstruction)new AreaInstruction().setPosition(position)).setSubType(SubType.ENTER);
    }

    public static AreaInstruction createMinimalExit(GeoJSONCoordinate position) {
        return ((AreaInstruction)new AreaInstruction().setPosition(position)).setSubType(SubType.EXIT);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.subType != null ? 1 : 0) != 0, (Object)"subType is mandatory but missing");
        Preconditions.checkArgument((this.areaName.isPresent() || this.areaType.isPresent() ? 1 : 0) != 0, (Object)"at least one of area name and area type is required");
    }

    @Override
    public String toString() {
        return super.toString() + " -> AreaInstruction [subType=" + (Object)((Object)this.subType) + ", areaName=" + this.areaName + ", areaType=" + this.areaType + ", exitStreetName=" + this.exitStreetName + ", exitLandmark=" + this.exitLandmark + "]";
    }

    public static enum SubType {
        ENTER,
        EXIT;

    }
}

