/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.geojson;

import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.List;

public class GeoJSONUtil {
    public static String getTypeName(Class<?> clazz) {
        return clazz.getSimpleName().replaceAll("GeoJSON", "");
    }

    public static void assertLinearRing(List<GeoJSONCoordinate> coordinates) {
        int count = coordinates.size();
        Preconditions.checkArgument((count >= 4 ? 1 : 0) != 0, (String)"four coordinates required, got only %s", (Object[])new Object[]{count});
        BigDecimal x1 = coordinates.get(0).getX();
        BigDecimal x2 = coordinates.get(count - 1).getX();
        BigDecimal y1 = coordinates.get(0).getY();
        BigDecimal y2 = coordinates.get(count - 1).getY();
        Preconditions.checkArgument((boolean)x1.equals(x2), (String)"X value of first & last coordinate must be the same: %s != %s", (Object[])new Object[]{x1, x2});
        Preconditions.checkArgument((boolean)y1.equals(y2), (String)"Y value of first & last coordinate must be the same: %s != %s", (Object[])new Object[]{y1, y2});
    }
}

