/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.geojson;

import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinate;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONGeometryObject;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONUtil;
import at.ac.ait.ariadne.routeformat.geojson.WKTUtil;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.ALWAYS)
public class GeoJSONPolygon
implements GeoJSONGeometryObject {
    private List<List<GeoJSONCoordinate>> coordinates = new ArrayList<List<GeoJSONCoordinate>>();

    @JsonProperty(required=true)
    public List<List<GeoJSONCoordinate>> getCoordinates() {
        return this.coordinates;
    }

    public GeoJSONPolygon setCoordinates(List<List<GeoJSONCoordinate>> coordinates) {
        this.coordinates = new ArrayList<List<GeoJSONCoordinate>>();
        for (List<GeoJSONCoordinate> ring : coordinates) {
            this.coordinates.add(new ArrayList<GeoJSONCoordinate>(ring));
        }
        return this;
    }

    public static GeoJSONPolygon create(List<List<GeoJSONCoordinate>> points) {
        return new GeoJSONPolygon().setCoordinates(points);
    }

    @Override
    public boolean isEmpty() {
        return this.coordinates.isEmpty();
    }

    @Override
    public void validate() {
        for (List<GeoJSONCoordinate> ring : this.coordinates) {
            GeoJSONUtil.assertLinearRing(ring);
        }
    }

    @Override
    public String toWKT() {
        return this.getTypeName() + " " + WKTUtil.getCoordinateStringPolygon(this.coordinates);
    }

    public String toString() {
        return this.toWKT();
    }
}

