/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.geojson;

import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinateDeserializer;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONCoordinateSerializer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

@JsonDeserialize(using=GeoJSONCoordinateDeserializer.class)
@JsonSerialize(using=GeoJSONCoordinateSerializer.class)
public class GeoJSONCoordinate
implements Validatable {
    private BigDecimal x;
    private BigDecimal y;
    private Optional<BigDecimal> z = Optional.empty();

    public BigDecimal getX() {
        return this.x;
    }

    public BigDecimal getY() {
        return this.y;
    }

    public Optional<BigDecimal> getZ() {
        return this.z;
    }

    public GeoJSONCoordinate setX(BigDecimal x) {
        this.x = x;
        return this;
    }

    public GeoJSONCoordinate setY(BigDecimal y) {
        this.y = y;
        return this;
    }

    public GeoJSONCoordinate setZ(BigDecimal z) {
        this.z = Optional.ofNullable(z);
        return this;
    }

    public static GeoJSONCoordinate create(double x, double y) {
        return GeoJSONCoordinate.create(String.format(Locale.US, "%.7f", x), String.format(Locale.US, "%.7f", y));
    }

    public static GeoJSONCoordinate create(double x, double y, double z) {
        return GeoJSONCoordinate.create(String.format(Locale.US, "%.7f", x), String.format(Locale.US, "%.7f", y), String.format(Locale.US, "%.7f", z));
    }

    public static GeoJSONCoordinate create(String x, String y) {
        return GeoJSONCoordinate.create(new BigDecimal(x), new BigDecimal(y));
    }

    public static GeoJSONCoordinate create(String x, String y, String z) {
        return GeoJSONCoordinate.create(new BigDecimal(x), new BigDecimal(y), new BigDecimal(z));
    }

    public static GeoJSONCoordinate create(List<BigDecimal> coordinates) {
        switch (coordinates.size()) {
            case 2: {
                return GeoJSONCoordinate.create(coordinates.get(0), coordinates.get(1));
            }
            case 3: {
                return GeoJSONCoordinate.create(coordinates.get(0), coordinates.get(1), coordinates.get(2));
            }
        }
        throw new IllegalArgumentException("exactly 2 or 3 coordinates allowed, but were " + coordinates.size());
    }

    public static GeoJSONCoordinate create(BigDecimal x, BigDecimal y) {
        return new GeoJSONCoordinate().setX(x).setY(y);
    }

    public static GeoJSONCoordinate create(BigDecimal x, BigDecimal y, BigDecimal z) {
        return new GeoJSONCoordinate().setX(x).setY(y).setZ(z);
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.x != null ? 1 : 0) != 0, (Object)"x is mandatory but missing");
        Preconditions.checkArgument((this.y != null ? 1 : 0) != 0, (Object)"y is mandatory but missing");
    }

    @JsonIgnore
    public List<BigDecimal> asNewList() {
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        list.add(this.x);
        list.add(this.y);
        return list;
    }

    public String toString() {
        return "Coordinate [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

