/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.features;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.ModeOfTransport;
import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.features.OptimizedFor;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONFeature;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPoint;
import at.ac.ait.ariadne.routeformat.geojson.GeoJSONPolygon;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Site
implements Validatable {
    private String id;
    private Optional<String> name = Optional.empty();
    private List<OptimizedFor> optimizedFor = new ArrayList<OptimizedFor>();
    private List<ModeOfTransport> modesOfTransport = new ArrayList<ModeOfTransport>();
    private Optional<GeoJSONFeature<GeoJSONPoint>> focusPoint = Optional.empty();
    private Optional<Integer> zoomLevel = Optional.empty();
    private Optional<GeoJSONFeature<GeoJSONPolygon>> boundingPolygon = Optional.empty();
    private List<Constants.SiteFeature> features = new ArrayList<Constants.SiteFeature>();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public String getId() {
        return this.id;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public List<OptimizedFor> getOptimizedFor() {
        return this.optimizedFor;
    }

    public List<ModeOfTransport> getModesOfTransport() {
        return this.modesOfTransport;
    }

    public Optional<GeoJSONFeature<GeoJSONPoint>> getFocusPoint() {
        return this.focusPoint;
    }

    public Optional<Integer> getZoomLevel() {
        return this.zoomLevel;
    }

    public Optional<GeoJSONFeature<GeoJSONPolygon>> getBoundingPolygon() {
        return this.boundingPolygon;
    }

    public List<Constants.SiteFeature> getFeatures() {
        return this.features;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public Site setId(String id) {
        this.id = id;
        return this;
    }

    public Site setName(String name) {
        this.name = Optional.ofNullable(name);
        return this;
    }

    public Site setOptimizedFor(List<OptimizedFor> optimizedFor) {
        this.optimizedFor = new ArrayList<OptimizedFor>(optimizedFor);
        return this;
    }

    public Site setModesOfTransport(List<ModeOfTransport> modesOfTransport) {
        this.modesOfTransport = new ArrayList<ModeOfTransport>(modesOfTransport);
        return this;
    }

    public Site setFocusPoint(GeoJSONFeature<GeoJSONPoint> focusPoint) {
        this.focusPoint = Optional.ofNullable(focusPoint);
        return this;
    }

    public Site setZoomLevel(Integer zoomLevel) {
        this.zoomLevel = Optional.ofNullable(zoomLevel);
        return this;
    }

    public Site setBoundingPolygon(GeoJSONFeature<GeoJSONPolygon> boundingPolygon) {
        this.boundingPolygon = Optional.ofNullable(boundingPolygon);
        return this;
    }

    public Site setFeatures(List<Constants.SiteFeature> features) {
        this.features = new ArrayList<Constants.SiteFeature>(features);
        return this;
    }

    public Site setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public static Site createMinimal(String id) {
        return new Site().setId(id);
    }

    public static Site createShallowCopy(Site s) {
        Site copy = Site.createMinimal(s.getId()).setOptimizedFor(s.getOptimizedFor()).setModesOfTransport(s.getModesOfTransport()).setAdditionalInfo(s.getAdditionalInfo());
        s.getName().ifPresent(n -> copy.setName((String)n));
        s.focusPoint.ifPresent(f -> copy.setFocusPoint((GeoJSONFeature<GeoJSONPoint>)f));
        s.zoomLevel.ifPresent(z -> copy.setZoomLevel((Integer)z));
        s.boundingPolygon.ifPresent(b -> copy.setBoundingPolygon((GeoJSONFeature<GeoJSONPolygon>)b));
        return copy;
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.id != null ? 1 : 0) != 0, (Object)"id is mandatory but missing");
    }

    public String toString() {
        return "Site [id=" + this.id + ", name=" + this.name + ", optimizedFor=" + this.optimizedFor + ", modesOfTransport=" + this.modesOfTransport + ", focusPoint=" + this.focusPoint + ", zoomLevel=" + this.zoomLevel + ", boundingPolygon=" + this.boundingPolygon + ", siteFeatures=" + this.features + ", additionalInfo=" + this.additionalInfo + "]";
    }
}

