/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat.features;

import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.features.Site;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RoutingFeatures
implements Validatable {
    private String currentLanguage;
    private List<String> supportedLanguages = new ArrayList<String>();
    private String name;
    private Optional<String> url = Optional.empty();
    private Optional<String> logoUrl = Optional.empty();
    private Optional<String> credits = Optional.empty();
    private List<Site> sites = new ArrayList<Site>();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public List<String> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    @JsonProperty(required=true)
    public String getName() {
        return this.name;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<String> getLogoUrl() {
        return this.logoUrl;
    }

    public Optional<String> getCredits() {
        return this.credits;
    }

    @JsonProperty(required=true)
    public List<Site> getSites() {
        return this.sites;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public RoutingFeatures setCurrentLanguage(String currentLanguage) {
        this.currentLanguage = currentLanguage;
        return this;
    }

    public RoutingFeatures setSupportedLanguages(List<String> supportedLanguages) {
        this.supportedLanguages = new ArrayList<String>(supportedLanguages);
        return this;
    }

    public RoutingFeatures setName(String name) {
        this.name = name;
        return this;
    }

    public RoutingFeatures setUrl(String url) {
        this.url = Optional.ofNullable(url);
        return this;
    }

    public RoutingFeatures setLogoUrl(String logoUrl) {
        this.logoUrl = Optional.ofNullable(logoUrl);
        return this;
    }

    public RoutingFeatures setCredits(String credits) {
        this.credits = Optional.ofNullable(credits);
        return this;
    }

    public RoutingFeatures setSites(List<Site> sites) {
        this.sites = new ArrayList<Site>(sites);
        return this;
    }

    public RoutingFeatures setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public static RoutingFeatures createMinimal(String currentLanguage, String name, List<Site> sites) {
        return new RoutingFeatures().setCurrentLanguage(currentLanguage).setName(name).setSites(sites);
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.currentLanguage != null ? 1 : 0) != 0, (Object)"currentLanguage is mandatory but missing");
        Preconditions.checkArgument((this.name != null ? 1 : 0) != 0, (Object)"name is mandatory but missing");
    }

    public String toString() {
        return "RoutingFeatures [currentLanguage=" + this.currentLanguage + ", supportedLanguages=" + this.supportedLanguages + ", name=" + this.name + ", url=" + this.url + ", logoUrl=" + this.logoUrl + ", credits=" + this.credits + ", sites=" + this.sites + ", additionalInfo=" + this.additionalInfo + "]";
    }
}

