/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.Route;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Routes {
    public static boolean isUnimodal(Route route) {
        return !Routes.isIntermodal(route);
    }

    public static boolean isIntermodal(Route route) {
        Set usedModes = route.getSegments().stream().map(s -> s.getModeOfTransport().getGeneralizedType()).collect(Collectors.toSet());
        return usedModes.size() > 1;
    }

    public static boolean isLongerThan(Route route, int meters) {
        return route.getDistanceMeters() > meters;
    }

    public static boolean isLongerThan(Route route, Constants.GeneralizedModeOfTransportType mot, int meters) {
        int totalMeters = route.getSegments().stream().filter(s -> s.getModeOfTransport().getGeneralizedType().equals((Object)mot)).mapToInt(s -> s.getDistanceMeters()).sum();
        return totalMeters > meters;
    }

    public static boolean featuresGeneralizedMot(Route route, Constants.GeneralizedModeOfTransportType type) {
        return route.getSegments().stream().filter(s -> s.getModeOfTransport().getGeneralizedType().equals((Object)type)).count() > 0L;
    }

    public static boolean featuresOnlyDetailedMots(Route route, Collection<Constants.DetailedModeOfTransportType> types) {
        HashSet mots = route.getSegments().stream().filter(s -> s.getModeOfTransport().getDetailedType().isPresent()).map(s -> s.getModeOfTransport().getDetailedType().get()).collect(HashSet::new, Set::add, Set::addAll);
        mots.removeAll(types);
        return mots.isEmpty();
    }

    public static boolean featuresSharedGeneralizedMot(Route route, Constants.GeneralizedModeOfTransportType type) {
        return route.getSegments().stream().filter(s -> s.getModeOfTransport().getGeneralizedType().equals((Object)type)).filter(s -> s.getModeOfTransport().getSharingType().isPresent()).count() > 0L;
    }

    public static int countChanges(Route route) {
        return (int)route.getSegments().stream().filter(s -> !s.getModeOfTransport().getGeneralizedType().equals((Object)Constants.GeneralizedModeOfTransportType.FOOT)).count() - 1;
    }

    public static int getWaitingSecondsForPublicTransport(Route route) {
        int seconds = route.getSegments().stream().filter(s -> s.getModeOfTransport().getGeneralizedType().equals((Object)Constants.GeneralizedModeOfTransportType.PUBLIC_TRANSPORT)).mapToInt(s -> s.getBoardingSeconds().orElse(0)).sum();
        return seconds += route.getSegments().stream().filter(s -> s.getModeOfTransport().getDetailedType().equals(Optional.of(Constants.DetailedModeOfTransportType.TRANSFER))).mapToInt(s -> s.getAlightingSeconds().orElse(0)).sum();
    }

    public static int countUniqueModesOfTransport(Route route) {
        boolean containsPublicTransport = route.getSegments().stream().filter(s -> s.getModeOfTransport().getGeneralizedType().equals((Object)Constants.GeneralizedModeOfTransportType.PUBLIC_TRANSPORT)).count() > 0L;
        int nonPublicTransportCount = route.getSegments().stream().filter(s -> !s.getModeOfTransport().getGeneralizedType().equals((Object)Constants.GeneralizedModeOfTransportType.PUBLIC_TRANSPORT)).filter(s -> !s.getModeOfTransport().getDetailedType().equals(Optional.of(Constants.DetailedModeOfTransportType.TRANSFER))).map(s -> s.getModeOfTransport()).collect(Collectors.toSet()).size();
        return nonPublicTransportCount + (containsPublicTransport ? 1 : 0);
    }
}

