/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.Constants;
import at.ac.ait.ariadne.routeformat.Route;
import at.ac.ait.ariadne.routeformat.RoutingRequest;
import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.util.Utils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class RouteFormatRoot
implements Validatable {
    private String routeFormatVersion;
    private String requestId;
    private ZonedDateTime processedTime;
    private Constants.Status status;
    private Optional<String> debugMessage = Optional.empty();
    private String coordinateReferenceSystem;
    private Optional<RoutingRequest> request = Optional.empty();
    private List<Route> routes = new ArrayList<Route>();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public String getRouteFormatVersion() {
        return this.routeFormatVersion;
    }

    @JsonProperty(required=true)
    public String getRequestId() {
        return this.requestId;
    }

    @JsonProperty(required=true)
    public String getProcessedTime() {
        return this.processedTime.toString();
    }

    @JsonIgnore
    public ZonedDateTime getProcessedTimeAsZonedDateTime() {
        return this.processedTime;
    }

    @JsonProperty(required=true)
    public Constants.Status getStatus() {
        return this.status;
    }

    public Optional<String> getDebugMessage() {
        return this.debugMessage;
    }

    @JsonProperty(required=true)
    public String getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }

    public Optional<RoutingRequest> getRequest() {
        return this.request;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @JsonProperty(required=true)
    public List<Route> getRoutes() {
        return this.routes;
    }

    public RouteFormatRoot setRouteFormatVersion(String routeFormatVersion) {
        this.routeFormatVersion = routeFormatVersion;
        return this;
    }

    public RouteFormatRoot setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public RouteFormatRoot setProcessedTimeNow() {
        this.processedTime = ZonedDateTime.now();
        return this;
    }

    @JsonIgnore
    public RouteFormatRoot setProcessedTime(ZonedDateTime processedTime) {
        this.processedTime = processedTime;
        return this;
    }

    @JsonProperty
    public RouteFormatRoot setProcessedTime(String processedTime) {
        this.processedTime = Utils.parseZonedDateTime(processedTime, "processedTime");
        return this;
    }

    public RouteFormatRoot setStatus(Constants.Status status) {
        this.status = status;
        return this;
    }

    public RouteFormatRoot setDebugMessage(String debugMessage) {
        this.debugMessage = Optional.ofNullable(debugMessage);
        return this;
    }

    public RouteFormatRoot setCoordinateReferenceSystem(String coordinateReferenceSystem) {
        this.coordinateReferenceSystem = coordinateReferenceSystem;
        return this;
    }

    public RouteFormatRoot setDefaultCoordinateReferenceSystem() {
        this.coordinateReferenceSystem = "EPSG:4326";
        return this;
    }

    public RouteFormatRoot setRequest(RoutingRequest request) {
        this.request = Optional.ofNullable(request);
        return this;
    }

    public RouteFormatRoot setRoutes(List<Route> routes) {
        this.routes = new ArrayList<Route>(routes);
        return this;
    }

    public RouteFormatRoot setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.routeFormatVersion != null ? 1 : 0) != 0, (Object)"routeFormatVersion is mandatory but missing");
        Preconditions.checkArgument((this.requestId != null ? 1 : 0) != 0, (Object)"requestId is mandatory but missing");
        Preconditions.checkArgument((this.processedTime != null ? 1 : 0) != 0, (Object)"processedTime is mandatory but missing");
        Preconditions.checkArgument((this.status != null ? 1 : 0) != 0, (Object)"status is mandatory but missing");
        Preconditions.checkArgument((this.coordinateReferenceSystem != null ? 1 : 0) != 0, (Object)"coordinateReferenceSystem is mandatory but missing");
        Preconditions.checkArgument((boolean)this.coordinateReferenceSystem.startsWith("EPSG:"), (Object)"coordinateReferenceSystem must start with EPSG:");
        this.request.ifPresent(r -> r.validate());
        this.routes.forEach(r -> r.validate());
    }

    public String toString() {
        return "RouteFormatRoot [requestId=" + this.requestId + ", processedTime=" + this.processedTime + ", status=" + (Object)((Object)this.status) + ", routes=" + this.routes.size() + "]";
    }
}

