/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.ariadne.routeformat;

import at.ac.ait.ariadne.routeformat.Validatable;
import at.ac.ait.ariadne.routeformat.location.Address;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Operator
implements Validatable {
    private String name;
    private Optional<String> id = Optional.empty();
    private Optional<Address> address = Optional.empty();
    private Optional<String> website = Optional.empty();
    private Optional<String> customerServiceEmail = Optional.empty();
    private Optional<String> customerServicePhone = Optional.empty();
    private Map<String, Object> additionalInfo = new TreeMap<String, Object>();

    @JsonProperty(required=true)
    public String getName() {
        return this.name;
    }

    public Optional<String> getId() {
        return this.id;
    }

    public Optional<Address> getAddress() {
        return this.address;
    }

    public Optional<String> getWebsite() {
        return this.website;
    }

    public Optional<String> getCustomerServiceEmail() {
        return this.customerServiceEmail;
    }

    public Optional<String> getCustomerServicePhone() {
        return this.customerServicePhone;
    }

    public Map<String, Object> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public Operator setName(String name) {
        this.name = name;
        return this;
    }

    public Operator setId(String id) {
        this.id = Optional.ofNullable(id);
        return this;
    }

    public Operator setAddress(Address address) {
        this.address = Optional.ofNullable(address);
        return this;
    }

    public Operator setWebsite(String website) {
        this.website = Optional.ofNullable(website);
        return this;
    }

    public Operator setCustomerServiceEmail(String customerServiceEmail) {
        this.customerServiceEmail = Optional.ofNullable(customerServiceEmail);
        return this;
    }

    public Operator setCustomerServicePhone(String customerServicePhone) {
        this.customerServicePhone = Optional.ofNullable(customerServicePhone);
        return this;
    }

    public Operator setAdditionalInfo(Map<String, Object> additionalInfo) {
        this.additionalInfo = new TreeMap<String, Object>(additionalInfo);
        return this;
    }

    public static Operator createMinimal(String name) {
        return new Operator().setName(name);
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.name != null ? 1 : 0) != 0, (Object)"name is mandatory but missing");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.additionalInfo == null ? 0 : this.additionalInfo.hashCode());
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.customerServiceEmail == null ? 0 : this.customerServiceEmail.hashCode());
        result = 31 * result + (this.customerServicePhone == null ? 0 : this.customerServicePhone.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.website == null ? 0 : this.website.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Operator other = (Operator)obj;
        if (this.additionalInfo == null ? other.additionalInfo != null : !this.additionalInfo.equals(other.additionalInfo)) {
            return false;
        }
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.customerServiceEmail == null ? other.customerServiceEmail != null : !this.customerServiceEmail.equals(other.customerServiceEmail)) {
            return false;
        }
        if (this.customerServicePhone == null ? other.customerServicePhone != null : !this.customerServicePhone.equals(other.customerServicePhone)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.website == null ? other.website != null : !this.website.equals(other.website));
    }

    public String toString() {
        return "Operator [name=" + this.name + ", id=" + this.id + ", address=" + this.address + ", website=" + this.website + ", customerServiceEmail=" + this.customerServiceEmail + ", customerServicePhone=" + this.customerServicePhone + ", additionalInfo=" + this.additionalInfo + "]";
    }
}

