/*
 * Decompiled with CFR 0.152.
 */
package examples.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import examples.util.definition.Definition;
import examples.util.definition.ThreadPoolDefinition;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;

public class AsynchronousManager {
    protected static final AsynchronousManager INSTANCE = new AsynchronousManager();
    protected PooledExecutor m_threadPool = null;
    protected boolean m_initialized = false;

    public void execute(Runnable task) {
        if (this.notInitialized()) {
            throw new IllegalStateException("asynchronous thread pool not initialized");
        }
        try {
            this.m_threadPool.execute(task);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.notifyAll();
            throw new WrappedRuntimeException((Throwable)e);
        }
        catch (Exception e) {
            throw new WrappedRuntimeException((Throwable)e);
        }
    }

    public static AsynchronousManager getInstance() {
        return INSTANCE;
    }

    public synchronized void initialize(Definition definition) {
        if (definition == null) {
            return;
        }
        if (this.m_initialized) {
            return;
        }
        ThreadPoolDefinition def = (ThreadPoolDefinition)definition;
        int threadPoolMaxSize = def.getMaxSize();
        int threadPoolInitSize = def.getInitSize();
        int threadPoolMinSize = def.getMinSize();
        int keepAliveTime = def.getKeepAliveTime();
        boolean waitWhenBlocked = def.getWaitWhenBlocked();
        boolean bounded = def.getBounded();
        if (threadPoolMaxSize < threadPoolInitSize || threadPoolMaxSize < threadPoolMinSize) {
            throw new IllegalArgumentException("max size of thread pool can not exceed the init size");
        }
        if (bounded) {
            this.createBoundedThreadPool(threadPoolMaxSize, threadPoolMinSize, threadPoolInitSize, keepAliveTime, waitWhenBlocked);
        } else {
            this.createDynamicThreadPool(threadPoolMinSize, threadPoolInitSize, keepAliveTime);
        }
        this.m_initialized = true;
    }

    public void stop() {
        this.m_threadPool.shutdownNow();
    }

    protected void createBoundedThreadPool(int threadPoolMaxSize, int threadPoolMinSize, int threadPoolInitSize, int keepAliveTime, boolean waitWhenBlocked) {
        this.m_threadPool = new PooledExecutor((Channel)new BoundedBuffer(threadPoolInitSize), threadPoolMaxSize);
        this.m_threadPool.setKeepAliveTime((long)keepAliveTime);
        this.m_threadPool.createThreads(threadPoolInitSize);
        this.m_threadPool.setMinimumPoolSize(threadPoolMinSize);
        if (waitWhenBlocked) {
            this.m_threadPool.waitWhenBlocked();
        }
    }

    protected void createDynamicThreadPool(int threadPoolMinSize, int threadPoolInitSize, int keepAliveTime) {
        this.m_threadPool = new PooledExecutor((Channel)new LinkedQueue());
        this.m_threadPool.setKeepAliveTime((long)keepAliveTime);
        this.m_threadPool.createThreads(threadPoolInitSize);
        this.m_threadPool.setMinimumPoolSize(threadPoolMinSize);
    }

    protected boolean notInitialized() {
        return !this.m_initialized;
    }

    protected AsynchronousManager() {
    }
}

