/*
 * Decompiled with CFR 0.152.
 */
package examples.caching;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MethodRtti;

public class Fibonacci {
    public static int fib(int n) {
        if (n < 2) {
            System.err.println(n + ".");
            return 1;
        }
        System.err.print(n + ",");
        return Fibonacci.fib(n - 1) + Fibonacci.fib(n - 2);
    }

    public static void main(String[] args) {
        System.err.println("fib(10) = " + Fibonacci.fib(10));
    }

    public static class FibonacciCacheAspect {
        private Map m_cache = new HashMap();

        public Object cache(JoinPoint joinPoint) throws Throwable {
            MethodRtti rtti = (MethodRtti)joinPoint.getRtti();
            Integer parameter = (Integer)rtti.getParameterValues()[0];
            Integer cachedValue = (Integer)this.m_cache.get(parameter);
            if (cachedValue == null) {
                Object newValue = joinPoint.proceed();
                this.m_cache.put(parameter, newValue);
                return newValue;
            }
            System.out.println("using cache: " + cachedValue);
            return cachedValue;
        }
    }
}

