/*
 * Decompiled with CFR 0.152.
 */
package examples.caching;

import examples.caching.CacheStatistics;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.aspectwerkz.CrossCuttingInfo;
import org.codehaus.aspectwerkz.joinpoint.JoinPoint;
import org.codehaus.aspectwerkz.joinpoint.MethodRtti;
import org.codehaus.aspectwerkz.joinpoint.MethodSignature;

public class CachingAspect {
    private final CrossCuttingInfo m_info;
    private final Map m_cache = new HashMap();

    public CachingAspect(CrossCuttingInfo info) {
        this.m_info = info;
    }

    public void invocationCounter(JoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        CacheStatistics.addMethodInvocation(signature.getName(), signature.getParameterTypes());
    }

    public Object cache(JoinPoint joinPoint) throws Throwable {
        MethodRtti rtti = (MethodRtti)joinPoint.getRtti();
        Long hash = new Long(this.calculateHash(rtti));
        Object cachedResult = this.m_cache.get(hash);
        if (cachedResult != null) {
            System.out.println("using            cache");
            CacheStatistics.addCacheInvocation(rtti.getName(), rtti.getParameterTypes());
            System.out.println("parameter: timeout = " + this.m_info.getParameter("timeout"));
            return cachedResult;
        }
        Object result = joinPoint.proceed();
        this.m_cache.put(hash, result);
        return result;
    }

    private long calculateHash(MethodRtti rtti) {
        int result = 17;
        result = 37 * result + rtti.getName().hashCode();
        Object[] parameters = rtti.getParameterValues();
        int j = parameters.length;
        for (int i = 0; i < j; ++i) {
            result = 37 * result + parameters[i].hashCode();
        }
        return result;
    }
}

