/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassReader;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassWriter;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Constants;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;

public class SerialVersionUidVisitor
extends ClassAdapter
implements Constants {
    public static final String CLINIT = "<clinit>";
    public static final String INIT = "<init>";
    public static final String SVUID_NAME = "serialVersionUID";
    protected boolean m_computeSVUID = true;
    protected boolean m_hadSVUID = false;
    protected long m_SVUID;
    protected String m_className;
    protected int m_access;
    protected String[] m_interfaces;
    protected Collection m_svuidFields = new ArrayList();
    protected boolean m_hasStaticInitializer = false;
    protected Collection m_svuidConstructors = new ArrayList();
    protected Collection m_svuidMethods = new ArrayList();

    public static long calculateSerialVersionUID(Class klass) {
        try {
            ClassReader cr = new ClassReader(klass.getName());
            ClassWriter cw = AsmHelper.newClassWriter(true);
            SerialVersionUidVisitor sv = new SerialVersionUidVisitor(cw);
            cr.accept(sv, true);
            return sv.m_SVUID;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private SerialVersionUidVisitor(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        if (this.mayNeedSerialVersionUid(access)) {
            this.m_className = name;
            this.m_access = access;
            this.m_interfaces = interfaces;
        }
        super.visit(version, access, name, superName, interfaces, sourceFile);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        if (this.m_computeSVUID) {
            if (name.equals(CLINIT)) {
                this.m_hasStaticInitializer = true;
            } else if ((access & 2) == 0) {
                if (name.equals(INIT)) {
                    this.m_svuidConstructors.add(new MethodItem(name, access, desc));
                } else {
                    this.m_svuidMethods.add(new MethodItem(name, access, desc));
                }
            }
        }
        return this.cv.visitMethod(access, name, desc, exceptions, attrs);
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        if (this.m_computeSVUID) {
            if (name.equals(SVUID_NAME)) {
                this.m_hadSVUID = true;
                this.m_computeSVUID = false;
                this.m_SVUID = (Long)value;
            }
            if ((access & 2) == 0 || (access & 0x88) == 0) {
                this.m_svuidFields.add(new FieldItem(name, access, desc));
            }
        }
        super.visitField(access, name, desc, value, attrs);
    }

    public void visitEnd() {
        if (this.m_computeSVUID && !this.m_hadSVUID) {
            try {
                this.m_SVUID = this.computeSVUID();
            }
            catch (Throwable e) {
                throw new RuntimeException("Error while computing SVUID for " + this.m_className, e);
            }
        }
        super.visitEnd();
    }

    protected boolean mayNeedSerialVersionUid(int access) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long computeSVUID() throws IOException, NoSuchAlgorithmException {
        ByteArrayOutputStream bos = null;
        FilterOutputStream dos = null;
        long svuid = 0L;
        try {
            bos = new ByteArrayOutputStream();
            dos = new DataOutputStream(bos);
            ((DataOutputStream)dos).writeUTF(this.m_className.replace('/', '.'));
            int classMods = this.m_access & 0x611;
            ((DataOutputStream)dos).writeInt(classMods);
            Arrays.sort(this.m_interfaces);
            for (int i = 0; i < this.m_interfaces.length; ++i) {
                String ifs = this.m_interfaces[i].replace('/', '.');
                ((DataOutputStream)dos).writeUTF(ifs);
            }
            this.writeItems(this.m_svuidFields, (DataOutputStream)dos, false);
            if (this.m_hasStaticInitializer) {
                ((DataOutputStream)dos).writeUTF(CLINIT);
                ((DataOutputStream)dos).writeInt(8);
                ((DataOutputStream)dos).writeUTF("()V");
            }
            this.writeItems(this.m_svuidConstructors, (DataOutputStream)dos, true);
            this.writeItems(this.m_svuidMethods, (DataOutputStream)dos, true);
            ((DataOutputStream)dos).flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bos.toByteArray());
            for (int i = Math.min(hashBytes.length, 8) - 1; i >= 0; --i) {
                svuid = svuid << 8 | (long)(hashBytes[i] & 0xFF);
            }
        }
        finally {
            if (dos != null) {
                dos.close();
            }
        }
        return svuid;
    }

    protected void writeItems(Collection itemCollection, DataOutputStream dos, boolean dotted) throws IOException {
        int size = itemCollection.size();
        Object[] items = new Item[size];
        items = itemCollection.toArray(items);
        Arrays.sort(items);
        for (int i = 0; i < size; ++i) {
            ((Item)items[i]).write(dos, dotted);
        }
    }

    public static class Add
    extends ClassAdapter {
        private ContextImpl m_ctx;
        private ClassInfo m_classInfo;

        public Add(ClassVisitor classVisitor, Context ctx, ClassInfo classInfo) {
            super(classVisitor);
            this.m_ctx = (ContextImpl)ctx;
            this.m_classInfo = classInfo;
        }

        public void visitEnd() {
            if (ClassInfoHelper.implementsInterface(this.m_classInfo, "java.io.Serializable")) {
                ClassReader cr = new ClassReader(this.m_ctx.getInitialBytecode());
                ClassWriter cw = AsmHelper.newClassWriter(true);
                SerialVersionUidVisitor sv = new SerialVersionUidVisitor(cw);
                cr.accept(sv, true);
                if (sv.m_computeSVUID && !sv.m_hadSVUID) {
                    this.cv.visitField(24, SerialVersionUidVisitor.SVUID_NAME, "J", new Long(sv.m_SVUID), null);
                }
            }
            super.visitEnd();
        }
    }

    private static class MethodItem
    extends Item {
        MethodItem(String name, int access, String desc) {
            super(name, access, desc);
        }

        protected int filterAccess(int access) {
            return access & 0xD3F;
        }
    }

    private static class FieldItem
    extends Item {
        FieldItem(String name, int access, String desc) {
            super(name, access, desc);
        }

        protected int filterAccess(int access) {
            return access & 0xDF;
        }
    }

    private static abstract class Item
    implements Comparable {
        private String m_name;
        private int m_access;
        private String m_desc;

        Item(String name, int access, String desc) {
            this.m_name = name;
            this.m_access = access;
            this.m_desc = desc;
        }

        protected abstract int filterAccess(int var1);

        public int compareTo(Object o) {
            Item other = (Item)o;
            int retVal = this.m_name.compareTo(other.m_name);
            if (retVal == 0) {
                retVal = this.m_desc.compareTo(other.m_desc);
            }
            return retVal;
        }

        void write(DataOutputStream dos, boolean dotted) throws IOException {
            dos.writeUTF(this.m_name);
            dos.writeInt(this.filterAccess(this.m_access));
            if (dotted) {
                dos.writeUTF(this.m_desc.replace('/', '.'));
            } else {
                dos.writeUTF(this.m_desc);
            }
        }
    }
}

