/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.MemberInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.TransformationUtil;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;

public class HandlerVisitor
extends ClassAdapter
implements TransformationConstants {
    private final ContextImpl m_ctx;
    private final List m_catchLabels;
    private int m_labelIndex = -1;
    private Label m_lastLabelForLineNumber = EmittedJoinPoint.NO_LINE_NUMBER;

    public HandlerVisitor(ClassVisitor cv, Context ctx, List catchLabels) {
        super(cv);
        this.m_ctx = (ContextImpl)ctx;
        this.m_catchLabels = catchLabels;
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        if (name.startsWith("aw$")) {
            return super.visitMethod(access, name, desc, exceptions, attrs);
        }
        CodeVisitor mv = this.cv.visitMethod(access, name, desc, exceptions, attrs);
        return mv == null ? null : new CatchClauseCodeAdapter(mv);
    }

    static boolean handlerFilter(Set definitions, ExpressionContext ctx) {
        Iterator it = definitions.iterator();
        while (it.hasNext()) {
            if (!((SystemDefinition)it.next()).hasPointcut(ctx)) continue;
            return false;
        }
        return true;
    }

    private static class CatchLabelStruct {
        int labelIndexInWholeClass = -1;
        ClassInfo exception = null;
        ClassInfo caller = null;
        MemberInfo callerMember = null;

        private CatchLabelStruct(int indexInClass, ClassInfo exception, ClassInfo caller, MemberInfo callerMember) {
            this.labelIndexInWholeClass = indexInClass;
            this.exception = exception;
            this.caller = caller;
            this.callerMember = callerMember;
        }
    }

    public class CatchClauseCodeAdapter
    extends CodeAdapter {
        public CatchClauseCodeAdapter(CodeVisitor ca) {
            super(ca);
        }

        public void visitLabel(Label label) {
            HandlerVisitor.this.m_lastLabelForLineNumber = label;
            super.visitLabel(label);
            int index = ++HandlerVisitor.this.m_labelIndex;
            CatchLabelStruct catchLabel = null;
            Iterator iterator = HandlerVisitor.this.m_catchLabels.iterator();
            while (iterator.hasNext()) {
                CatchLabelStruct aCatchLabel = (CatchLabelStruct)iterator.next();
                if (aCatchLabel.labelIndexInWholeClass != index) continue;
                catchLabel = aCatchLabel;
                break;
            }
            if (catchLabel == null) {
                return;
            }
            HandlerVisitor.this.m_ctx.markAsAdvised();
            String callerTypeName = catchLabel.caller.getName().replace('.', '/');
            String exceptionTypeDesc = catchLabel.exception.getSignature();
            String exceptionTypeName = Type.getType(exceptionTypeDesc).getInternalName();
            int joinPointHash = AsmHelper.calculateClassHash(exceptionTypeDesc);
            String joinPointClassName = TransformationUtil.getJoinPointClassName(callerTypeName, catchLabel.callerMember.getName(), catchLabel.callerMember.getSignature(), exceptionTypeName, 7, joinPointHash);
            this.cv.visitInsn(89);
            if (Modifier.isStatic(catchLabel.callerMember.getModifiers())) {
                this.cv.visitInsn(1);
            } else {
                this.cv.visitVarInsn(25, 0);
            }
            this.cv.visitMethodInsn(184, joinPointClassName, "invoke", TransformationUtil.getInvokeSignatureForHandlerJoinPoints(callerTypeName, exceptionTypeName));
            HandlerVisitor.this.m_ctx.addEmittedJoinPoint(new EmittedJoinPoint(7, callerTypeName, catchLabel.callerMember.getName(), catchLabel.callerMember.getSignature(), catchLabel.callerMember.getModifiers(), exceptionTypeName, "", exceptionTypeDesc, 0, joinPointHash, joinPointClassName, HandlerVisitor.this.m_lastLabelForLineNumber));
        }
    }

    public static class LookaheadCatchLabelsClassAdapter
    extends ClassAdapter {
        List m_catchLabels = new ArrayList();
        private final Map m_labelIndexes = new HashMap();
        private int m_labelIndex = -1;
        private final ContextImpl m_ctx;
        private final ClassLoader m_loader;
        private final ClassInfo m_callerClassInfo;

        public LookaheadCatchLabelsClassAdapter(ClassVisitor cv, ClassLoader loader, ClassInfo callerClassInfo, Context ctx, List catchLabels) {
            super(cv);
            this.m_catchLabels = catchLabels;
            this.m_loader = loader;
            this.m_callerClassInfo = callerClassInfo;
            this.m_ctx = (ContextImpl)ctx;
        }

        public CodeVisitor visitMethod(int access, String callerMethodName, String callerMethodDesc, String[] exceptions, Attribute attrs) {
            MemberInfo callerMemberInfo;
            if (callerMethodName.startsWith("aw$")) {
                return super.visitMethod(access, callerMethodName, callerMethodDesc, exceptions, attrs);
            }
            CodeVisitor mv = this.cv.visitMethod(access, callerMethodName, callerMethodDesc, exceptions, attrs);
            if (mv == null) {
                return mv;
            }
            if ("<clinit>".equals(callerMethodName)) {
                callerMemberInfo = this.m_callerClassInfo.staticInitializer();
            } else if ("<init>".equals(callerMethodName)) {
                int hash = AsmHelper.calculateConstructorHash(callerMethodDesc);
                callerMemberInfo = this.m_callerClassInfo.getConstructor(hash);
            } else {
                int hash = AsmHelper.calculateMethodHash(callerMethodName, callerMethodDesc);
                callerMemberInfo = this.m_callerClassInfo.getMethod(hash);
            }
            if (callerMemberInfo == null) {
                System.err.println("AW::WARNING metadata structure could not be build for method [" + this.m_callerClassInfo.getName().replace('/', '.') + '.' + callerMethodName + ':' + callerMethodDesc + ']');
                return mv;
            }
            return new CodeAdapter(this, mv, callerMemberInfo){
                private final /* synthetic */ MemberInfo val$callerMemberInfo;
                private final /* synthetic */ LookaheadCatchLabelsClassAdapter this$0;
                {
                    this.this$0 = this$0;
                    this.val$callerMemberInfo = val$callerMemberInfo;
                }

                public void visitLabel(Label label) {
                    LookaheadCatchLabelsClassAdapter.access$100(this.this$0).put(label, new Integer(LookaheadCatchLabelsClassAdapter.access$004(this.this$0)));
                    super.visitLabel(label);
                }

                public void visitTryCatchBlock(Label startLabel, Label endLabel, Label handlerLabel, String exceptionTypeName) {
                    Integer index;
                    if (exceptionTypeName == null) {
                        super.visitTryCatchBlock(startLabel, endLabel, handlerLabel, exceptionTypeName);
                        return;
                    }
                    ClassInfo exceptionClassInfo = AsmClassInfo.getClassInfo(exceptionTypeName, LookaheadCatchLabelsClassAdapter.access$200(this.this$0));
                    ExpressionContext ctx = new ExpressionContext(PointcutType.HANDLER, exceptionClassInfo, this.val$callerMemberInfo);
                    if (!HandlerVisitor.handlerFilter(LookaheadCatchLabelsClassAdapter.access$300(this.this$0).getDefinitions(), ctx) && (index = (Integer)LookaheadCatchLabelsClassAdapter.access$100(this.this$0).get(handlerLabel)) != null) {
                        this.this$0.m_catchLabels.add(new CatchLabelStruct(index, exceptionClassInfo, LookaheadCatchLabelsClassAdapter.access$400(this.this$0), this.val$callerMemberInfo));
                    }
                    super.visitTryCatchBlock(startLabel, endLabel, handlerLabel, exceptionTypeName);
                }
            };
        }

        static /* synthetic */ int access$004(LookaheadCatchLabelsClassAdapter x0) {
            return ++x0.m_labelIndex;
        }

        static /* synthetic */ Map access$100(LookaheadCatchLabelsClassAdapter x0) {
            return x0.m_labelIndexes;
        }

        static /* synthetic */ ClassLoader access$200(LookaheadCatchLabelsClassAdapter x0) {
            return x0.m_loader;
        }

        static /* synthetic */ ContextImpl access$300(LookaheadCatchLabelsClassAdapter x0) {
            return x0.m_ctx;
        }

        static /* synthetic */ ClassInfo access$400(LookaheadCatchLabelsClassAdapter x0) {
            return x0.m_callerClassInfo;
        }
    }
}

