/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.aspectwerkz.definition.InterfaceIntroductionDefinition;
import org.codehaus.aspectwerkz.definition.MixinDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;

public class AddInterfaceVisitor
extends ClassAdapter
implements TransformationConstants {
    private static final String ADVISABLE_MIXIN_IMPL_NAME = "org.codehaus.aspectwerkz.intercept.AdvisableImpl";
    private final ContextImpl m_ctx;
    private final ClassInfo m_classInfo;

    public AddInterfaceVisitor(ClassVisitor cv, ClassInfo classInfo, Context ctx) {
        super(cv);
        this.m_classInfo = classInfo;
        this.m_ctx = (ContextImpl)ctx;
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        ExpressionContext ctx = new ExpressionContext(PointcutType.WITHIN, this.m_classInfo, this.m_classInfo);
        if (AddInterfaceVisitor.classFilter(this.m_classInfo, ctx, this.m_ctx.getDefinitions())) {
            super.visit(version, access, name, superName, interfaces, sourceFile);
            return;
        }
        HashSet<String> interfacesToAdd = new HashSet<String>();
        for (int i = 0; i < interfaces.length; ++i) {
            interfacesToAdd.add(interfaces[i].replace('/', '.'));
        }
        Set systemDefinitions = this.m_ctx.getDefinitions();
        Iterator it = systemDefinitions.iterator();
        while (it.hasNext()) {
            SystemDefinition systemDefinition = (SystemDefinition)it.next();
            List interfaceIntroDefs = systemDefinition.getInterfaceIntroductionDefinitions(ctx);
            Iterator it2 = interfaceIntroDefs.iterator();
            while (it2.hasNext()) {
                InterfaceIntroductionDefinition interfaceIntroDef = (InterfaceIntroductionDefinition)it2.next();
                interfacesToAdd.addAll(interfaceIntroDef.getInterfaceClassNames());
            }
            List mixinDefinitions = systemDefinition.getMixinDefinitions(ctx);
            Iterator it22 = mixinDefinitions.iterator();
            while (it22.hasNext()) {
                MixinDefinition mixinDef = (MixinDefinition)it22.next();
                if (ADVISABLE_MIXIN_IMPL_NAME.equals(mixinDef.getMixinImpl().getName())) {
                    this.m_ctx.markMadeAdvisable();
                }
                List interfaceList = mixinDef.getInterfaceClassNames();
                Iterator it3 = interfaceList.iterator();
                while (it3.hasNext()) {
                    interfacesToAdd.add((String)it3.next());
                }
            }
        }
        if (ClassInfoHelper.hasMethodClash(interfacesToAdd, this.m_ctx.getLoader())) {
            super.visit(version, access, name, superName, interfaces, sourceFile);
            return;
        }
        int i = 0;
        String[] newInterfaceArray = new String[interfacesToAdd.size()];
        Iterator it2 = interfacesToAdd.iterator();
        while (it2.hasNext()) {
            newInterfaceArray[i++] = (String)it2.next();
        }
        for (int j = 0; j < newInterfaceArray.length; ++j) {
            newInterfaceArray[j] = newInterfaceArray[j].replace('.', '/');
        }
        super.visit(version, access, name, superName, newInterfaceArray, sourceFile);
        this.m_ctx.markAsAdvised();
    }

    public static boolean classFilter(ClassInfo classInfo, ExpressionContext ctx, Set definitions) {
        Iterator it = definitions.iterator();
        while (it.hasNext()) {
            SystemDefinition systemDef = (SystemDefinition)it.next();
            if (classInfo.isInterface()) {
                return true;
            }
            String className = classInfo.getName().replace('/', '.');
            if (systemDef.inExcludePackage(className)) {
                return true;
            }
            if (!systemDef.inIncludePackage(className)) {
                return true;
            }
            if (!systemDef.hasMixin(ctx) && !systemDef.hasIntroducedInterface(ctx)) continue;
            return false;
        }
        return true;
    }
}

