/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform;

import org.codehaus.aspectwerkz.expression.SubtypePatternType;
import org.codehaus.aspectwerkz.expression.regexp.Pattern;
import org.codehaus.aspectwerkz.expression.regexp.TypePattern;
import org.codehaus.aspectwerkz.hook.ClassPreProcessor;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.WeavingStrategy;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.transform.inlining.InliningWeavingStrategy;
import org.codehaus.aspectwerkz.util.Util;

public class AspectWerkzPreProcessor
implements ClassPreProcessor {
    private static final String AW_TRANSFORM_FILTER = "aspectwerkz.transform.filter";
    private static final String AW_TRANSFORM_VERBOSE = "aspectwerkz.transform.verbose";
    private static final String AW_TRANSFORM_DETAILS = "aspectwerkz.transform.details";
    private static final String AW_TRANSFORM_GENJP = "aspectwerkz.transform.genjp";
    private static final String AW_TRANSFORM_DUMP = "aspectwerkz.transform.dump";
    private static final TypePattern DUMP_PATTERN;
    private static final boolean NOFILTER;
    private static final boolean DUMP_BEFORE;
    private static final boolean DUMP_AFTER;
    public static final boolean VERBOSE;
    public static final boolean DETAILS;
    public static final boolean GENJP;
    private boolean m_initialized = false;
    private WeavingStrategy m_weavingStrategy;

    public void initialize() {
        this.m_weavingStrategy = new InliningWeavingStrategy();
        this.m_initialized = true;
    }

    public byte[] preProcess(String name, byte[] bytecode, ClassLoader loader) {
        String className;
        if (!(NOFILTER || loader != null && loader.getParent() != null)) {
            return bytecode;
        }
        String string = className = name != null ? name.replace('/', '.') : null;
        if (AspectWerkzPreProcessor.filter(className) || !this.m_initialized) {
            return bytecode;
        }
        if (VERBOSE) {
            AspectWerkzPreProcessor.log(Util.classLoaderToString(loader) + ':' + className + '[' + Thread.currentThread().getName() + ']');
        }
        try {
            Context context = this._preProcess(className, bytecode, loader);
            return context.getCurrentBytecode();
        }
        catch (Exception e) {
            AspectWerkzPreProcessor.log("failed " + className);
            e.printStackTrace();
            return bytecode;
        }
    }

    public Context _preProcess(String className, byte[] bytecode, ClassLoader loader) {
        Context context = this.m_weavingStrategy.newContext(className, bytecode, loader);
        AspectWerkzPreProcessor.dumpBefore(className, context);
        this.m_weavingStrategy.transform(className, context);
        AspectWerkzPreProcessor.dumpAfter(className, context);
        return context;
    }

    public Output preProcessWithOutput(String name, byte[] bytecode, ClassLoader loader) {
        String className = name.replace('/', '.');
        if (name.endsWith("___AW_JoinPoint")) {
            Output output = new Output();
            output.bytecode = bytecode;
            output.emittedJoinPoints = null;
            return output;
        }
        Context context = this._preProcess(className, bytecode, loader);
        Output output = new Output();
        output.bytecode = context.getCurrentBytecode();
        output.emittedJoinPoints = ((ContextImpl)context).getEmittedJoinPoints().toArray(new EmittedJoinPoint[0]);
        for (int i = 0; i < output.emittedJoinPoints.length; ++i) {
            EmittedJoinPoint emittedJoinPoint = output.emittedJoinPoints[i];
            emittedJoinPoint.resolveLineNumber(context);
        }
        return output;
    }

    public static void log(String msg) {
        if (VERBOSE) {
            System.out.println(msg);
        }
    }

    private static boolean filter(String klass) {
        return klass == null || klass.endsWith("___AW_JoinPoint") || klass.startsWith("org.codehaus.aspectwerkz.") || klass.startsWith("org.objectweb.asm.") || klass.startsWith("com.karneim.") || klass.startsWith("com.bluecast.") || klass.startsWith("gnu.trove.") || klass.startsWith("org.dom4j.") || klass.startsWith("org.xml.sax.") || klass.startsWith("javax.xml.parsers.") || klass.startsWith("sun.reflect.Generated") || klass.startsWith("EDU.oswego.cs.dl.util.concurrent");
    }

    public static void dumpBefore(String className, Context context) {
        if (DUMP_BEFORE && DUMP_PATTERN.matches(className)) {
            context.dump("_dump/before/");
        }
    }

    public static void dumpAfter(String className, Context context) {
        if (DUMP_AFTER && DUMP_PATTERN.matches(className)) {
            context.dump("_dump/" + (DUMP_BEFORE ? "after/" : ""));
        }
    }

    static {
        String verbose = System.getProperty(AW_TRANSFORM_VERBOSE, null);
        VERBOSE = "yes".equalsIgnoreCase(verbose) || "true".equalsIgnoreCase(verbose);
        String details = System.getProperty(AW_TRANSFORM_DETAILS, null);
        DETAILS = "yes".equalsIgnoreCase(details) || "true".equalsIgnoreCase(details);
        String genjp = System.getProperty(AW_TRANSFORM_GENJP, null);
        GENJP = "yes".equalsIgnoreCase(genjp) || "true".equalsIgnoreCase(genjp);
        String filter = System.getProperty(AW_TRANSFORM_FILTER, null);
        NOFILTER = "no".equalsIgnoreCase(filter) || "false".equalsIgnoreCase(filter);
        String dumpPattern = System.getProperty(AW_TRANSFORM_DUMP, null);
        if (dumpPattern == null) {
            DUMP_BEFORE = false;
            DUMP_AFTER = false;
            DUMP_PATTERN = null;
        } else {
            dumpPattern = dumpPattern.trim();
            DUMP_AFTER = true;
            DUMP_BEFORE = dumpPattern.indexOf(",before") > 0;
            DUMP_PATTERN = DUMP_BEFORE ? Pattern.compileTypePattern(dumpPattern.substring(0, dumpPattern.indexOf(44)), SubtypePatternType.NOT_HIERARCHICAL) : Pattern.compileTypePattern(dumpPattern, SubtypePatternType.NOT_HIERARCHICAL);
        }
    }

    public static class Output {
        public byte[] bytecode;
        public EmittedJoinPoint[] emittedJoinPoints;
    }
}

