/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.reflect.impl.java;

import java.lang.reflect.Constructor;
import java.util.List;
import org.codehaus.aspectwerkz.annotation.Annotations;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ConstructorInfo;
import org.codehaus.aspectwerkz.reflect.ReflectHelper;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfoRepository;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaMemberInfo;

public class JavaConstructorInfo
extends JavaMemberInfo
implements ConstructorInfo {
    private ClassInfo[] m_parameterTypes = null;
    private ClassInfo[] m_exceptionTypes = null;
    private String m_signature;

    JavaConstructorInfo(Constructor constructor, JavaClassInfo declaringType) {
        super(constructor, declaringType);
        this.m_signature = ReflectHelper.getConstructorSignature(constructor);
    }

    public static ConstructorInfo getConstructorInfo(Constructor constructor) {
        Class declaringClass = constructor.getDeclaringClass();
        JavaClassInfoRepository repository = JavaClassInfoRepository.getRepository(declaringClass.getClassLoader());
        ClassInfo classInfo = repository.getClassInfo(declaringClass.getName());
        if (classInfo == null) {
            classInfo = JavaClassInfo.getClassInfo(declaringClass);
        }
        return classInfo.getConstructor(ReflectHelper.calculateHash(constructor));
    }

    public String getSignature() {
        return this.m_signature;
    }

    public List getAnnotations() {
        if (this.m_annotations == null) {
            this.m_annotations = Annotations.getAnnotationInfos((Constructor)this.m_member);
        }
        return this.m_annotations;
    }

    public ClassInfo[] getParameterTypes() {
        if (this.m_parameterTypes == null) {
            Class<?>[] parameterTypes = ((Constructor)this.m_member).getParameterTypes();
            this.m_parameterTypes = new ClassInfo[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                ClassInfo metaData;
                Class<?> parameterType = parameterTypes[i];
                if (this.m_classInfoRepository.hasClassInfo(parameterType.getName())) {
                    metaData = this.m_classInfoRepository.getClassInfo(parameterType.getName());
                } else {
                    metaData = JavaClassInfo.getClassInfo(parameterType);
                    this.m_classInfoRepository.addClassInfo(metaData);
                }
                this.m_parameterTypes[i] = metaData;
            }
        }
        return this.m_parameterTypes;
    }

    public ClassInfo[] getExceptionTypes() {
        if (this.m_exceptionTypes == null) {
            Class<?>[] exceptionTypes = ((Constructor)this.m_member).getExceptionTypes();
            this.m_exceptionTypes = new ClassInfo[exceptionTypes.length];
            for (int i = 0; i < exceptionTypes.length; ++i) {
                ClassInfo metaData;
                Class<?> exceptionType = exceptionTypes[i];
                if (this.m_classInfoRepository.hasClassInfo(exceptionType.getName())) {
                    metaData = this.m_classInfoRepository.getClassInfo(exceptionType.getName());
                } else {
                    metaData = JavaClassInfo.getClassInfo(exceptionType);
                    this.m_classInfoRepository.addClassInfo(metaData);
                }
                this.m_exceptionTypes[i] = metaData;
            }
        }
        return this.m_exceptionTypes;
    }

    public boolean equals(Object o) {
        ClassInfo[] parameterTypes2;
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstructorInfo)) {
            return false;
        }
        ConstructorInfo constructorInfo = (ConstructorInfo)o;
        if (!this.m_declaringType.getName().equals(constructorInfo.getDeclaringType().getName())) {
            return false;
        }
        if (!this.m_member.getName().equals(constructorInfo.getName())) {
            return false;
        }
        Class<?>[] parameterTypes1 = ((Constructor)this.m_member).getParameterTypes();
        if (parameterTypes1.length != (parameterTypes2 = constructorInfo.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < parameterTypes1.length; ++i) {
            if (parameterTypes1[i].getName().equals(parameterTypes2[i].getName())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 29;
        result = 29 * result + this.m_declaringType.getName().hashCode();
        result = 29 * result + this.m_member.getName().hashCode();
        Class<?>[] parameterTypes = ((Constructor)this.m_member).getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            result = 29 * result + parameterTypes[i].getName().hashCode();
        }
        return result;
    }
}

