/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.joinpoint.management;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.codehaus.aspectwerkz.aspect.AdviceInfo;
import org.codehaus.aspectwerkz.aspect.AdviceType;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinitionContainer;
import org.codehaus.aspectwerkz.expression.ArgsIndexVisitor;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.joinpoint.management.AdviceInfoContainer;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.reflect.MemberInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.ReflectionInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfo;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.AspectModelManager;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.transform.inlining.compiler.CompilationInfo;
import org.codehaus.aspectwerkz.transform.inlining.compiler.JoinPointFactory;
import org.codehaus.aspectwerkz.transform.inlining.spi.AspectModel;
import org.codehaus.aspectwerkz.util.ContextClassLoader;
import org.codehaus.aspectwerkz.util.Strings;

public class JoinPointManager {
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$definition$Virtual;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$joinpoint$JoinPoint;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$joinpoint$StaticJoinPoint;

    public static void loadJoinPoint(int joinPointType, Class callerClass, String callerMethodName, String callerMethodDesc, int callerMethodModifiers, String calleeClassName, String calleeMemberName, String calleeMemberDesc, int calleeMemberModifiers, int joinPointHash, String joinPointClassName) {
        Class<?> calleeClass = null;
        try {
            if (calleeClassName != null) {
                calleeClass = Class.forName(calleeClassName.replace('/', '.'), false, callerClass.getClassLoader());
            }
        }
        catch (ClassNotFoundException calleeNotFound) {
            throw new RuntimeException("callee class [" + calleeClassName + "] can not be found in class loader [" + callerClass.getClassLoader() + "]");
        }
        ClassLoader classLoader = callerClass.getClassLoader();
        boolean generateJoinPoint = false;
        try {
            if (calleeClass == null) {
                throw new RuntimeException("callee class [" + calleeClassName + "] is NULL");
            }
            ContextClassLoader.forName(classLoader, joinPointClassName.replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            generateJoinPoint = true;
        }
        if (!generateJoinPoint) {
            return;
        }
        CompiledJoinPoint compiledJoinPoint = JoinPointManager.compileJoinPoint(joinPointType, callerClass, callerMethodName, callerMethodDesc, callerMethodModifiers, calleeClassName, calleeMemberName, calleeMemberDesc, calleeMemberModifiers, joinPointHash, joinPointClassName, calleeClass, classLoader);
        Class jpClass = JoinPointFactory.attachToClassLoader(joinPointClassName, classLoader, compiledJoinPoint.bytecode);
        JoinPointFactory.addCompilationInfo(jpClass, compiledJoinPoint.compilationInfo);
    }

    /*
     * WARNING - void declaration
     */
    public static CompiledJoinPoint compileJoinPoint(int joinPointType, Class callerClass, String callerMethodName, String callerMethodDesc, int callerMethodModifiers, String calleeClassName, String calleeMemberName, String calleeMemberDesc, int calleeMemberModifiers, int joinPointHash, String joinPointClassName, Class calleeClass, ClassLoader loader) {
        void var14_14;
        void var15_15;
        ClassInfo calleeClassInfo = JavaClassInfo.getClassInfo(calleeClass);
        switch (joinPointType) {
            case 8: {
                ReflectionInfo reflectionInfo = calleeClassInfo.staticInitializer();
                PointcutType pointcutType = PointcutType.STATIC_INITIALIZATION;
                break;
            }
            case 1: {
                ReflectionInfo reflectionInfo = calleeClassInfo.getMethod(joinPointHash);
                PointcutType pointcutType = PointcutType.EXECUTION;
                break;
            }
            case 2: {
                ReflectionInfo reflectionInfo = calleeClassInfo.getMethod(joinPointHash);
                PointcutType pointcutType = PointcutType.CALL;
                break;
            }
            case 6: {
                ReflectionInfo reflectionInfo = calleeClassInfo.getField(joinPointHash);
                PointcutType pointcutType = PointcutType.GET;
                break;
            }
            case 5: {
                ReflectionInfo reflectionInfo = calleeClassInfo.getField(joinPointHash);
                PointcutType pointcutType = PointcutType.SET;
                break;
            }
            case 3: {
                ReflectionInfo reflectionInfo = calleeClassInfo.getConstructor(joinPointHash);
                PointcutType pointcutType = PointcutType.EXECUTION;
                break;
            }
            case 4: {
                ReflectionInfo reflectionInfo = calleeClassInfo.getConstructor(joinPointHash);
                PointcutType pointcutType = PointcutType.CALL;
                break;
            }
            case 7: {
                ReflectionInfo reflectionInfo = calleeClassInfo;
                PointcutType pointcutType = PointcutType.HANDLER;
                break;
            }
            default: {
                throw new RuntimeException("Joinpoint type not supported: " + joinPointType);
            }
        }
        ClassInfo callerClassInfo = JavaClassInfo.getClassInfo(callerClass);
        MemberInfo withinInfo = "<clinit>".equals(callerMethodName) ? callerClassInfo.staticInitializer() : ("<init>".equals(callerMethodName) ? callerClassInfo.getConstructor(AsmHelper.calculateConstructorHash(callerMethodDesc)) : callerClassInfo.getMethod(AsmHelper.calculateMethodHash(callerMethodName, callerMethodDesc)));
        ExpressionContext ctx = new ExpressionContext((PointcutType)var15_15, (ReflectionInfo)var14_14, withinInfo);
        AdviceInfoContainer adviceContainer = JoinPointManager.getAdviceInfoContainerForJoinPoint(ctx, loader);
        EmittedJoinPoint emittedJoinPoint = new EmittedJoinPoint(joinPointType, callerClass.getName(), callerMethodName, callerMethodDesc, callerMethodModifiers, calleeClass.getName(), calleeMemberName, calleeMemberDesc, calleeMemberModifiers, joinPointHash, joinPointClassName, EmittedJoinPoint.NO_LINE_NUMBER);
        CompilationInfo.Model compilationModel = new CompilationInfo.Model(emittedJoinPoint, adviceContainer, callerClassInfo);
        return new CompiledJoinPoint(compilationModel);
    }

    public static AdviceInfoContainer getAdviceInfoContainerForJoinPoint(ExpressionContext expressionContext, ClassLoader loader) {
        ArrayList<AdviceInfo> beforeAdvices = new ArrayList<AdviceInfo>();
        ArrayList<AdviceInfo> aroundAdvices = new ArrayList<AdviceInfo>();
        ArrayList<AdviceInfo> afterFinallyAdvices = new ArrayList<AdviceInfo>();
        ArrayList<AdviceInfo> afterReturningAdvices = new ArrayList<AdviceInfo>();
        ArrayList<AdviceInfo> afterThrowingAdvices = new ArrayList<AdviceInfo>();
        Set systemDefinitions = SystemDefinitionContainer.getDefinitionsFor(loader);
        Iterator iterator = systemDefinitions.iterator();
        while (iterator.hasNext()) {
            SystemDefinition systemDefinition = (SystemDefinition)iterator.next();
            Collection aspects = systemDefinition.getAspectDefinitions();
            Iterator iterator1 = aspects.iterator();
            while (iterator1.hasNext()) {
                AspectDefinition aspectDefinition = (AspectDefinition)iterator1.next();
                if (aspectDefinition.getName().equals((class$org$codehaus$aspectwerkz$definition$Virtual == null ? JoinPointManager.class$("org.codehaus.aspectwerkz.definition.Virtual") : class$org$codehaus$aspectwerkz$definition$Virtual).getName())) continue;
                Iterator iterator2 = aspectDefinition.getAdviceDefinitions().iterator();
                while (iterator2.hasNext()) {
                    AdviceDefinition adviceDefinition = (AdviceDefinition)iterator2.next();
                    ExpressionInfo expressionInfo = adviceDefinition.getExpressionInfo();
                    if (expressionInfo == null || !expressionInfo.getExpression().match(expressionContext)) continue;
                    expressionContext.resetRuntimeState();
                    ArgsIndexVisitor.updateContextForRuntimeInformation(expressionInfo, expressionContext, loader);
                    MethodInfo adviceMethodInfo = adviceDefinition.getMethodInfo();
                    AdviceInfo adviceInfo = new AdviceInfo(aspectDefinition.getQualifiedName(), aspectDefinition.getClassName(), aspectDefinition.getDeploymentModel(), adviceMethodInfo.getName(), AsmHelper.getMethodDescriptor(adviceMethodInfo), AsmHelper.getArgumentTypes(adviceMethodInfo), adviceDefinition.getType(), adviceDefinition.getSpecialArgumentType(), adviceDefinition.getName(), expressionContext.m_targetWithRuntimeCheck, expressionInfo, expressionContext, adviceDefinition);
                    JoinPointManager.setMethodArgumentIndexes(expressionInfo, expressionContext, adviceInfo, loader);
                    if (AdviceType.BEFORE.equals(adviceDefinition.getType())) {
                        beforeAdvices.add(adviceInfo);
                        continue;
                    }
                    if (AdviceType.AROUND.equals(adviceDefinition.getType())) {
                        aroundAdvices.add(adviceInfo);
                        continue;
                    }
                    if (AdviceType.AFTER_FINALLY.equals(adviceDefinition.getType())) {
                        afterFinallyAdvices.add(adviceInfo);
                        continue;
                    }
                    if (AdviceType.AFTER_RETURNING.equals(adviceDefinition.getType())) {
                        afterReturningAdvices.add(adviceInfo);
                        continue;
                    }
                    if (AdviceType.AFTER_THROWING.equals(adviceDefinition.getType())) {
                        afterThrowingAdvices.add(adviceInfo);
                        continue;
                    }
                    if (!AdviceType.AFTER.equals(adviceDefinition.getType())) continue;
                    afterFinallyAdvices.add(adviceInfo);
                }
            }
        }
        AdviceInfoContainer adviceInfoContainer = new AdviceInfoContainer(aroundAdvices, beforeAdvices, afterFinallyAdvices, afterReturningAdvices, afterThrowingAdvices);
        return adviceInfoContainer;
    }

    public static String[] getParameterNames(String adviceName) {
        int paren = adviceName.indexOf(40);
        ArrayList<String> paramNames = new ArrayList<String>();
        if (paren > 0) {
            String params = adviceName.substring(paren + 1, adviceName.lastIndexOf(41)).trim();
            String[] javaParameters = Strings.splitString(params, ",");
            for (int i = 0; i < javaParameters.length; ++i) {
                String javaParameter = Strings.replaceSubString(javaParameters[i], "  ", " ").trim();
                String[] paramInfo = Strings.splitString(javaParameter, " ");
                if (paramInfo.length == 2) {
                    paramNames.add(paramInfo[1]);
                    continue;
                }
                paramNames.add("anonymous_" + i);
            }
        }
        String[] paramNamesArray = new String[paramNames.size()];
        int index = 0;
        Iterator it = paramNames.iterator();
        while (it.hasNext()) {
            paramNamesArray[index] = (String)it.next();
            ++index;
        }
        return paramNamesArray;
    }

    private static void setMethodArgumentIndexes(ExpressionInfo expressionInfo, ExpressionContext ctx, AdviceInfo adviceInfo, ClassLoader loader) {
        String[] adviceArgNames = JoinPointManager.getParameterNames(adviceInfo.getName());
        int[] adviceToTargetArgs = new int[adviceInfo.getMethodParameterTypes().length];
        for (int k = 0; k < adviceArgNames.length; ++k) {
            String adviceArgName = adviceArgNames[k];
            int exprArgIndex = expressionInfo.getArgumentIndex(adviceArgName);
            if (exprArgIndex >= 0 && ctx.m_exprIndexToTargetIndex.containsKey(adviceArgName)) {
                adviceToTargetArgs[k] = ctx.m_exprIndexToTargetIndex.get(adviceArgName);
                continue;
            }
            Type type = adviceInfo.getMethodParameterTypes()[k];
            if (JoinPointManager.isJoinPoint(type)) {
                adviceToTargetArgs[k] = -1;
                continue;
            }
            if (JoinPointManager.isStaticJoinPoint(type)) {
                adviceToTargetArgs[k] = -2;
                continue;
            }
            if (JoinPointManager.isTarget(adviceArgName, ctx)) {
                adviceToTargetArgs[k] = -3;
                continue;
            }
            if (JoinPointManager.isThis(adviceArgName, ctx)) {
                adviceToTargetArgs[k] = -4;
                continue;
            }
            if (JoinPointManager.isSpecialArgument(adviceArgName, expressionInfo)) {
                adviceToTargetArgs[k] = -6;
                continue;
            }
            if (JoinPointManager.isCustomJointPoint(type, loader)) {
                adviceToTargetArgs[k] = -7;
                continue;
            }
            throw new Error("Unbound advice parameter at index " + k + " in " + adviceInfo.getMethodName() + adviceInfo.getMethodSignature() + " named " + adviceArgName);
        }
        if (adviceArgNames.length == 0) {
            AspectDefinition aspectDef = adviceInfo.getAdviceDefinition().getAspectDefinition();
            Type[] adviceArgTypes = adviceInfo.getMethodParameterTypes();
            for (int i = 0; i < adviceArgTypes.length; ++i) {
                if (aspectDef.isAspectWerkzAspect()) {
                    if (JoinPointManager.isJoinPoint(adviceArgTypes[i])) {
                        adviceToTargetArgs[i] = -1;
                        continue;
                    }
                    if (JoinPointManager.isStaticJoinPoint(adviceArgTypes[i])) {
                        adviceToTargetArgs[i] = -2;
                        continue;
                    }
                    throw new Error("Unbound unnamed advice parameter at index " + i + " in " + adviceInfo.getMethodSignature());
                }
                AspectModel aspectModel = AspectModelManager.getModelFor(aspectDef.getAspectModel());
                String superClassName = aspectModel.getAroundClosureClassInfo().getSuperClassName();
                String[] interfaces = aspectModel.getAroundClosureClassInfo().getInterfaceNames();
                String[] classNames = new String[interfaces.length + 1];
                classNames[0] = superClassName;
                for (int j = 1; j < interfaces.length + 1; ++j) {
                    classNames[j] = interfaces[j - 1];
                }
                Type argType = adviceArgTypes[i];
                if (JoinPointManager.isValidAroundClosureType(argType, classNames)) {
                    adviceToTargetArgs[i] = -5;
                    continue;
                }
                if (!JoinPointManager.isSpecialArgumentType(argType, adviceInfo)) continue;
                adviceToTargetArgs[i] = -6;
            }
        }
        adviceInfo.setMethodToArgIndexes(adviceToTargetArgs);
    }

    private static boolean isSpecialArgumentType(Type argType, AdviceInfo adviceInfo) {
        String specialArgumentTypeDesc = adviceInfo.getSpecialArgumentTypeDesc();
        return specialArgumentTypeDesc != null && specialArgumentTypeDesc.equals(argType.getDescriptor());
    }

    private static boolean isValidAroundClosureType(Type argType, String[] closureTypeNames) {
        for (int i = 0; i < closureTypeNames.length; ++i) {
            String closureTypeName = closureTypeNames[i];
            if (closureTypeName == null || !closureTypeName.equals(argType.getInternalName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isJoinPoint(Type type) {
        return Type.getType(class$org$codehaus$aspectwerkz$joinpoint$JoinPoint == null ? (class$org$codehaus$aspectwerkz$joinpoint$JoinPoint = JoinPointManager.class$("org.codehaus.aspectwerkz.joinpoint.JoinPoint")) : class$org$codehaus$aspectwerkz$joinpoint$JoinPoint).getDescriptor().equals(type.getDescriptor());
    }

    private static boolean isStaticJoinPoint(Type type) {
        return Type.getType(class$org$codehaus$aspectwerkz$joinpoint$StaticJoinPoint == null ? (class$org$codehaus$aspectwerkz$joinpoint$StaticJoinPoint = JoinPointManager.class$("org.codehaus.aspectwerkz.joinpoint.StaticJoinPoint")) : class$org$codehaus$aspectwerkz$joinpoint$StaticJoinPoint).getDescriptor().equals(type.getDescriptor());
    }

    private static boolean isTarget(String adviceArgName, ExpressionContext ctx) {
        return adviceArgName.equals(ctx.m_targetBoundedName);
    }

    private static boolean isThis(String adviceArgName, ExpressionContext ctx) {
        return adviceArgName.equals(ctx.m_thisBoundedName);
    }

    private static boolean isSpecialArgument(String adviceArgName, ExpressionInfo expressionInfo) {
        return adviceArgName.equals(expressionInfo.getSpecialArgumentName());
    }

    private static boolean isCustomJointPoint(Type type, ClassLoader loader) {
        ClassInfo classInfo = AsmClassInfo.getClassInfo(type.getClassName(), loader);
        return ClassInfoHelper.implementsInterface(classInfo, ExpressionInfo.JOINPOINT_CLASS_NAME) || ClassInfoHelper.implementsInterface(classInfo, ExpressionInfo.STATIC_JOINPOINT_CLASS_NAME);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CompiledJoinPoint {
        public byte[] bytecode;
        public CompilationInfo compilationInfo;

        public CompiledJoinPoint(CompilationInfo.Model model) {
            this.bytecode = JoinPointFactory.compileJoinPoint(model);
            this.compilationInfo = new CompilationInfo(model);
        }
    }
}

