/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.intercept;

import gnu.trove.TIntObjectHashMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.intercept.Advice;
import org.codehaus.aspectwerkz.intercept.Advisable;
import org.codehaus.aspectwerkz.intercept.AfterAdvice;
import org.codehaus.aspectwerkz.intercept.AfterReturningAdvice;
import org.codehaus.aspectwerkz.intercept.AfterThrowingAdvice;
import org.codehaus.aspectwerkz.intercept.AroundAdvice;
import org.codehaus.aspectwerkz.intercept.BeforeAdvice;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.MemberInfo;
import org.codehaus.aspectwerkz.reflect.ReflectionInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfo;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;

public class AdvisableImpl
implements Advisable {
    private static final String EXPRESSION_NAMESPACE = "___AW_ADVISABLE_AW___";
    public static final ClassInfo CLASS_INFO;
    public static final AroundAdvice[] EMPTY_AROUND_ADVICE_ARRAY;
    public static final BeforeAdvice[] EMPTY_BEFORE_ADVICE_ARRAY;
    public static final AfterAdvice[] EMPTY_AFTER_ADVICE_ARRAY;
    public static final AfterReturningAdvice[] EMPTY_AFTER_RETURNING_ADVICE_ARRAY;
    public static final AfterThrowingAdvice[] EMPTY_AFTER_THROWING_ADVICE_ARRAY;
    private final Advisable m_targetInstance;
    private final TIntObjectHashMap m_emittedJoinPoints;
    private final TIntObjectHashMap m_aroundAdvice = new TIntObjectHashMap();
    private final TIntObjectHashMap m_beforeAdvice = new TIntObjectHashMap();
    private final TIntObjectHashMap m_afterAdvice = new TIntObjectHashMap();
    private final TIntObjectHashMap m_afterReturningAdvice = new TIntObjectHashMap();
    private final TIntObjectHashMap m_afterThrowingAdvice = new TIntObjectHashMap();
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$intercept$AdvisableImpl;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$intercept$AroundAdvice;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$intercept$BeforeAdvice;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$intercept$AfterAdvice;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$intercept$AfterReturningAdvice;
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$intercept$AfterThrowingAdvice;

    public AdvisableImpl(Object targetInstance) {
        if (!(targetInstance instanceof Advisable)) {
            throw new RuntimeException("advisable mixin applied to target class that does not implement the Advisable interface");
        }
        this.m_targetInstance = (Advisable)targetInstance;
        try {
            Field f = targetInstance.getClass().getDeclaredField("aw$emittedJoinPoints");
            f.setAccessible(true);
            this.m_emittedJoinPoints = (TIntObjectHashMap)f.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("advisable mixin applied to target class cannot access reflective information: " + e.toString());
        }
    }

    public void aw_addAdvice(String pointcut, Advice advice) {
        this.addAdvice(pointcut, advice);
    }

    public void aw_removeAdvice(String pointcut, Class adviceClass) {
        this.removeAdvice(pointcut, adviceClass);
    }

    public AroundAdvice[] aw$getAroundAdvice(int joinPointIndex) {
        Object advice = this.m_aroundAdvice.get(joinPointIndex);
        if (advice == null) {
            return EMPTY_AROUND_ADVICE_ARRAY;
        }
        return (AroundAdvice[])advice;
    }

    public BeforeAdvice[] aw$getBeforeAdvice(int joinPointIndex) {
        Object advice = this.m_beforeAdvice.get(joinPointIndex);
        if (advice == null) {
            return EMPTY_BEFORE_ADVICE_ARRAY;
        }
        return (BeforeAdvice[])advice;
    }

    public AfterAdvice[] aw$getAfterAdvice(int joinPointIndex) {
        Object advice = this.m_afterAdvice.get(joinPointIndex);
        if (advice == null) {
            return EMPTY_AFTER_ADVICE_ARRAY;
        }
        return (AfterAdvice[])advice;
    }

    public AfterReturningAdvice[] aw$getAfterReturningAdvice(int joinPointIndex) {
        Object advice = this.m_afterReturningAdvice.get(joinPointIndex);
        if (advice == null) {
            return EMPTY_AFTER_RETURNING_ADVICE_ARRAY;
        }
        return (AfterReturningAdvice[])advice;
    }

    public AfterThrowingAdvice[] aw$getAfterThrowingAdvice(int joinPointIndex) {
        Object advice = this.m_afterThrowingAdvice.get(joinPointIndex);
        if (advice == null) {
            return EMPTY_AFTER_THROWING_ADVICE_ARRAY;
        }
        return (AfterThrowingAdvice[])advice;
    }

    private void addAdvice(String pointcut, Advice advice) {
        ExpressionInfo expressionInfo = new ExpressionInfo(pointcut, EXPRESSION_NAMESPACE);
        Object[] emittedJoinPoints = this.m_emittedJoinPoints.getValues();
        for (int i = 0; i < emittedJoinPoints.length; ++i) {
            EmittedJoinPoint emittedJoinPoint = (EmittedJoinPoint)emittedJoinPoints[i];
            if (!this.match(expressionInfo, PointcutType.EXECUTION, emittedJoinPoint) && !this.match(expressionInfo, PointcutType.CALL, emittedJoinPoint) && !this.match(expressionInfo, PointcutType.HANDLER, emittedJoinPoint) && !this.match(expressionInfo, PointcutType.GET, emittedJoinPoint) && !this.match(expressionInfo, PointcutType.SET, emittedJoinPoint)) continue;
            int hash = emittedJoinPoint.getJoinPointClassName().hashCode();
            this.addAroundAdvice(advice, hash);
            this.addBeforeAdvice(advice, hash);
            this.addAfterAdvice(advice, hash);
            this.addAfterReturningAdvice(advice, hash);
            this.addAfterThrowingAdvice(advice, hash);
        }
    }

    private void removeAdvice(String pointcut, Class adviceClass) {
        ExpressionInfo expressionInfo = new ExpressionInfo(pointcut, EXPRESSION_NAMESPACE);
        Object[] emittedJoinPoints = this.m_emittedJoinPoints.getValues();
        for (int i = 0; i < emittedJoinPoints.length; ++i) {
            EmittedJoinPoint emittedJoinPoint = (EmittedJoinPoint)emittedJoinPoints[i];
            if (!this.match(expressionInfo, PointcutType.EXECUTION, emittedJoinPoint) && !this.match(expressionInfo, PointcutType.CALL, emittedJoinPoint) && !this.match(expressionInfo, PointcutType.HANDLER, emittedJoinPoint) && !this.match(expressionInfo, PointcutType.GET, emittedJoinPoint) && !this.match(expressionInfo, PointcutType.SET, emittedJoinPoint)) continue;
            int hash = emittedJoinPoint.getJoinPointClassName().hashCode();
            this.removeAroundAdvice(adviceClass, hash);
            this.removeBeforeAdvice(adviceClass, hash);
            this.removeAfterAdvice(adviceClass, hash);
            this.removeAfterReturningAdvice(adviceClass, hash);
            this.removeAfterThrowingAdvice(adviceClass, hash);
        }
    }

    private void addAroundAdvice(Advice advice, int joinPointHash) {
        if (advice instanceof AroundAdvice) {
            AroundAdvice[] advices;
            AroundAdvice aroundAdvice = (AroundAdvice)advice;
            AroundAdvice[] olds = this.aw$getAroundAdvice(joinPointHash);
            if (olds != null) {
                advices = new AroundAdvice[olds.length + 1];
                System.arraycopy(olds, 0, advices, 0, olds.length);
                advices[advices.length - 1] = aroundAdvice;
            } else {
                advices = new AroundAdvice[]{aroundAdvice};
            }
            this.m_aroundAdvice.put(joinPointHash, advices);
        }
    }

    private void addBeforeAdvice(Advice advice, int joinPointHash) {
        if (advice instanceof BeforeAdvice) {
            BeforeAdvice[] advices;
            BeforeAdvice beforeAdvice = (BeforeAdvice)advice;
            BeforeAdvice[] olds = this.aw$getBeforeAdvice(joinPointHash);
            if (olds != null) {
                advices = new BeforeAdvice[olds.length + 1];
                System.arraycopy(olds, 0, advices, 0, olds.length);
                advices[advices.length - 1] = beforeAdvice;
            } else {
                advices = new BeforeAdvice[]{beforeAdvice};
            }
            this.m_beforeAdvice.put(joinPointHash, advices);
        }
    }

    private void addAfterAdvice(Advice advice, int joinPointHash) {
        if (advice instanceof AfterAdvice) {
            AfterAdvice[] advices;
            AfterAdvice afterFinallyAdvice = (AfterAdvice)advice;
            AfterAdvice[] olds = this.aw$getAfterAdvice(joinPointHash);
            if (olds != null) {
                advices = new AfterAdvice[olds.length + 1];
                System.arraycopy(olds, 0, advices, 0, olds.length);
                advices[advices.length - 1] = afterFinallyAdvice;
            } else {
                advices = new AfterAdvice[]{afterFinallyAdvice};
            }
            this.m_afterAdvice.put(joinPointHash, advices);
        }
    }

    private void addAfterReturningAdvice(Advice advice, int joinPointHash) {
        if (advice instanceof AfterReturningAdvice) {
            AfterReturningAdvice[] advices;
            AfterReturningAdvice afterReturningAdvice = (AfterReturningAdvice)advice;
            AfterReturningAdvice[] olds = this.aw$getAfterReturningAdvice(joinPointHash);
            if (olds != null) {
                advices = new AfterReturningAdvice[olds.length + 1];
                System.arraycopy(olds, 0, advices, 0, olds.length);
                advices[advices.length - 1] = afterReturningAdvice;
            } else {
                advices = new AfterReturningAdvice[]{afterReturningAdvice};
            }
            this.m_afterReturningAdvice.put(joinPointHash, advices);
        }
    }

    private void addAfterThrowingAdvice(Advice advice, int joinPointHash) {
        if (advice instanceof AfterThrowingAdvice) {
            AfterThrowingAdvice[] advices;
            AfterThrowingAdvice afterThrowingAdvice = (AfterThrowingAdvice)advice;
            AfterThrowingAdvice[] olds = this.aw$getAfterThrowingAdvice(joinPointHash);
            if (olds != null) {
                advices = new AfterThrowingAdvice[olds.length + 1];
                System.arraycopy(olds, 0, advices, 0, olds.length);
                advices[advices.length - 1] = afterThrowingAdvice;
            } else {
                advices = new AfterThrowingAdvice[]{afterThrowingAdvice};
            }
            this.m_afterThrowingAdvice.put(joinPointHash, advices);
        }
    }

    private void removeAroundAdvice(Class adviceClass, int joinPointHash) {
        AroundAdvice[] oldArray;
        if (this.isAroundAdvice(adviceClass) && (oldArray = this.aw$getAroundAdvice(joinPointHash)).length != 0) {
            if (oldArray.length == 1) {
                this.m_aroundAdvice.put(joinPointHash, EMPTY_AROUND_ADVICE_ARRAY);
            } else {
                ArrayList<AroundAdvice> newArrayList = new ArrayList<AroundAdvice>();
                for (int i = 0; i < oldArray.length; ++i) {
                    AroundAdvice aroundAdvice = oldArray[i];
                    if (aroundAdvice.getClass().equals(adviceClass)) continue;
                    newArrayList.add(aroundAdvice);
                }
                this.m_aroundAdvice.put(joinPointHash, newArrayList.toArray(new AroundAdvice[newArrayList.size()]));
            }
        }
    }

    private void removeBeforeAdvice(Class adviceClass, int joinPointHash) {
        BeforeAdvice[] oldArray;
        if (this.isBeforeAdvice(adviceClass) && (oldArray = this.aw$getBeforeAdvice(joinPointHash)).length != 0) {
            if (oldArray.length == 1) {
                this.m_beforeAdvice.put(joinPointHash, EMPTY_BEFORE_ADVICE_ARRAY);
            } else {
                ArrayList<BeforeAdvice> newArrayList = new ArrayList<BeforeAdvice>();
                for (int i = 0; i < oldArray.length; ++i) {
                    BeforeAdvice beforeAdvice = oldArray[i];
                    if (beforeAdvice.getClass().equals(adviceClass)) continue;
                    newArrayList.add(beforeAdvice);
                }
                this.m_beforeAdvice.put(joinPointHash, newArrayList.toArray(new BeforeAdvice[newArrayList.size()]));
            }
        }
    }

    private void removeAfterAdvice(Class adviceClass, int joinPointHash) {
        AfterAdvice[] oldArray;
        if (this.isAfterAdvice(adviceClass) && (oldArray = this.aw$getAfterAdvice(joinPointHash)).length != 0) {
            if (oldArray.length == 1) {
                this.m_afterAdvice.put(joinPointHash, EMPTY_AFTER_ADVICE_ARRAY);
            } else {
                ArrayList<AfterAdvice> newArrayList = new ArrayList<AfterAdvice>();
                for (int i = 0; i < oldArray.length; ++i) {
                    AfterAdvice afterAdvice = oldArray[i];
                    if (afterAdvice.getClass().equals(adviceClass)) continue;
                    newArrayList.add(afterAdvice);
                }
                this.m_afterAdvice.put(joinPointHash, newArrayList.toArray(new AfterAdvice[newArrayList.size()]));
            }
        }
    }

    private void removeAfterReturningAdvice(Class adviceClass, int joinPointHash) {
        AfterReturningAdvice[] oldArray;
        if (this.isAfterReturningAdvice(adviceClass) && (oldArray = this.aw$getAfterReturningAdvice(joinPointHash)).length != 0) {
            if (oldArray.length == 1) {
                this.m_afterReturningAdvice.put(joinPointHash, EMPTY_AFTER_RETURNING_ADVICE_ARRAY);
            } else {
                ArrayList<AfterReturningAdvice> newArrayList = new ArrayList<AfterReturningAdvice>();
                for (int i = 0; i < oldArray.length; ++i) {
                    AfterReturningAdvice afterReturningAdvice = oldArray[i];
                    if (afterReturningAdvice.getClass().equals(adviceClass)) continue;
                    newArrayList.add(afterReturningAdvice);
                }
                this.m_afterReturningAdvice.put(joinPointHash, newArrayList.toArray(new AfterReturningAdvice[newArrayList.size()]));
            }
        }
    }

    private void removeAfterThrowingAdvice(Class adviceClass, int joinPointHash) {
        AfterThrowingAdvice[] oldArray;
        if (this.isAfterThrowingAdvice(adviceClass) && (oldArray = this.aw$getAfterThrowingAdvice(joinPointHash)).length != 0) {
            if (oldArray.length == 1) {
                this.m_afterThrowingAdvice.put(joinPointHash, EMPTY_AFTER_THROWING_ADVICE_ARRAY);
            } else {
                ArrayList<AfterThrowingAdvice> newArrayList = new ArrayList<AfterThrowingAdvice>();
                for (int i = 0; i < oldArray.length; ++i) {
                    AfterThrowingAdvice advice = oldArray[i];
                    if (advice.getClass().equals(adviceClass)) continue;
                    newArrayList.add(advice);
                }
                this.m_afterThrowingAdvice.put(joinPointHash, newArrayList.toArray(new AfterThrowingAdvice[newArrayList.size()]));
            }
        }
    }

    private boolean isAroundAdvice(Class adviceClass) {
        if (adviceClass == (class$org$codehaus$aspectwerkz$intercept$AroundAdvice == null ? (class$org$codehaus$aspectwerkz$intercept$AroundAdvice = AdvisableImpl.class$("org.codehaus.aspectwerkz.intercept.AroundAdvice")) : class$org$codehaus$aspectwerkz$intercept$AroundAdvice)) {
            return true;
        }
        Class<?>[] interfaces = adviceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (anInterface != (class$org$codehaus$aspectwerkz$intercept$AroundAdvice == null ? AdvisableImpl.class$("org.codehaus.aspectwerkz.intercept.AroundAdvice") : class$org$codehaus$aspectwerkz$intercept$AroundAdvice)) continue;
            return true;
        }
        return false;
    }

    private boolean isBeforeAdvice(Class adviceClass) {
        if (adviceClass == (class$org$codehaus$aspectwerkz$intercept$BeforeAdvice == null ? (class$org$codehaus$aspectwerkz$intercept$BeforeAdvice = AdvisableImpl.class$("org.codehaus.aspectwerkz.intercept.BeforeAdvice")) : class$org$codehaus$aspectwerkz$intercept$BeforeAdvice)) {
            return true;
        }
        Class<?>[] interfaces = adviceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (anInterface != (class$org$codehaus$aspectwerkz$intercept$BeforeAdvice == null ? AdvisableImpl.class$("org.codehaus.aspectwerkz.intercept.BeforeAdvice") : class$org$codehaus$aspectwerkz$intercept$BeforeAdvice)) continue;
            return true;
        }
        return false;
    }

    private boolean isAfterAdvice(Class adviceClass) {
        if (adviceClass == (class$org$codehaus$aspectwerkz$intercept$AfterAdvice == null ? (class$org$codehaus$aspectwerkz$intercept$AfterAdvice = AdvisableImpl.class$("org.codehaus.aspectwerkz.intercept.AfterAdvice")) : class$org$codehaus$aspectwerkz$intercept$AfterAdvice)) {
            return true;
        }
        Class<?>[] interfaces = adviceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (anInterface != (class$org$codehaus$aspectwerkz$intercept$AfterAdvice == null ? AdvisableImpl.class$("org.codehaus.aspectwerkz.intercept.AfterAdvice") : class$org$codehaus$aspectwerkz$intercept$AfterAdvice)) continue;
            return true;
        }
        return false;
    }

    private boolean isAfterReturningAdvice(Class adviceClass) {
        if (adviceClass == (class$org$codehaus$aspectwerkz$intercept$AfterReturningAdvice == null ? (class$org$codehaus$aspectwerkz$intercept$AfterReturningAdvice = AdvisableImpl.class$("org.codehaus.aspectwerkz.intercept.AfterReturningAdvice")) : class$org$codehaus$aspectwerkz$intercept$AfterReturningAdvice)) {
            return true;
        }
        Class<?>[] interfaces = adviceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (anInterface != (class$org$codehaus$aspectwerkz$intercept$AfterReturningAdvice == null ? AdvisableImpl.class$("org.codehaus.aspectwerkz.intercept.AfterReturningAdvice") : class$org$codehaus$aspectwerkz$intercept$AfterReturningAdvice)) continue;
            return true;
        }
        return false;
    }

    private boolean isAfterThrowingAdvice(Class adviceClass) {
        if (adviceClass == (class$org$codehaus$aspectwerkz$intercept$AfterThrowingAdvice == null ? (class$org$codehaus$aspectwerkz$intercept$AfterThrowingAdvice = AdvisableImpl.class$("org.codehaus.aspectwerkz.intercept.AfterThrowingAdvice")) : class$org$codehaus$aspectwerkz$intercept$AfterThrowingAdvice)) {
            return true;
        }
        Class<?>[] interfaces = adviceClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            if (anInterface != (class$org$codehaus$aspectwerkz$intercept$AfterThrowingAdvice == null ? AdvisableImpl.class$("org.codehaus.aspectwerkz.intercept.AfterThrowingAdvice") : class$org$codehaus$aspectwerkz$intercept$AfterThrowingAdvice)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean match(ExpressionInfo expression, PointcutType pointcutType, EmittedJoinPoint emittedJoinPoint) {
        void var6_6;
        void var7_7;
        ClassInfo callerClassInfo = JavaClassInfo.getClassInfo(this.m_targetInstance.getClass());
        ClassInfo calleeClassInfo = AsmClassInfo.getClassInfo(emittedJoinPoint.getCalleeClassName(), this.m_targetInstance.getClass().getClassLoader());
        if (!expression.getAdvisedClassFilterExpression().match(new ExpressionContext(pointcutType, calleeClassInfo, callerClassInfo))) {
            return false;
        }
        switch (emittedJoinPoint.getJoinPointType()) {
            case 8: {
                ReflectionInfo reflectionInfo = calleeClassInfo.staticInitializer();
                PointcutType joinPointType = PointcutType.STATIC_INITIALIZATION;
                break;
            }
            case 1: {
                ReflectionInfo reflectionInfo = calleeClassInfo.getMethod(emittedJoinPoint.getJoinPointHash());
                PointcutType joinPointType = PointcutType.EXECUTION;
                break;
            }
            case 2: {
                ReflectionInfo reflectionInfo = calleeClassInfo.getMethod(emittedJoinPoint.getJoinPointHash());
                PointcutType joinPointType = PointcutType.CALL;
                break;
            }
            case 6: {
                ReflectionInfo reflectionInfo = calleeClassInfo.getField(emittedJoinPoint.getJoinPointHash());
                PointcutType joinPointType = PointcutType.GET;
                break;
            }
            case 5: {
                ReflectionInfo reflectionInfo = calleeClassInfo.getField(emittedJoinPoint.getJoinPointHash());
                PointcutType joinPointType = PointcutType.SET;
                break;
            }
            case 3: {
                ReflectionInfo reflectionInfo = calleeClassInfo.getConstructor(emittedJoinPoint.getJoinPointHash());
                PointcutType joinPointType = PointcutType.EXECUTION;
                break;
            }
            case 4: {
                ReflectionInfo reflectionInfo = calleeClassInfo.getConstructor(emittedJoinPoint.getJoinPointHash());
                PointcutType joinPointType = PointcutType.CALL;
                break;
            }
            case 7: {
                ReflectionInfo reflectionInfo = calleeClassInfo;
                PointcutType joinPointType = PointcutType.HANDLER;
                break;
            }
            default: {
                throw new RuntimeException("Joinpoint type not supported: " + emittedJoinPoint.getJoinPointType());
            }
        }
        MemberInfo withinInfo = "<clinit>".equals(emittedJoinPoint.getCallerMethodName()) ? callerClassInfo.staticInitializer() : ("<init>".equals(emittedJoinPoint.getCallerMethodName()) ? callerClassInfo.getConstructor(AsmHelper.calculateConstructorHash(emittedJoinPoint.getCallerMethodDesc())) : callerClassInfo.getMethod(AsmHelper.calculateMethodHash(emittedJoinPoint.getCallerMethodName(), emittedJoinPoint.getCallerMethodDesc())));
        if (pointcutType != PointcutType.WITHIN && pointcutType != var7_7) {
            return false;
        }
        return expression.getExpression().match(new ExpressionContext(pointcutType, (ReflectionInfo)var6_6, withinInfo));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        EMPTY_AROUND_ADVICE_ARRAY = new AroundAdvice[0];
        EMPTY_BEFORE_ADVICE_ARRAY = new BeforeAdvice[0];
        EMPTY_AFTER_ADVICE_ARRAY = new AfterAdvice[0];
        EMPTY_AFTER_RETURNING_ADVICE_ARRAY = new AfterReturningAdvice[0];
        EMPTY_AFTER_THROWING_ADVICE_ARRAY = new AfterThrowingAdvice[0];
        Class clazz = class$org$codehaus$aspectwerkz$intercept$AdvisableImpl == null ? (class$org$codehaus$aspectwerkz$intercept$AdvisableImpl = AdvisableImpl.class$("org.codehaus.aspectwerkz.intercept.AdvisableImpl")) : class$org$codehaus$aspectwerkz$intercept$AdvisableImpl;
        try {
            CLASS_INFO = AsmClassInfo.getClassInfo(clazz.getName(), clazz.getClassLoader());
        }
        catch (Exception e) {
            throw new Error("could not create class info for [" + clazz.getName() + ']');
        }
    }
}

