/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.definition;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.annotation.AspectAnnotationParser;
import org.codehaus.aspectwerkz.annotation.MixinAnnotationParser;
import org.codehaus.aspectwerkz.aspect.AdviceType;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionParserHelper;
import org.codehaus.aspectwerkz.definition.MixinDefinition;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.expression.regexp.Pattern;
import org.codehaus.aspectwerkz.intercept.AdvisableImpl;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaClassInfo;
import org.codehaus.aspectwerkz.reflect.impl.java.JavaMethodInfo;
import org.codehaus.aspectwerkz.transform.inlining.AspectModelManager;
import org.codehaus.aspectwerkz.util.Strings;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class DocumentParser {
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$definition$Virtual;

    public static List parseAspectClassNames(Document document) {
        ArrayList<String> aspectClassNames = new ArrayList<String>();
        Iterator it1 = document.getRootElement().elementIterator("system");
        while (it1.hasNext()) {
            Element system = (Element)it1.next();
            String basePackage = DocumentParser.getBasePackage(system);
            Iterator it11 = system.elementIterator("aspect");
            while (it11.hasNext()) {
                String className = null;
                Element aspect = (Element)it11.next();
                Iterator it2 = aspect.attributeIterator();
                while (it2.hasNext()) {
                    Attribute attribute = (Attribute)it2.next();
                    String name = attribute.getName().trim();
                    String value = attribute.getValue().trim();
                    if (!name.equalsIgnoreCase("class")) continue;
                    className = value;
                }
                aspectClassNames.add(basePackage + className);
            }
            it11 = system.elementIterator("package");
            while (it11.hasNext()) {
                Element packageElement = (Element)it11.next();
                String packageName = DocumentParser.getPackage(packageElement);
                Iterator it12 = packageElement.elementIterator("aspect");
                while (it12.hasNext()) {
                    String className = null;
                    Element aspect = (Element)it12.next();
                    Iterator it2 = aspect.attributeIterator();
                    while (it2.hasNext()) {
                        Attribute attribute = (Attribute)it2.next();
                        String name = attribute.getName().trim();
                        String value = attribute.getValue().trim();
                        if (!name.equalsIgnoreCase("class")) continue;
                        className = value;
                    }
                    aspectClassNames.add(packageName + className);
                }
            }
        }
        aspectClassNames.add((class$org$codehaus$aspectwerkz$definition$Virtual == null ? (class$org$codehaus$aspectwerkz$definition$Virtual = DocumentParser.class$("org.codehaus.aspectwerkz.definition.Virtual")) : class$org$codehaus$aspectwerkz$definition$Virtual).getName());
        return aspectClassNames;
    }

    public static AspectDefinition parseAspectDefinition(Document document, SystemDefinition systemDef, Class aspectClass) {
        Element aspect = document.getRootElement();
        if (!aspect.getName().equals("aspect")) {
            throw new DefinitionException("XML definition for aspect is not well-formed: " + document.asXML());
        }
        String specialAspectName = null;
        String className = null;
        String deploymentModelAsString = null;
        String containerClassName = null;
        Iterator it2 = aspect.attributeIterator();
        while (it2.hasNext()) {
            Attribute attribute = (Attribute)it2.next();
            String name = attribute.getName().trim();
            String value = attribute.getValue().trim();
            if (name.equalsIgnoreCase("class")) {
                className = value;
                continue;
            }
            if (name.equalsIgnoreCase("deployment-model")) {
                deploymentModelAsString = value;
                continue;
            }
            if (name.equalsIgnoreCase("name")) {
                specialAspectName = value;
                continue;
            }
            if (!name.equalsIgnoreCase("container")) continue;
            containerClassName = value;
        }
        if (specialAspectName == null) {
            specialAspectName = className;
        }
        ClassInfo classInfo = JavaClassInfo.getClassInfo(aspectClass);
        ClassLoader loader = aspectClass.getClassLoader();
        AspectDefinition aspectDef = new AspectDefinition(specialAspectName, classInfo, systemDef);
        aspectDef.setContainerClassName(containerClassName);
        aspectDef.setDeploymentModel(DeploymentModel.getDeploymentModelFor(deploymentModelAsString));
        DocumentParser.parsePointcutElements(aspect, aspectDef);
        AspectModelManager.defineAspect(classInfo, aspectDef, loader);
        DocumentParser.parseParameterElements(aspect, aspectDef);
        DocumentParser.parsePointcutElements(aspect, aspectDef);
        DocumentParser.parseAdviceElements(aspect, aspectDef, JavaClassInfo.getClassInfo(aspectClass));
        DocumentParser.parseIntroduceElements(aspect, aspectDef, "", aspectClass.getClassLoader());
        systemDef.addAspect(aspectDef);
        return aspectDef;
    }

    public static Set parse(ClassLoader loader, Document document) {
        Element root = document.getRootElement();
        return DocumentParser.parseSystemElements(loader, root);
    }

    private static Set parseSystemElements(ClassLoader loader, Element root) {
        HashSet<SystemDefinition> systemDefs = new HashSet<SystemDefinition>();
        Iterator it1 = root.elementIterator("system");
        while (it1.hasNext()) {
            Element system = (Element)it1.next();
            SystemDefinition definition = DocumentParser.parseSystemElement(loader, system, DocumentParser.getBasePackage(system));
            if (definition == null) continue;
            systemDefs.add(definition);
        }
        return systemDefs;
    }

    private static SystemDefinition parseSystemElement(ClassLoader loader, Element systemElement, String basePackage) {
        String uuid = systemElement.attributeValue("id");
        if (uuid == null || uuid.equals("")) {
            throw new DefinitionException("system UUID must be specified");
        }
        SystemDefinition definition = new SystemDefinition(uuid);
        DocumentParser.addVirtualAspect(definition);
        List globalPointcuts = DocumentParser.parseGlobalPointcutDefs(systemElement);
        ExpressionNamespace systemNamespace = ExpressionNamespace.getNamespace(definition.getUuid());
        Iterator iterator = globalPointcuts.iterator();
        while (iterator.hasNext()) {
            PointcutInfo pointcutInfo = (PointcutInfo)iterator.next();
            systemNamespace.addExpressionInfo(pointcutInfo.name, new ExpressionInfo(pointcutInfo.expression, systemNamespace.getName()));
        }
        DocumentParser.parseDeploymentScopeDefs(systemElement, definition);
        DocumentParser.parseAdvisableDefs(systemElement, definition);
        DocumentParser.parseIncludePackageElements(systemElement, definition, basePackage);
        DocumentParser.parseExcludePackageElements(systemElement, definition, basePackage);
        DocumentParser.parsePrepareElements(systemElement, definition, basePackage);
        DocumentParser.parseAspectElements(loader, systemElement, definition, basePackage, globalPointcuts);
        DocumentParser.parseMixinElements(loader, systemElement, definition, basePackage);
        DocumentParser.parsePackageElements(loader, systemElement, definition, basePackage, globalPointcuts);
        DefinitionParserHelper.attachDeploymentScopeDefsToVirtualAdvice(definition);
        return definition;
    }

    private static List parseGlobalPointcutDefs(Element systemElement) {
        ArrayList<PointcutInfo> globalPointcuts = new ArrayList<PointcutInfo>();
        Iterator it11 = systemElement.elementIterator("pointcut");
        while (it11.hasNext()) {
            PointcutInfo pointcutInfo = new PointcutInfo();
            Element globalPointcut = (Element)it11.next();
            Iterator it2 = globalPointcut.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                String name = attribute.getName().trim();
                String value = attribute.getValue().trim();
                if (name.equalsIgnoreCase("name")) {
                    pointcutInfo.name = value;
                    continue;
                }
                if (!name.equalsIgnoreCase("expression")) continue;
                pointcutInfo.expression = value;
            }
            if (pointcutInfo.expression == null) {
                pointcutInfo.expression = globalPointcut.getTextTrim();
            }
            globalPointcuts.add(pointcutInfo);
        }
        return globalPointcuts;
    }

    private static void parseDeploymentScopeDefs(Element systemElement, SystemDefinition definition) {
        Iterator it11 = systemElement.elementIterator("deployment-scope");
        while (it11.hasNext()) {
            String expression = null;
            String name = null;
            Element globalPointcut = (Element)it11.next();
            Iterator it2 = globalPointcut.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                String attrName = attribute.getName().trim();
                String attrValue = attribute.getValue().trim();
                if (attrName.equalsIgnoreCase("name")) {
                    name = attrValue;
                    continue;
                }
                if (!attrName.equalsIgnoreCase("expression")) continue;
                expression = attrValue;
            }
            if (expression == null) {
                expression = globalPointcut.getTextTrim();
            }
            DefinitionParserHelper.createAndAddDeploymentScopeDef(name, expression, definition);
        }
    }

    private static void parseAdvisableDefs(Element systemElement, SystemDefinition definition) {
        Iterator it11 = systemElement.elementIterator("advisable");
        while (it11.hasNext()) {
            Element advisableElement = (Element)it11.next();
            String expression = "";
            String pointcutTypes = "all";
            Iterator it2 = advisableElement.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                String name = attribute.getName().trim();
                String value = attribute.getValue().trim();
                if (name.equalsIgnoreCase("expression")) {
                    expression = value;
                    continue;
                }
                if (!name.equalsIgnoreCase("pointcut-type")) continue;
                pointcutTypes = value;
            }
            if (expression == null) {
                expression = advisableElement.getTextTrim();
            }
            DocumentParser.handleAdvisableDefinition(definition, expression, pointcutTypes);
        }
    }

    private static void parsePackageElements(ClassLoader loader, Element systemElement, SystemDefinition definition, String basePackage, List globalPointcuts) {
        Iterator it1 = systemElement.elementIterator("package");
        while (it1.hasNext()) {
            Element packageElement = (Element)it1.next();
            String packageName = basePackage + DocumentParser.getPackage(packageElement);
            DocumentParser.parseAspectElements(loader, packageElement, definition, packageName, globalPointcuts);
            DocumentParser.parseMixinElements(loader, packageElement, definition, packageName);
            DocumentParser.parseAdvisableDefs(packageElement, definition);
        }
    }

    private static void parseAspectElements(ClassLoader loader, Element systemElement, SystemDefinition definition, String packageName, List globalPointcuts) {
        Iterator it1 = systemElement.elementIterator("aspect");
        while (it1.hasNext()) {
            ClassInfo aspectClassInfo;
            String aspectName = null;
            String className = null;
            String deploymentModel = null;
            String containerClassName = null;
            Element aspect = (Element)it1.next();
            Iterator it2 = aspect.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                String name = attribute.getName().trim();
                String value = attribute.getValue().trim();
                if (name.equalsIgnoreCase("class")) {
                    className = value;
                    continue;
                }
                if (name.equalsIgnoreCase("deployment-model")) {
                    deploymentModel = value;
                    continue;
                }
                if (name.equalsIgnoreCase("name")) {
                    aspectName = value;
                    continue;
                }
                if (!name.equalsIgnoreCase("container")) continue;
                containerClassName = value;
            }
            String aspectClassName = packageName + className;
            if (aspectName == null) {
                aspectName = aspectClassName;
            }
            try {
                aspectClassInfo = AsmClassInfo.getClassInfo(aspectClassName, loader);
            }
            catch (Exception e) {
                System.err.println("Warning: could not load aspect " + aspectClassName + " from " + loader + "due to: " + e.toString());
                e.printStackTrace();
                continue;
            }
            AspectDefinition aspectDef = new AspectDefinition(aspectName, aspectClassInfo, definition);
            Iterator it = globalPointcuts.iterator();
            while (it.hasNext()) {
                PointcutInfo pointcutInfo = (PointcutInfo)it.next();
                DefinitionParserHelper.createAndAddPointcutDefToAspectDef(pointcutInfo.name, pointcutInfo.expression, aspectDef);
            }
            DocumentParser.parsePointcutElements(aspect, aspectDef);
            AspectModelManager.defineAspect(aspectClassInfo, aspectDef, loader);
            AspectAnnotationParser.parse(aspectClassInfo, aspectDef, loader);
            if (!Strings.isNullOrEmpty(deploymentModel)) {
                aspectDef.setDeploymentModel(DeploymentModel.getDeploymentModelFor(deploymentModel));
            }
            if (!Strings.isNullOrEmpty(aspectName)) {
                aspectDef.setName(aspectName);
            }
            if (!Strings.isNullOrEmpty(containerClassName)) {
                aspectDef.setContainerClassName(containerClassName);
            }
            DocumentParser.parseParameterElements(aspect, aspectDef);
            DocumentParser.parsePointcutElements(aspect, aspectDef);
            DocumentParser.parseAdviceElements(aspect, aspectDef, aspectClassInfo);
            DocumentParser.parseIntroduceElements(aspect, aspectDef, packageName, loader);
            definition.addAspect(aspectDef);
        }
    }

    private static void parseMixinElements(ClassLoader loader, Element systemElement, SystemDefinition systemDefinition, String packageName) {
        Iterator it1 = systemElement.elementIterator("mixin");
        while (it1.hasNext()) {
            ClassInfo mixinClassInfo;
            String className = null;
            String deploymentModelAsString = null;
            boolean isTransient = false;
            boolean isTransientSetInXML = false;
            String factoryClassName = null;
            String expression = null;
            Element mixin = (Element)it1.next();
            Iterator it2 = mixin.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                String name = attribute.getName().trim();
                String value = attribute.getValue().trim();
                if (name.equalsIgnoreCase("class")) {
                    className = value;
                    continue;
                }
                if (name.equalsIgnoreCase("deployment-model") && value != null) {
                    deploymentModelAsString = value;
                    continue;
                }
                if (name.equalsIgnoreCase("transient")) {
                    if (value == null || !value.equalsIgnoreCase("true")) continue;
                    isTransient = true;
                    isTransientSetInXML = true;
                    continue;
                }
                if (name.equalsIgnoreCase("factory")) {
                    factoryClassName = value;
                    continue;
                }
                if (!name.equalsIgnoreCase("bind-to")) continue;
                expression = value;
            }
            String mixinClassName = packageName + className;
            try {
                mixinClassInfo = AsmClassInfo.getClassInfo(mixinClassName, loader);
            }
            catch (Exception e) {
                System.err.println("Warning: could not load mixin " + mixinClassName + " from " + loader + "due to: " + e.toString());
                e.printStackTrace();
                continue;
            }
            DeploymentModel deploymentModel = deploymentModelAsString != null ? DeploymentModel.getDeploymentModelFor(deploymentModelAsString) : DeploymentModel.PER_INSTANCE;
            MixinDefinition mixinDefinition = DefinitionParserHelper.createAndAddMixinDefToSystemDef(mixinClassInfo, expression, deploymentModel, isTransient, systemDefinition);
            MixinAnnotationParser.parse(mixinClassInfo, mixinDefinition);
            if (!Strings.isNullOrEmpty(deploymentModelAsString)) {
                mixinDefinition.setDeploymentModel(DeploymentModel.getDeploymentModelFor(deploymentModelAsString));
            }
            if (!Strings.isNullOrEmpty(factoryClassName)) {
                mixinDefinition.setFactoryClassName(factoryClassName);
            }
            if (isTransientSetInXML) {
                mixinDefinition.setTransient(isTransient);
            }
            DocumentParser.parseParameterElements(mixin, mixinDefinition);
        }
    }

    public static void addVirtualAspect(SystemDefinition definition) {
        Class clazz = class$org$codehaus$aspectwerkz$definition$Virtual == null ? (class$org$codehaus$aspectwerkz$definition$Virtual = DocumentParser.class$("org.codehaus.aspectwerkz.definition.Virtual")) : class$org$codehaus$aspectwerkz$definition$Virtual;
        String aspectName = clazz.getName();
        ClassInfo aspectClassInfo = JavaClassInfo.getClassInfo(clazz);
        AspectDefinition aspectDef = new AspectDefinition(aspectName, aspectClassInfo, definition);
        try {
            MethodInfo methodInfo = JavaMethodInfo.getMethodInfo(clazz.getDeclaredMethod("virtual", new Class[0]));
            aspectDef.addBeforeAdviceDefinition(new AdviceDefinition(methodInfo.getName(), AdviceType.BEFORE, null, aspectName, aspectName, null, methodInfo, aspectDef));
        }
        catch (NoSuchMethodException e) {
            throw new Error("virtual aspect [" + aspectName + "] does not have expected method: " + e.toString());
        }
        definition.addAspect(aspectDef);
    }

    private static void parseParameterElements(Element aspectElement, AspectDefinition aspectDef) {
        Iterator it2 = aspectElement.elementIterator();
        while (it2.hasNext()) {
            Element parameterElement = (Element)it2.next();
            if (!parameterElement.getName().trim().equals("param")) continue;
            aspectDef.addParameter(parameterElement.attributeValue("name"), parameterElement.attributeValue("value"));
        }
    }

    private static void parseParameterElements(Element mixinElement, MixinDefinition mixinDef) {
        Iterator it2 = mixinElement.elementIterator();
        while (it2.hasNext()) {
            Element parameterElement = (Element)it2.next();
            if (!parameterElement.getName().trim().equals("param")) continue;
            mixinDef.addParameter(parameterElement.attributeValue("name"), parameterElement.attributeValue("value"));
        }
    }

    private static void parsePointcutElements(Element aspectElement, AspectDefinition aspectDef) {
        Iterator it2 = aspectElement.elementIterator();
        while (it2.hasNext()) {
            String expression;
            String name;
            Element pointcutElement = (Element)it2.next();
            if (pointcutElement.getName().trim().equals("pointcut")) {
                name = pointcutElement.attributeValue("name");
                expression = pointcutElement.attributeValue("expression");
                if (expression == null) {
                    expression = pointcutElement.getTextTrim();
                }
                DefinitionParserHelper.createAndAddPointcutDefToAspectDef(name, expression, aspectDef);
                continue;
            }
            if (pointcutElement.getName().trim().equals("deployment-scope")) {
                name = pointcutElement.attributeValue("name");
                expression = pointcutElement.attributeValue("expression");
                if (expression == null) {
                    expression = pointcutElement.getTextTrim();
                }
                DefinitionParserHelper.createAndAddDeploymentScopeDef(name, expression, aspectDef.getSystemDefinition());
                continue;
            }
            if (!pointcutElement.getName().trim().equals("advisable")) continue;
            String expression2 = pointcutElement.attributeValue("expression");
            String pointcutTypes = pointcutElement.attributeValue("pointcut-type");
            if (expression2 == null) {
                expression2 = pointcutElement.getTextTrim();
            }
            DocumentParser.handleAdvisableDefinition(aspectDef.getSystemDefinition(), expression2, pointcutTypes);
        }
    }

    private static void parseAdviceElements(Element aspectElement, AspectDefinition aspectDef, ClassInfo aspectClassInfo) {
        List methodList = ClassInfoHelper.createMethodList(aspectClassInfo);
        Iterator it2 = aspectElement.elementIterator();
        while (it2.hasNext()) {
            Element adviceElement = (Element)it2.next();
            if (!adviceElement.getName().trim().equals("advice")) continue;
            String name = adviceElement.attributeValue("name");
            String type = adviceElement.attributeValue("type");
            String bindTo = adviceElement.attributeValue("bind-to");
            String adviceName = name;
            MethodInfo method = null;
            Iterator it3 = methodList.iterator();
            while (it3.hasNext()) {
                MethodInfo methodCurrent = (MethodInfo)it3.next();
                if (aspectDef.isAspectWerkzAspect()) {
                    if (!DocumentParser.matchMethodAsAdvice(methodCurrent, name)) continue;
                    method = methodCurrent;
                    break;
                }
                if (!methodCurrent.getName().equals(name)) continue;
                method = methodCurrent;
                break;
            }
            if (method == null) {
                throw new DefinitionException("could not find advice method [" + name + "] in [" + aspectClassInfo.getName() + "] (are you using a compiler extension that you have not registered?)" + " (are you using XML defined advice, with StaticJoinPoint bindings without specifying the full" + "source like signature?)");
            }
            DocumentParser.createAndAddAdviceDefsToAspectDef(type, bindTo, adviceName, method, aspectDef);
            Iterator it1 = adviceElement.elementIterator("bind-to");
            while (it1.hasNext()) {
                Element bindToElement = (Element)it1.next();
                String pointcut = bindToElement.attributeValue("pointcut");
                DocumentParser.createAndAddAdviceDefsToAspectDef(type, pointcut, adviceName, method, aspectDef);
            }
        }
    }

    private static void parseIntroduceElements(Element aspectElement, AspectDefinition aspectDef, String packageName, ClassLoader loader) {
        Iterator it2 = aspectElement.elementIterator();
        while (it2.hasNext()) {
            ClassInfo introductionClassInfo;
            Element introduceElement = (Element)it2.next();
            if (!introduceElement.getName().trim().equals("introduce")) continue;
            String klass = introduceElement.attributeValue("class");
            String name = introduceElement.attributeValue("name");
            String bindTo = introduceElement.attributeValue("bind-to");
            String fullClassName = packageName + klass;
            if (name == null || name.length() <= 0) {
                name = fullClassName;
            }
            try {
                introductionClassInfo = AsmClassInfo.getClassInfo(fullClassName, loader);
            }
            catch (Exception e) {
                throw new DefinitionException("could not find interface introduction: " + packageName + klass + " " + e.getMessage());
            }
            if (!introductionClassInfo.isInterface()) continue;
            DefinitionParserHelper.createAndAddInterfaceIntroductionDefToAspectDef(bindTo, name, fullClassName, aspectDef);
            Iterator it1 = introduceElement.elementIterator("bind-to");
            while (it1.hasNext()) {
                Element bindToElement = (Element)it1.next();
                String pointcut = bindToElement.attributeValue("pointcut");
                DefinitionParserHelper.createAndAddInterfaceIntroductionDefToAspectDef(pointcut, name, fullClassName, aspectDef);
            }
        }
    }

    private static void createAndAddAdviceDefsToAspectDef(String type, String bindTo, String name, MethodInfo method, AspectDefinition aspectDef) {
        block17: {
            try {
                if (type.equalsIgnoreCase("around")) {
                    String aspectName = aspectDef.getName();
                    AdviceDefinition adviceDef = DefinitionParserHelper.createAdviceDefinition(name, AdviceType.AROUND, bindTo, null, aspectName, aspectDef.getClassName(), method, aspectDef);
                    aspectDef.addAroundAdviceDefinition(adviceDef);
                    break block17;
                }
                if (type.equalsIgnoreCase("before")) {
                    String aspectName = aspectDef.getName();
                    AdviceDefinition adviceDef = DefinitionParserHelper.createAdviceDefinition(name, AdviceType.BEFORE, bindTo, null, aspectName, aspectDef.getClassName(), method, aspectDef);
                    aspectDef.addBeforeAdviceDefinition(adviceDef);
                    break block17;
                }
                if (type.startsWith("after")) {
                    int end;
                    int start;
                    String specialArgumentType = null;
                    AdviceType adviceType = AdviceType.AFTER;
                    if (type.startsWith("after returning(")) {
                        adviceType = AdviceType.AFTER_RETURNING;
                        start = type.indexOf(40);
                        end = type.indexOf(41);
                        specialArgumentType = type.substring(start + 1, end).trim();
                    } else if (type.startsWith("after throwing(")) {
                        adviceType = AdviceType.AFTER_THROWING;
                        start = type.indexOf(40);
                        end = type.indexOf(41);
                        specialArgumentType = type.substring(start + 1, end).trim();
                    } else if (type.startsWith("after returning")) {
                        adviceType = AdviceType.AFTER_RETURNING;
                    } else if (type.startsWith("after throwing")) {
                        adviceType = AdviceType.AFTER_THROWING;
                    } else if (type.startsWith("after")) {
                        adviceType = AdviceType.AFTER_FINALLY;
                    } else if (type.startsWith("after finally")) {
                        adviceType = AdviceType.AFTER_FINALLY;
                    }
                    if (specialArgumentType != null && specialArgumentType.indexOf(32) > 0) {
                        throw new DefinitionException("argument to after (returning/throwing) can only be a type (parameter name binding should be done using args(..))");
                    }
                    String aspectName = aspectDef.getName();
                    AdviceDefinition adviceDef = DefinitionParserHelper.createAdviceDefinition(name, adviceType, bindTo, specialArgumentType, aspectName, aspectDef.getClassName(), method, aspectDef);
                    aspectDef.addAfterAdviceDefinition(adviceDef);
                    break block17;
                }
                throw new DefinitionException("Unkonw type for advice : " + type);
            }
            catch (DefinitionException e) {
                System.err.println("WARNING: unable to register advice " + aspectDef.getName() + "." + name + " at pointcut [" + bindTo + "] due to: " + e.getMessage());
            }
        }
    }

    private static String getPackage(Element packageElement) {
        String packageName = "";
        Iterator it2 = packageElement.attributeIterator();
        while (it2.hasNext()) {
            Attribute attribute = (Attribute)it2.next();
            if (!attribute.getName().trim().equalsIgnoreCase("name")) continue;
            packageName = attribute.getValue().trim();
            if (packageName.endsWith(".*")) {
                packageName = packageName.substring(0, packageName.length() - 1);
                break;
            }
            if (packageName.endsWith(".")) break;
            packageName = packageName + ".";
            break;
        }
        return packageName;
    }

    private static void parseIncludePackageElements(Element root, SystemDefinition definition, String packageName) {
        Iterator it1 = root.elementIterator("include");
        while (it1.hasNext()) {
            String includePackage = "";
            Element includeElement = (Element)it1.next();
            Iterator it2 = includeElement.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                if (!attribute.getName().trim().equalsIgnoreCase("package")) continue;
                if (packageName.endsWith(".*")) {
                    includePackage = packageName.substring(0, packageName.length() - 2);
                } else if (packageName.endsWith(".")) {
                    includePackage = packageName.substring(0, packageName.length() - 1);
                }
                includePackage = packageName + attribute.getValue().trim();
                if (includePackage.endsWith(".*")) {
                    includePackage = includePackage.substring(0, includePackage.length() - 2);
                    break;
                }
                if (!includePackage.endsWith(".")) break;
                includePackage = includePackage.substring(0, includePackage.length() - 1);
                break;
            }
            if (includePackage.length() == 0) continue;
            definition.addIncludePackage(includePackage);
        }
    }

    private static void parseExcludePackageElements(Element root, SystemDefinition definition, String packageName) {
        Iterator it1 = root.elementIterator("exclude");
        while (it1.hasNext()) {
            String excludePackage = "";
            Element excludeElement = (Element)it1.next();
            Iterator it2 = excludeElement.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                if (!attribute.getName().trim().equalsIgnoreCase("package")) continue;
                if (packageName.endsWith(".*")) {
                    excludePackage = packageName.substring(0, packageName.length() - 2);
                } else if (packageName.endsWith(".")) {
                    excludePackage = packageName.substring(0, packageName.length() - 1);
                }
                excludePackage = packageName + attribute.getValue().trim();
                if (excludePackage.endsWith(".*")) {
                    excludePackage = excludePackage.substring(0, excludePackage.length() - 2);
                    break;
                }
                if (!excludePackage.endsWith(".")) break;
                excludePackage = excludePackage.substring(0, excludePackage.length() - 1);
                break;
            }
            if (excludePackage.length() == 0) continue;
            definition.addExcludePackage(excludePackage);
        }
    }

    public static void parsePrepareElements(Element root, SystemDefinition definition, String packageName) {
        Iterator it1 = root.elementIterator("prepare");
        while (it1.hasNext()) {
            String preparePackage = "";
            Element prepareElement = (Element)it1.next();
            Iterator it2 = prepareElement.attributeIterator();
            while (it2.hasNext()) {
                Attribute attribute = (Attribute)it2.next();
                if (!attribute.getName().trim().equals("package")) continue;
                if (packageName.endsWith(".*")) {
                    preparePackage = packageName.substring(0, packageName.length() - 2);
                } else if (packageName.endsWith(".")) {
                    preparePackage = packageName.substring(0, packageName.length() - 1);
                }
                preparePackage = packageName + attribute.getValue().trim();
                if (preparePackage.endsWith(".*")) {
                    preparePackage = preparePackage.substring(0, preparePackage.length() - 2);
                    break;
                }
                if (!preparePackage.endsWith(".")) break;
                preparePackage = preparePackage.substring(0, preparePackage.length() - 1);
                break;
            }
            if (preparePackage.length() == 0) continue;
            definition.addPreparePackage(preparePackage);
        }
    }

    private static String getBasePackage(Element system) {
        String basePackage = "";
        Iterator it2 = system.attributeIterator();
        while (it2.hasNext()) {
            Attribute attribute = (Attribute)it2.next();
            if (!attribute.getName().trim().equalsIgnoreCase("base-package")) continue;
            basePackage = attribute.getValue().trim();
            if (basePackage.endsWith(".*")) {
                basePackage = basePackage.substring(0, basePackage.length() - 1);
                break;
            }
            if (basePackage.endsWith(".")) break;
            basePackage = basePackage + ".";
            break;
        }
        return basePackage;
    }

    private static boolean matchMethodAsAdvice(MethodInfo method, String adviceSignature) {
        String[] signatureElements = Strings.extractMethodSignature(adviceSignature);
        if (!method.getName().equals(signatureElements[0])) {
            return false;
        }
        if (method.getParameterTypes().length * 2 != signatureElements.length - 1) {
            return signatureElements.length == 1 && method.getParameterTypes().length == 1 && (method.getParameterTypes()[0].getName().equals("org.codehaus.aspectwerkz.joinpoint.JoinPoint") || method.getParameterTypes()[0].getName().equals("org.codehaus.aspectwerkz.joinpoint.StaticJoinPoint"));
        }
        int argIndex = 0;
        for (int i = 1; i < signatureElements.length; ++i) {
            String paramType = signatureElements[i++];
            String methodParamType = method.getParameterTypes()[argIndex++].getName();
            String paramTypeResolved = (String)Pattern.ABBREVIATIONS.get(paramType);
            if (methodParamType.equals(paramType) || methodParamType.equals(paramTypeResolved)) continue;
            return false;
        }
        return true;
    }

    private static void handleAdvisableDefinition(SystemDefinition definition, String withinPointcut, String pointcutTypes) {
        definition.addMixinDefinition(DefinitionParserHelper.createAndAddMixinDefToSystemDef(AdvisableImpl.CLASS_INFO, withinPointcut, DeploymentModel.PER_INSTANCE, false, definition));
        boolean hasAllPointcuts = false;
        boolean hasExecutionPointcut = false;
        boolean hasCallPointcut = false;
        boolean hasSetPointcut = false;
        boolean hasGetPointcut = false;
        boolean hasHandlerPointcut = false;
        if (pointcutTypes == null || pointcutTypes.equals("") || pointcutTypes.equalsIgnoreCase("all")) {
            hasAllPointcuts = true;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(pointcutTypes, "|");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.trim().equalsIgnoreCase("all")) {
                    hasAllPointcuts = true;
                    break;
                }
                if (token.trim().equalsIgnoreCase("execution")) {
                    hasExecutionPointcut = true;
                    continue;
                }
                if (token.trim().equalsIgnoreCase("call")) {
                    hasCallPointcut = true;
                    continue;
                }
                if (token.trim().equalsIgnoreCase("set")) {
                    hasSetPointcut = true;
                    continue;
                }
                if (token.trim().equalsIgnoreCase("get")) {
                    hasGetPointcut = true;
                    continue;
                }
                if (!token.trim().equalsIgnoreCase("handler")) continue;
                hasHandlerPointcut = true;
            }
        }
        if (hasAllPointcuts || hasExecutionPointcut) {
            DefinitionParserHelper.createAndAddAdvisableDef("(execution(!static * *.*(..)) && " + withinPointcut + ')', definition);
        }
        if (hasAllPointcuts || hasCallPointcut) {
            DefinitionParserHelper.createAndAddAdvisableDef("(call(* *.*(..)) && withincode(!static * *.*(..)) && " + withinPointcut + ')', definition);
        }
        if (hasAllPointcuts || hasSetPointcut) {
            DefinitionParserHelper.createAndAddAdvisableDef("(set(* *.*) && withincode(!static * *.*(..)) && " + withinPointcut + ')', definition);
        }
        if (hasAllPointcuts || hasGetPointcut) {
            DefinitionParserHelper.createAndAddAdvisableDef("(get(* *.*) && withincode(!static * *.*(..))  && " + withinPointcut + ')', definition);
        }
        if (hasAllPointcuts || hasHandlerPointcut) {
            DefinitionParserHelper.createAndAddAdvisableDef("(handler(*..*) && withincode(!static * *.*(..))  && " + withinPointcut + ')', definition);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PointcutInfo {
        public String name;
        public String expression;

        private PointcutInfo() {
        }
    }
}

