/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.compiler;

import java.io.File;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.FilenameSelector;

public class Utility {
    private Project project = new Project();
    private BuildLogger logger = new DefaultLogger();
    private boolean verbose = false;

    public Utility() {
        this.logger.setMessageOutputLevel(0);
        this.logger.setOutputPrintStream(System.out);
        this.logger.setErrorPrintStream(System.err);
        this.project.addBuildListener((BuildListener)this.logger);
    }

    public void setVerbose(boolean verbose) {
        if (verbose) {
            this.logger.setMessageOutputLevel(2);
            verbose = true;
        } else {
            this.logger.setMessageOutputLevel(-1);
            verbose = false;
        }
    }

    public void deleteDir(File dir) {
        Delete task = new Delete();
        task.setProject(this.project);
        task.setTaskName("delete");
        FilenameSelector fns = new FilenameSelector();
        fns.setName("**/*");
        FileSet fs = new FileSet();
        fs.setDir(dir);
        fs.addFilename(fns);
        task.addFileset(fs);
        task.setIncludeEmptyDirs(true);
        task.perform();
        dir.delete();
    }

    public void backupFile(File source, File dest) {
        Copy task = new Copy();
        task.setProject(this.project);
        task.setTaskName("backup");
        task.setVerbose(this.verbose);
        if (source.isDirectory()) {
            FilenameSelector fns = new FilenameSelector();
            fns.setName("**/*");
            FileSet fs = new FileSet();
            fs.setDir(source);
            fs.addFilename(fns);
            task.addFileset(fs);
            task.setTodir(dest);
            task.setIncludeEmptyDirs(true);
        } else {
            task.setFile(source);
            task.setTofile(dest);
        }
        task.setOverwrite(true);
        task.setPreserveLastModified(true);
        task.execute();
    }

    public void log(String msg) {
        this.project.log(msg);
    }
}

