/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.transform.inlining.weaver;

import gnu.trove.TIntObjectHashMap;
import gnu.trove.TLongObjectHashMap;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import org.codehaus.aspectwerkz.annotation.instrumentation.asm.AsmAnnotationHelper;
import org.codehaus.aspectwerkz.definition.SystemDefinition;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.PointcutType;
import org.codehaus.aspectwerkz.org.objectweb.asm.Attribute;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.ClassVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeAdapter;
import org.codehaus.aspectwerkz.org.objectweb.asm.CodeVisitor;
import org.codehaus.aspectwerkz.org.objectweb.asm.Label;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ConstructorInfo;
import org.codehaus.aspectwerkz.reflect.MemberInfo;
import org.codehaus.aspectwerkz.reflect.impl.asm.AsmClassInfo;
import org.codehaus.aspectwerkz.transform.Context;
import org.codehaus.aspectwerkz.transform.TransformationConstants;
import org.codehaus.aspectwerkz.transform.TransformationUtil;
import org.codehaus.aspectwerkz.transform.inlining.AsmHelper;
import org.codehaus.aspectwerkz.transform.inlining.ContextImpl;
import org.codehaus.aspectwerkz.transform.inlining.EmittedJoinPoint;
import org.codehaus.aspectwerkz.transform.inlining.weaver.AfterObjectInitializationCodeAdapter;

public class ConstructorCallVisitor
extends ClassAdapter
implements TransformationConstants {
    private static final TIntObjectHashMap EMPTY_INTHASHMAP = new TIntObjectHashMap(0);
    private final ContextImpl m_ctx;
    private final ClassLoader m_loader;
    private final ClassInfo m_callerClassInfo;
    private final TLongObjectHashMap m_newInvocationsByCallerMemberHash;
    private Label m_lastLabelForLineNumber = EmittedJoinPoint.NO_LINE_NUMBER;

    public ConstructorCallVisitor(ClassVisitor cv, ClassLoader loader, ClassInfo classInfo, Context ctx, TLongObjectHashMap newInvocationsByCallerMemberHash) {
        super(cv);
        this.m_loader = loader;
        this.m_callerClassInfo = classInfo;
        this.m_ctx = (ContextImpl)ctx;
        this.m_newInvocationsByCallerMemberHash = newInvocationsByCallerMemberHash;
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        if (name.startsWith("aw$") || Modifier.isNative(access) || Modifier.isAbstract(access)) {
            return super.visitMethod(access, name, desc, exceptions, attrs);
        }
        CodeVisitor mv = this.cv.visitMethod(access, name, desc, exceptions, attrs);
        return mv == null ? null : new ReplaceNewInstructionCodeAdapter(mv, this.m_loader, this.m_callerClassInfo, this.m_ctx.getClassName(), name, desc, (TIntObjectHashMap)this.m_newInvocationsByCallerMemberHash.get(ConstructorCallVisitor.getMemberHash(name, desc)));
    }

    private static int getMemberHash(String name, String desc) {
        int hash = 29;
        hash = 29 * hash + name.hashCode();
        return 29 * hash + desc.hashCode();
    }

    private static class NewInvocationStruct {
        public String className;
        public String ctorDesc;
        public ConstructorInfo constructorInfo = null;
        public int joinPointHash = -1;

        private NewInvocationStruct() {
        }
    }

    public static class LookaheadNewDupInvokeSpecialInstructionCodeAdapter
    extends AfterObjectInitializationCodeAdapter {
        private TIntObjectHashMap m_newInvocations;
        private Stack m_newIndexStack = new Stack();
        private int m_newIndex = -1;

        public LookaheadNewDupInvokeSpecialInstructionCodeAdapter(CodeVisitor cv, TIntObjectHashMap newInvocations, String callerMemberName) {
            super(cv, callerMemberName);
            this.m_newInvocations = newInvocations;
        }

        public void visitTypeInsn(int opcode, String desc) {
            super.visitTypeInsn(opcode, desc);
            if (opcode == 187) {
                ++this.m_newIndex;
                this.m_newIndexStack.push(new Integer(this.m_newIndex));
            }
        }

        public void visitMethodInsn(int opcode, String calleeClassName, String calleeMethodName, String calleeMethodDesc) {
            super.visitMethodInsn(opcode, calleeClassName, calleeMethodName, calleeMethodDesc);
            if ("<init>".equals(calleeMethodName) && opcode == 183) {
                if (!this.m_isObjectInitialized) {
                    if (!this.m_newIndexStack.isEmpty()) {
                        this.m_newIndexStack.pop();
                    }
                } else if (!this.m_newIndexStack.isEmpty()) {
                    int index = (Integer)this.m_newIndexStack.pop();
                    NewInvocationStruct newInvocationStruct = new NewInvocationStruct();
                    newInvocationStruct.className = calleeClassName;
                    newInvocationStruct.ctorDesc = calleeMethodDesc;
                    this.m_newInvocations.put(index, newInvocationStruct);
                }
            }
        }
    }

    public static class LookaheadNewDupInvokeSpecialInstructionClassAdapter
    extends AsmAnnotationHelper.NullClassAdapter {
        private String m_callerMemberName;
        public TLongObjectHashMap m_newInvocationsByCallerMemberHash;

        public LookaheadNewDupInvokeSpecialInstructionClassAdapter(TLongObjectHashMap newInvocations) {
            this.m_newInvocationsByCallerMemberHash = newInvocations;
        }

        public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
            if (name.startsWith("aw$") || Modifier.isNative(access) || Modifier.isAbstract(access)) {
                // empty if block
            }
            this.m_callerMemberName = name;
            TIntObjectHashMap newInvocations = new TIntObjectHashMap(5);
            this.m_newInvocationsByCallerMemberHash.put(ConstructorCallVisitor.getMemberHash(name, desc), newInvocations);
            return new LookaheadNewDupInvokeSpecialInstructionCodeAdapter(super.visitMethod(access, name, desc, exceptions, attrs), newInvocations, this.m_callerMemberName);
        }
    }

    public class ReplaceNewInstructionCodeAdapter
    extends CodeAdapter {
        private final ClassLoader m_loader;
        private final ClassInfo m_callerClassInfo;
        private final String m_callerClassName;
        private final String m_callerMethodName;
        private final String m_callerMethodDesc;
        private final MemberInfo m_callerMemberInfo;
        private final TIntObjectHashMap m_newInvocations;
        private int m_newInvocationIndex = -1;
        private final Stack m_newInvocationStructStack = new Stack();
        private boolean m_skipNextDup = false;

        public ReplaceNewInstructionCodeAdapter(CodeVisitor ca, ClassLoader loader, ClassInfo callerClassInfo, String callerClassName, String callerMethodName, String callerMethodDesc, TIntObjectHashMap newInvocations) {
            super(ca);
            this.m_loader = loader;
            this.m_callerClassInfo = callerClassInfo;
            this.m_callerClassName = callerClassName;
            this.m_callerMethodName = callerMethodName;
            this.m_callerMethodDesc = callerMethodDesc;
            TIntObjectHashMap tIntObjectHashMap = this.m_newInvocations = newInvocations != null ? newInvocations : EMPTY_INTHASHMAP;
            if ("<clinit>".equals(this.m_callerMethodName)) {
                this.m_callerMemberInfo = this.m_callerClassInfo.staticInitializer();
            } else if ("<init>".equals(this.m_callerMethodName)) {
                int hash = AsmHelper.calculateConstructorHash(this.m_callerMethodDesc);
                this.m_callerMemberInfo = this.m_callerClassInfo.getConstructor(hash);
            } else {
                int hash = AsmHelper.calculateMethodHash(this.m_callerMethodName, this.m_callerMethodDesc);
                this.m_callerMemberInfo = this.m_callerClassInfo.getMethod(hash);
            }
            if (this.m_callerMemberInfo == null) {
                System.err.println("AW::WARNING metadata structure could not be build for method [" + this.m_callerClassInfo.getName().replace('/', '.') + '.' + this.m_callerMethodName + ':' + this.m_callerMethodDesc + ']');
            }
        }

        public void visitLabel(Label label) {
            ConstructorCallVisitor.this.m_lastLabelForLineNumber = label;
            super.visitLabel(label);
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (this.m_callerMemberInfo == null) {
                return;
            }
            if (opcode == 187) {
                ++this.m_newInvocationIndex;
                NewInvocationStruct newInvocationStruct = (NewInvocationStruct)this.m_newInvocations.get(this.m_newInvocationIndex);
                if (newInvocationStruct == null) {
                    super.visitTypeInsn(opcode, desc);
                    return;
                }
                String calleeClassName = newInvocationStruct.className;
                String calleeMethodName = "<init>";
                String calleeMethodDesc = newInvocationStruct.ctorDesc;
                int joinPointHash = AsmHelper.calculateMethodHash(calleeMethodName, calleeMethodDesc);
                ClassInfo classInfo = AsmClassInfo.getClassInfo(calleeClassName, this.m_loader);
                ConstructorInfo calleeConstructorInfo = classInfo.getConstructor(joinPointHash);
                if (calleeConstructorInfo == null) {
                    super.visitTypeInsn(opcode, desc);
                    System.err.println("AW::WARNING metadata structure could not be build for method [" + classInfo.getName().replace('/', '.') + '.' + calleeMethodName + ':' + calleeMethodDesc + ']');
                    return;
                }
                ExpressionContext ctx = new ExpressionContext(PointcutType.CALL, calleeConstructorInfo, this.m_callerMemberInfo);
                if (this.constructorFilter(ConstructorCallVisitor.this.m_ctx.getDefinitions(), ctx, calleeConstructorInfo)) {
                    this.m_newInvocationStructStack.push(null);
                    super.visitTypeInsn(opcode, desc);
                } else {
                    newInvocationStruct.constructorInfo = calleeConstructorInfo;
                    newInvocationStruct.joinPointHash = joinPointHash;
                    this.m_newInvocationStructStack.push(newInvocationStruct);
                    this.m_skipNextDup = true;
                }
            } else {
                super.visitTypeInsn(opcode, desc);
            }
        }

        public void visitInsn(int opcode) {
            if ((opcode == 89 || opcode == 90) && this.m_skipNextDup) {
                if (opcode == 90) {
                    super.visitInsn(89);
                }
            } else {
                super.visitInsn(opcode);
            }
            this.m_skipNextDup = false;
        }

        public void visitMethodInsn(int opcode, String calleeClassName, String calleeConstructorName, String calleeConstructorDesc) {
            if (this.m_callerMemberInfo == null) {
                super.visitMethodInsn(opcode, calleeClassName, calleeConstructorName, calleeConstructorDesc);
                return;
            }
            if (!"<init>".equals(calleeConstructorName) || calleeClassName.endsWith("___AW_JoinPoint")) {
                super.visitMethodInsn(opcode, calleeClassName, calleeConstructorName, calleeConstructorDesc);
                return;
            }
            if (this.m_newInvocationStructStack.isEmpty()) {
                super.visitMethodInsn(opcode, calleeClassName, calleeConstructorName, calleeConstructorDesc);
                return;
            }
            NewInvocationStruct struct = (NewInvocationStruct)this.m_newInvocationStructStack.pop();
            if (struct == null) {
                super.visitMethodInsn(opcode, calleeClassName, calleeConstructorName, calleeConstructorDesc);
            } else {
                ConstructorCallVisitor.this.m_ctx.markAsAdvised();
                String joinPointClassName = TransformationUtil.getJoinPointClassName(this.m_callerClassName, this.m_callerMethodName, this.m_callerMethodDesc, calleeClassName, 4, struct.joinPointHash);
                if (Modifier.isStatic(this.m_callerMemberInfo.getModifiers())) {
                    this.visitInsn(1);
                } else {
                    this.visitVarInsn(25, 0);
                }
                super.visitMethodInsn(184, joinPointClassName, "invoke", TransformationUtil.getInvokeSignatureForConstructorCallJoinPoints(calleeConstructorDesc, this.m_callerClassName, calleeClassName));
                ConstructorCallVisitor.this.m_ctx.addEmittedJoinPoint(new EmittedJoinPoint(4, this.m_callerClassName, this.m_callerMethodName, this.m_callerMethodDesc, this.m_callerMemberInfo.getModifiers(), calleeClassName, calleeConstructorName, calleeConstructorDesc, struct.constructorInfo.getModifiers(), struct.joinPointHash, joinPointClassName, ConstructorCallVisitor.this.m_lastLabelForLineNumber));
            }
        }

        public boolean constructorFilter(Set definitions, ExpressionContext ctx, ConstructorInfo calleeConstructorInfo) {
            Iterator it = definitions.iterator();
            while (it.hasNext()) {
                if (!((SystemDefinition)it.next()).hasPointcut(ctx)) continue;
                return false;
            }
            return true;
        }
    }
}

