/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.expression;

import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.annotation.AnnotationInfo;
import org.codehaus.aspectwerkz.expression.ExpressionContext;
import org.codehaus.aspectwerkz.expression.ExpressionInfo;
import org.codehaus.aspectwerkz.expression.ExpressionNamespace;
import org.codehaus.aspectwerkz.expression.ExpressionVisitor;
import org.codehaus.aspectwerkz.expression.ast.ASTArgParameter;
import org.codehaus.aspectwerkz.expression.ast.ASTArgs;
import org.codehaus.aspectwerkz.expression.ast.ASTAttribute;
import org.codehaus.aspectwerkz.expression.ast.ASTCall;
import org.codehaus.aspectwerkz.expression.ast.ASTCflow;
import org.codehaus.aspectwerkz.expression.ast.ASTCflowBelow;
import org.codehaus.aspectwerkz.expression.ast.ASTConstructorPattern;
import org.codehaus.aspectwerkz.expression.ast.ASTExecution;
import org.codehaus.aspectwerkz.expression.ast.ASTExpression;
import org.codehaus.aspectwerkz.expression.ast.ASTFieldPattern;
import org.codehaus.aspectwerkz.expression.ast.ASTGet;
import org.codehaus.aspectwerkz.expression.ast.ASTHandler;
import org.codehaus.aspectwerkz.expression.ast.ASTMethodPattern;
import org.codehaus.aspectwerkz.expression.ast.ASTModifier;
import org.codehaus.aspectwerkz.expression.ast.ASTNot;
import org.codehaus.aspectwerkz.expression.ast.ASTParameter;
import org.codehaus.aspectwerkz.expression.ast.ASTPointcutReference;
import org.codehaus.aspectwerkz.expression.ast.ASTRoot;
import org.codehaus.aspectwerkz.expression.ast.ASTSet;
import org.codehaus.aspectwerkz.expression.ast.ASTStaticInitialization;
import org.codehaus.aspectwerkz.expression.ast.ASTTarget;
import org.codehaus.aspectwerkz.expression.ast.ASTThis;
import org.codehaus.aspectwerkz.expression.ast.ASTWithin;
import org.codehaus.aspectwerkz.expression.ast.ASTWithinCode;
import org.codehaus.aspectwerkz.expression.ast.ExpressionParserVisitor;
import org.codehaus.aspectwerkz.expression.ast.Node;
import org.codehaus.aspectwerkz.expression.ast.SimpleNode;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.reflect.ConstructorInfo;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.MemberInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.reflect.ReflectionInfo;
import org.codehaus.aspectwerkz.reflect.StaticInitializationInfo;
import org.codehaus.aspectwerkz.util.Util;

public class AdvisedClassFilterExpressionVisitor
extends ExpressionVisitor
implements ExpressionParserVisitor {
    public AdvisedClassFilterExpressionVisitor(ExpressionInfo expressionInfo, String expression, String namespace, Node root) {
        super(expressionInfo, expression, namespace, root);
    }

    public Object visit(SimpleNode node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTRoot node, Object data) {
        Node child = node.jjtGetChild(0);
        Boolean match = (Boolean)child.jjtAccept(this, data);
        return match;
    }

    public Object visit(ASTExpression node, Object data) {
        Node child = node.jjtGetChild(0);
        Boolean match = (Boolean)child.jjtAccept(this, data);
        return match;
    }

    public Object visit(ASTNot node, Object data) {
        return super.visit(node, data);
    }

    public Object visit(ASTPointcutReference node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        ExpressionNamespace namespace = ExpressionNamespace.getNamespace(this.m_namespace);
        AdvisedClassFilterExpressionVisitor expression = namespace.getAdvisedClassExpression(node.getName());
        return expression.matchUndeterministic(context);
    }

    public Object visit(ASTExecution node, Object data) {
        boolean checkPattern;
        ExpressionContext context = (ExpressionContext)data;
        Node patternNode = node.jjtGetChild(node.jjtGetNumChildren() - 1);
        boolean bl = checkPattern = !(patternNode instanceof ASTAttribute);
        if (checkPattern) {
            if (context.hasWithinPointcut() || context.hasExecutionPointcut()) {
                if (context.hasExecutionPointcut()) {
                    return patternNode.jjtAccept(this, context.getReflectionInfo());
                }
                return patternNode.jjtAccept(this, context.getWithinReflectionInfo());
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public Object visit(ASTCall node, Object data) {
        boolean checkPattern;
        ExpressionContext context = (ExpressionContext)data;
        Node patternNode = node.jjtGetChild(node.jjtGetNumChildren() - 1);
        boolean bl = checkPattern = !(patternNode instanceof ASTAttribute);
        if (checkPattern) {
            if (context.hasWithinPointcut() || context.hasCallPointcut()) {
                if (context.hasReflectionInfo()) {
                    return patternNode.jjtAccept(this, context.getReflectionInfo());
                }
                return null;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public Object visit(ASTSet node, Object data) {
        boolean checkPattern;
        ExpressionContext context = (ExpressionContext)data;
        Node patternNode = node.jjtGetChild(node.jjtGetNumChildren() - 1);
        boolean bl = checkPattern = !(patternNode instanceof ASTAttribute);
        if (checkPattern) {
            if (context.hasWithinPointcut() || context.hasSetPointcut()) {
                if (context.hasReflectionInfo()) {
                    return patternNode.jjtAccept(this, context.getReflectionInfo());
                }
                return null;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public Object visit(ASTGet node, Object data) {
        boolean checkPattern;
        ExpressionContext context = (ExpressionContext)data;
        Node patternNode = node.jjtGetChild(node.jjtGetNumChildren() - 1);
        boolean bl = checkPattern = !(patternNode instanceof ASTAttribute);
        if (checkPattern) {
            if (context.hasWithinPointcut() || context.hasGetPointcut()) {
                if (context.hasReflectionInfo()) {
                    return patternNode.jjtAccept(this, context.getReflectionInfo());
                }
                return null;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public Object visit(ASTHandler node, Object data) {
        return null;
    }

    public Object visit(ASTStaticInitialization node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        if (context.hasStaticInitializationPointcut() && context.hasWithinReflectionInfo()) {
            ReflectionInfo reflectInfo = context.getWithinReflectionInfo();
            if (reflectInfo instanceof StaticInitializationInfo) {
                reflectInfo = ((StaticInitializationInfo)reflectInfo).getDeclaringType();
            }
            if (reflectInfo instanceof ClassInfo) {
                Boolean matchPattern;
                Node patternNode = node.jjtGetChild(node.jjtGetNumChildren() - 1);
                if (!(patternNode instanceof ASTAttribute) && Boolean.FALSE.equals(matchPattern = (Boolean)patternNode.jjtAccept(this, reflectInfo))) {
                    return Boolean.FALSE;
                }
                boolean matchedAnnotations = this.visitAttributes(node, reflectInfo);
                if (!matchedAnnotations) {
                    return Boolean.FALSE;
                }
                return null;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTWithinCode node, Object data) {
        boolean checkPattern;
        ExpressionContext context = (ExpressionContext)data;
        ReflectionInfo withinInfo = context.getWithinReflectionInfo();
        if (node.isStaticInitializer()) {
            ASTWithin fastNode = new ASTWithin(0);
            for (int i = 0; i < node.jjtGetChild(0).jjtGetNumChildren(); ++i) {
                fastNode.jjtAddChild(node.jjtGetChild(0).jjtGetChild(i), i);
            }
            return super.visit(fastNode, data);
        }
        Node patternNode = node.jjtGetChild(node.jjtGetNumChildren() - 1);
        boolean bl = checkPattern = !(patternNode instanceof ASTAttribute);
        if (checkPattern) {
            if (withinInfo instanceof MemberInfo) {
                return patternNode.jjtAccept(this, withinInfo);
            }
            if (withinInfo instanceof ClassInfo) {
                Boolean matchDeclaringType = (Boolean)patternNode.jjtAccept(this, withinInfo);
                if (Boolean.FALSE.equals(matchDeclaringType)) {
                    return Boolean.FALSE;
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public Object visit(ASTCflow node, Object data) {
        return null;
    }

    public Object visit(ASTCflowBelow node, Object data) {
        return null;
    }

    public Object visit(ASTArgs node, Object data) {
        return null;
    }

    public Object visit(ASTTarget node, Object data) {
        return null;
    }

    public Object visit(ASTThis node, Object data) {
        ExpressionContext context = (ExpressionContext)data;
        if (context.hasWithinReflectionInfo()) {
            ReflectionInfo withinInfo = context.getWithinReflectionInfo();
            if (withinInfo instanceof MemberInfo) {
                return Util.booleanValueOf(ClassInfoHelper.instanceOf(((MemberInfo)withinInfo).getDeclaringType(), node.getBoundedType(this.m_expressionInfo)));
            }
            if (withinInfo instanceof ClassInfo) {
                return Util.booleanValueOf(ClassInfoHelper.instanceOf((ClassInfo)withinInfo, node.getBoundedType(this.m_expressionInfo)));
            }
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTMethodPattern node, Object data) {
        if (data instanceof ClassInfo) {
            ClassInfo classInfo = (ClassInfo)data;
            if (node.getDeclaringTypePattern().matchType(classInfo)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (data instanceof MethodInfo) {
            MethodInfo methodInfo = (MethodInfo)data;
            if (node.getDeclaringTypePattern().matchType(methodInfo.getDeclaringType())) {
                return null;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTConstructorPattern node, Object data) {
        if (data instanceof ClassInfo) {
            ClassInfo classInfo = (ClassInfo)data;
            if (node.getDeclaringTypePattern().matchType(classInfo)) {
                return Boolean.TRUE;
            }
        } else if (data instanceof ConstructorInfo) {
            ConstructorInfo constructorInfo = (ConstructorInfo)data;
            if (node.getDeclaringTypePattern().matchType(constructorInfo.getDeclaringType())) {
                return null;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTFieldPattern node, Object data) {
        if (data instanceof ClassInfo) {
            ClassInfo classInfo = (ClassInfo)data;
            if (node.getDeclaringTypePattern().matchType(classInfo)) {
                return Boolean.TRUE;
            }
        } else if (data instanceof FieldInfo) {
            FieldInfo fieldInfo = (FieldInfo)data;
            if (node.getDeclaringTypePattern().matchType(fieldInfo.getDeclaringType())) {
                return null;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTParameter node, Object data) {
        ClassInfo parameterType = (ClassInfo)data;
        if (node.getDeclaringClassPattern().matchType(parameterType)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTArgParameter node, Object data) {
        return Boolean.TRUE;
    }

    public Object visit(ASTAttribute node, Object data) {
        boolean matchAnnotation = false;
        List annotations = (List)data;
        Iterator it = annotations.iterator();
        while (it.hasNext()) {
            AnnotationInfo annotation = (AnnotationInfo)it.next();
            if (!annotation.getName().equals(node.getName())) continue;
            matchAnnotation = true;
        }
        if (node.isNot()) {
            return Util.booleanValueOf(!matchAnnotation);
        }
        return Util.booleanValueOf(matchAnnotation);
    }

    public Object visit(ASTModifier node, Object data) {
        return null;
    }

    public String toString() {
        return this.m_expression;
    }
}

