/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.annotation.expression;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.aspectwerkz.annotation.AnnotationElement;
import org.codehaus.aspectwerkz.annotation.AnnotationManager;
import org.codehaus.aspectwerkz.annotation.expression.ast.ASTAnnotation;
import org.codehaus.aspectwerkz.annotation.expression.ast.ASTArray;
import org.codehaus.aspectwerkz.annotation.expression.ast.ASTBoolean;
import org.codehaus.aspectwerkz.annotation.expression.ast.ASTChar;
import org.codehaus.aspectwerkz.annotation.expression.ast.ASTFloat;
import org.codehaus.aspectwerkz.annotation.expression.ast.ASTHex;
import org.codehaus.aspectwerkz.annotation.expression.ast.ASTIdentifier;
import org.codehaus.aspectwerkz.annotation.expression.ast.ASTInteger;
import org.codehaus.aspectwerkz.annotation.expression.ast.ASTKeyValuePair;
import org.codehaus.aspectwerkz.annotation.expression.ast.ASTOct;
import org.codehaus.aspectwerkz.annotation.expression.ast.ASTRoot;
import org.codehaus.aspectwerkz.annotation.expression.ast.ASTString;
import org.codehaus.aspectwerkz.annotation.expression.ast.AnnotationParser;
import org.codehaus.aspectwerkz.annotation.expression.ast.AnnotationParserVisitor;
import org.codehaus.aspectwerkz.annotation.expression.ast.ParseException;
import org.codehaus.aspectwerkz.annotation.expression.ast.SimpleNode;
import org.codehaus.aspectwerkz.exception.WrappedRuntimeException;
import org.codehaus.aspectwerkz.org.objectweb.asm.Type;
import org.codehaus.aspectwerkz.util.Strings;

public class AnnotationVisitor
implements AnnotationParserVisitor {
    protected static final AnnotationParser PARSER = new AnnotationParser(System.in);
    protected Map m_annotationElementValueHoldersByName;
    protected Class m_annotationClass;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;

    public AnnotationVisitor(Map annotationElementValueHoldersByName, Class annotationClass) {
        this.m_annotationElementValueHoldersByName = annotationElementValueHoldersByName;
        this.m_annotationClass = annotationClass;
    }

    public static void parse(Map annotationElements, String annotationRepresentation, Class annotationClass) {
        try {
            ASTRoot root = PARSER.parse(annotationRepresentation);
            new AnnotationVisitor(annotationElements, annotationClass).visit(root, null);
        }
        catch (ParseException e) {
            throw new WrappedRuntimeException("cannot parse annotation [" + annotationRepresentation + "]", e);
        }
    }

    public Object visit(SimpleNode node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTRoot node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, data);
    }

    public Object visit(ASTAnnotation node, Object data) {
        int nr = node.jjtGetNumChildren();
        if (nr == 1 && !(node.jjtGetChild(0) instanceof ASTKeyValuePair)) {
            Object value = node.jjtGetChild(0).jjtAccept(this, data);
            if (!(node.jjtGetChild(0) instanceof ASTAnnotation)) {
                this.m_annotationElementValueHoldersByName.put("value", new AnnotationElement("value", value));
            }
        } else {
            for (int i = 0; i < nr; ++i) {
                node.jjtGetChild(i).jjtAccept(this, data);
            }
        }
        return null;
    }

    public Object visit(ASTKeyValuePair node, Object data) {
        String elementName = node.getKey();
        MethodInfo elementMethod = this.getMethodInfo(elementName);
        if (node.jjtGetChild(0) instanceof ASTAnnotation) {
            HashMap nestedAnnotationElementValueHoldersByName = new HashMap();
            AnnotationVisitor nestedAnnotationVisitor = new AnnotationVisitor(nestedAnnotationElementValueHoldersByName, elementMethod.elementType);
            nestedAnnotationVisitor.visit((ASTAnnotation)node.jjtGetChild(0), data);
            this.m_annotationElementValueHoldersByName.put(elementName, new AnnotationElement(elementName, AnnotationManager.instantiateNestedAnnotation(elementMethod.elementType, nestedAnnotationElementValueHoldersByName)));
        } else {
            Object typedValue = node.jjtGetChild(0).jjtAccept(this, elementMethod);
            this.m_annotationElementValueHoldersByName.put(elementName, new AnnotationElement(elementName, typedValue));
        }
        return null;
    }

    public Object visit(ASTArray node, Object data) {
        MethodInfo methodInfo = (MethodInfo)data;
        Class elementType = methodInfo.elementType;
        if (!elementType.isArray()) {
            throw new RuntimeException("type for element [" + methodInfo.elementMethod.getName() + "] is not of type array");
        }
        Class<?> componentType = elementType.getComponentType();
        if (componentType.isArray()) {
            throw new UnsupportedOperationException("multidimensional arrays are not supported for element type, was required method [" + methodInfo.elementMethod.getName() + "]");
        }
        return this.createTypedArray(node, data, node.jjtGetNumChildren(), componentType);
    }

    public Object visit(ASTIdentifier node, Object data) {
        String identifier = node.getValue();
        if (identifier.endsWith(".class")) {
            return this.handleClassIdentifier(identifier);
        }
        if (this.isJavaReferenceType(identifier)) {
            return this.handleReferenceIdentifier(identifier);
        }
        throw new RuntimeException("unsupported format for java type or reference [" + identifier + "]");
    }

    public Object visit(ASTBoolean node, Object data) {
        return Boolean.valueOf(node.getValue());
    }

    public Object visit(ASTChar node, Object data) {
        return new Character(node.getValue().charAt(0));
    }

    public Object visit(ASTString node, Object data) {
        if (node.getValue().length() >= 2) {
            String escaped = node.getValue().substring(1, node.getValue().length() - 1);
            return Strings.replaceSubString(escaped, "\\\"", "\"");
        }
        return node.getValue();
    }

    public Object visit(ASTInteger node, Object data) {
        String value = node.getValue();
        char lastChar = value.charAt(value.length() - 1);
        if (lastChar == 'L' || lastChar == 'l') {
            return new Long(value.substring(0, value.length() - 1));
        }
        if (value.length() > 9) {
            return new Long(value);
        }
        return new Integer(value);
    }

    public Object visit(ASTFloat node, Object data) {
        String value = node.getValue();
        char lastChar = value.charAt(value.length() - 1);
        if (lastChar == 'D' || lastChar == 'd') {
            return new Double(value.substring(0, value.length() - 1));
        }
        if (lastChar == 'F' || lastChar == 'f') {
            return new Float(value.substring(0, value.length() - 1));
        }
        return new Double(value);
    }

    public Object visit(ASTHex node, Object data) {
        throw new UnsupportedOperationException("hex numbers not yet supported");
    }

    public Object visit(ASTOct node, Object data) {
        throw new UnsupportedOperationException("octal numbers not yet supported");
    }

    private MethodInfo getMethodInfo(String elementName) {
        StringBuffer javaBeanMethodPostfix = new StringBuffer();
        javaBeanMethodPostfix.append(elementName.substring(0, 1).toUpperCase());
        if (elementName.length() > 1) {
            javaBeanMethodPostfix.append(elementName.substring(1));
        }
        MethodInfo methodInfo = new MethodInfo();
        Method[] methods = this.m_annotationClass.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method elementMethod = methods[i];
            if (!elementMethod.getName().equals(elementName)) continue;
            methodInfo.elementMethod = elementMethod;
            methodInfo.elementType = elementMethod.getReturnType();
            break;
        }
        if (methodInfo.elementMethod == null) {
            throw new RuntimeException("method for the annotation element [" + elementName + "] can not be found in annotation interface [" + this.m_annotationClass.getName() + "]");
        }
        return methodInfo;
    }

    private boolean isJavaReferenceType(String valueAsString) {
        int first = valueAsString.indexOf(46);
        int last = valueAsString.lastIndexOf(46);
        int comma = valueAsString.indexOf(44);
        return first > 0 && last > 0 && first != last && comma < 0;
    }

    private Object createTypedArray(ASTArray node, Object data, int nrOfElements, Class componentType) {
        if (componentType.equals(class$java$lang$String == null ? (class$java$lang$String = AnnotationVisitor.class$("java.lang.String")) : class$java$lang$String)) {
            String[] array = new String[nrOfElements];
            for (int i = 0; i < nrOfElements; ++i) {
                String value;
                array[i] = value = (String)node.jjtGetChild(i).jjtAccept(this, data);
            }
            return array;
        }
        if (componentType.equals(Long.TYPE)) {
            long[] array = new long[nrOfElements];
            for (int i = 0; i < nrOfElements; ++i) {
                array[i] = (Long)node.jjtGetChild(i).jjtAccept(this, data);
            }
            return array;
        }
        if (componentType.equals(Integer.TYPE)) {
            int[] array = new int[nrOfElements];
            for (int i = 0; i < nrOfElements; ++i) {
                array[i] = (Integer)node.jjtGetChild(i).jjtAccept(this, data);
            }
            return array;
        }
        if (componentType.equals(Short.TYPE)) {
            short[] array = new short[nrOfElements];
            for (int i = 0; i < nrOfElements; ++i) {
                array[i] = (Short)node.jjtGetChild(i).jjtAccept(this, data);
            }
            return array;
        }
        if (componentType.equals(Double.TYPE)) {
            double[] array = new double[nrOfElements];
            for (int i = 0; i < nrOfElements; ++i) {
                array[i] = (Double)node.jjtGetChild(i).jjtAccept(this, data);
            }
            return array;
        }
        if (componentType.equals(Float.TYPE)) {
            float[] array = new float[nrOfElements];
            for (int i = 0; i < nrOfElements; ++i) {
                array[i] = ((Float)node.jjtGetChild(i).jjtAccept(this, data)).floatValue();
            }
            return array;
        }
        if (componentType.equals(Byte.TYPE)) {
            byte[] array = new byte[nrOfElements];
            for (int i = 0; i < nrOfElements; ++i) {
                array[i] = (Byte)node.jjtGetChild(i).jjtAccept(this, data);
            }
            return array;
        }
        if (componentType.equals(Character.TYPE)) {
            char[] array = new char[nrOfElements];
            for (int i = 0; i < nrOfElements; ++i) {
                array[i] = ((Character)node.jjtGetChild(i).jjtAccept(this, data)).charValue();
            }
            return array;
        }
        if (componentType.equals(Boolean.TYPE)) {
            boolean[] array = new boolean[nrOfElements];
            for (int i = 0; i < nrOfElements; ++i) {
                array[i] = (Boolean)node.jjtGetChild(i).jjtAccept(this, data);
            }
            return array;
        }
        if (componentType.equals(class$java$lang$Class == null ? (class$java$lang$Class = AnnotationVisitor.class$("java.lang.Class")) : class$java$lang$Class)) {
            AnnotationElement.LazyClass[] array = new AnnotationElement.LazyClass[nrOfElements];
            for (int i = 0; i < nrOfElements; ++i) {
                array[i] = (AnnotationElement.LazyClass)node.jjtGetChild(i).jjtAccept(this, data);
            }
            return array;
        }
        if (nrOfElements > 1 && node.jjtGetChild(0) instanceof ASTAnnotation) {
            Object[] nestedTyped = (Object[])Array.newInstance(componentType, nrOfElements);
            for (int i = 0; i < nrOfElements; ++i) {
                HashMap nestedAnnotationElementValueHoldersByName = new HashMap();
                AnnotationVisitor nestedAnnotationVisitor = new AnnotationVisitor(nestedAnnotationElementValueHoldersByName, componentType);
                nestedAnnotationVisitor.visit((ASTAnnotation)node.jjtGetChild(i), data);
                nestedTyped[i] = AnnotationManager.instantiateNestedAnnotation(componentType, nestedAnnotationElementValueHoldersByName);
            }
            return nestedTyped;
        }
        Object[] array = new Object[nrOfElements];
        for (int i = 0; i < nrOfElements; ++i) {
            array[i] = node.jjtGetChild(i).jjtAccept(this, data);
        }
        return array;
    }

    private Object handleClassIdentifier(String identifier) {
        int index = identifier.lastIndexOf(46);
        String className = identifier.substring(0, index);
        int dimension = 0;
        String componentClassName = className;
        while (componentClassName.endsWith("[]")) {
            ++dimension;
            componentClassName = componentClassName.substring(0, componentClassName.length() - 2);
        }
        Class<Constable> componentClass = null;
        boolean isComponentPrimitive = true;
        if (componentClassName.equals("long")) {
            componentClass = Long.TYPE;
        } else if (componentClassName.equals("int")) {
            componentClass = Integer.TYPE;
        } else if (componentClassName.equals("short")) {
            componentClass = Short.TYPE;
        } else if (componentClassName.equals("double")) {
            componentClass = Double.TYPE;
        } else if (componentClassName.equals("float")) {
            componentClass = Float.TYPE;
        } else if (componentClassName.equals("byte")) {
            componentClass = Byte.TYPE;
        } else if (componentClassName.equals("char")) {
            componentClass = Character.TYPE;
        } else if (componentClassName.equals("boolean")) {
            componentClass = Boolean.TYPE;
        } else {
            isComponentPrimitive = false;
            try {
                componentClass = Class.forName(componentClassName, false, this.m_annotationClass.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("could not load class [" + className + "] due to: " + e.toString());
            }
        }
        if (isComponentPrimitive) {
            if (dimension <= 0) {
                return componentClass;
            }
            return Array.newInstance(componentClass, dimension);
        }
        String componentType = Type.getType(componentClass).getDescriptor();
        for (int i = 0; i < dimension; ++i) {
            componentType = "[" + componentType;
        }
        Type type = Type.getType(componentType);
        return new AnnotationElement.LazyClass(type.getClassName());
    }

    private Object handleReferenceIdentifier(String identifier) {
        int index = identifier.lastIndexOf(46);
        String className = identifier.substring(0, index);
        String fieldName = identifier.substring(index + 1, identifier.length());
        try {
            Class<?> clazz = Class.forName(className, false, this.m_annotationClass.getClassLoader());
            Field field = clazz.getDeclaredField(fieldName);
            return field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException("could not access reference field [" + identifier + "] due to: " + e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MethodInfo {
        public Method elementMethod;
        public Class elementType;

        private MethodInfo() {
        }
    }
}

