/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.annotation;

import java.util.Iterator;
import java.util.List;
import org.codehaus.aspectwerkz.DeploymentModel;
import org.codehaus.aspectwerkz.annotation.After;
import org.codehaus.aspectwerkz.annotation.AfterFinally;
import org.codehaus.aspectwerkz.annotation.AfterReturning;
import org.codehaus.aspectwerkz.annotation.AfterThrowing;
import org.codehaus.aspectwerkz.annotation.AnnotationInfo;
import org.codehaus.aspectwerkz.annotation.Around;
import org.codehaus.aspectwerkz.annotation.Aspect;
import org.codehaus.aspectwerkz.annotation.Before;
import org.codehaus.aspectwerkz.annotation.Expression;
import org.codehaus.aspectwerkz.annotation.Introduce;
import org.codehaus.aspectwerkz.annotation.instrumentation.asm.AsmAnnotations;
import org.codehaus.aspectwerkz.aspect.AdviceType;
import org.codehaus.aspectwerkz.definition.AdviceDefinition;
import org.codehaus.aspectwerkz.definition.AspectDefinition;
import org.codehaus.aspectwerkz.definition.DefinitionParserHelper;
import org.codehaus.aspectwerkz.exception.DefinitionException;
import org.codehaus.aspectwerkz.reflect.ClassInfo;
import org.codehaus.aspectwerkz.reflect.ClassInfoHelper;
import org.codehaus.aspectwerkz.reflect.FieldInfo;
import org.codehaus.aspectwerkz.reflect.MethodInfo;
import org.codehaus.aspectwerkz.util.Strings;

public class AspectAnnotationParser {
    private static final AspectAnnotationParser INSTANCE = new AspectAnnotationParser();
    static /* synthetic */ Class class$org$codehaus$aspectwerkz$definition$DeploymentScope;

    private AspectAnnotationParser() {
    }

    public static void parse(ClassInfo classInfo, AspectDefinition aspectDef, ClassLoader loader) {
        INSTANCE.doParse(classInfo, aspectDef, loader);
    }

    private void doParse(ClassInfo classInfo, AspectDefinition aspectDef, ClassLoader loader) {
        if (classInfo == null) {
            throw new IllegalArgumentException("class to parse can not be null");
        }
        Aspect aspectAnnotation = (Aspect)((Object)AsmAnnotations.getAnnotation("org.codehaus.aspectwerkz.annotation.Aspect", classInfo));
        String aspectName = classInfo.getName();
        String deploymentModelAsString = null;
        if (aspectAnnotation != null) {
            if (aspectAnnotation.value() != null) {
                deploymentModelAsString = aspectAnnotation.value();
            } else {
                if (aspectAnnotation.name() != null) {
                    aspectName = aspectAnnotation.name();
                }
                if (aspectAnnotation.deploymentModel() != null) {
                    deploymentModelAsString = aspectAnnotation.deploymentModel();
                }
            }
        }
        aspectDef.setDeploymentModel(DeploymentModel.getDeploymentModelFor(deploymentModelAsString));
        String className = classInfo.getName();
        this.parseFieldAttributes(classInfo, aspectDef);
        this.parseMethodAttributes(classInfo, className, aspectName, aspectDef);
    }

    private void parseFieldAttributes(ClassInfo classInfo, AspectDefinition aspectDef) {
        if (aspectDef == null) {
            throw new IllegalArgumentException("aspect definition can not be null");
        }
        if (classInfo == null) {
            return;
        }
        FieldInfo[] fieldList = classInfo.getFields();
        for (int i = 0; i < fieldList.length; ++i) {
            FieldInfo field = fieldList[i];
            Iterator iterator = field.getAnnotations().iterator();
            while (iterator.hasNext()) {
                AnnotationInfo annotationInfo = (AnnotationInfo)iterator.next();
                if (annotationInfo.getAnnotation() == null) continue;
                if ("org.codehaus.aspectwerkz.annotation.Expression".equals(annotationInfo.getName())) {
                    if (field.getType().getName().equals((class$org$codehaus$aspectwerkz$definition$DeploymentScope == null ? AspectAnnotationParser.class$("org.codehaus.aspectwerkz.definition.DeploymentScope") : class$org$codehaus$aspectwerkz$definition$DeploymentScope).getName())) {
                        DefinitionParserHelper.createAndAddDeploymentScopeDef(field.getName(), ((Expression)((Object)annotationInfo.getAnnotation())).value(), aspectDef.getSystemDefinition());
                        continue;
                    }
                    DefinitionParserHelper.createAndAddPointcutDefToAspectDef(field.getName(), ((Expression)((Object)annotationInfo.getAnnotation())).value(), aspectDef);
                    continue;
                }
                if (!"org.codehaus.aspectwerkz.annotation.Introduce".equals(annotationInfo.getName())) continue;
                DefinitionParserHelper.createAndAddInterfaceIntroductionDefToAspectDef(((Introduce)((Object)annotationInfo.getAnnotation())).value(), field.getName(), field.getType().getName(), aspectDef);
            }
        }
        this.parseFieldAttributes(classInfo.getSuperclass(), aspectDef);
    }

    private void parseMethodAttributes(ClassInfo classInfo, String aspectClassName, String aspectName, AspectDefinition aspectDef) {
        if (classInfo == null) {
            throw new IllegalArgumentException("class can not be null");
        }
        if (aspectClassName == null) {
            throw new IllegalArgumentException("aspect class name can not be null");
        }
        if (aspectName == null) {
            throw new IllegalArgumentException("aspect name can not be null " + aspectClassName);
        }
        if (aspectDef == null) {
            throw new IllegalArgumentException("aspect definition can not be null");
        }
        List methodList = ClassInfoHelper.createMethodList(classInfo);
        this.parsePointcutAttributes(methodList, aspectDef);
        Iterator it = methodList.iterator();
        while (it.hasNext()) {
            MethodInfo method = (MethodInfo)it.next();
            try {
                this.parseAroundAttributes(method, aspectName, aspectClassName, aspectDef);
                this.parseBeforeAttributes(method, aspectName, aspectClassName, aspectDef);
                this.parseAfterAttributes(method, aspectName, aspectClassName, aspectDef);
            }
            catch (DefinitionException e) {
                System.err.println("AW::WARNING - unable to register advice: " + e.toString());
            }
        }
    }

    private void parsePointcutAttributes(List methodList, AspectDefinition aspectDef) {
        Iterator it = methodList.iterator();
        while (it.hasNext()) {
            MethodInfo method = (MethodInfo)it.next();
            List expressionAnnotations = AsmAnnotations.getAnnotations("org.codehaus.aspectwerkz.annotation.Expression", method);
            Iterator iterator = expressionAnnotations.iterator();
            while (iterator.hasNext()) {
                Expression annotation = (Expression)iterator.next();
                if (annotation == null) continue;
                DefinitionParserHelper.createAndAddPointcutDefToAspectDef(AspectAnnotationParser.getAdviceNameAsInSource(method), annotation.value(), aspectDef);
            }
        }
    }

    private void parseAroundAttributes(MethodInfo method, String aspectName, String aspectClassName, AspectDefinition aspectDef) {
        List aroundAnnotations = AsmAnnotations.getAnnotations("org.codehaus.aspectwerkz.annotation.Around", method);
        Iterator iterator = aroundAnnotations.iterator();
        while (iterator.hasNext()) {
            Around aroundAnnotation = (Around)iterator.next();
            if (aroundAnnotation == null) continue;
            AdviceDefinition adviceDef = DefinitionParserHelper.createAdviceDefinition(AspectAnnotationParser.getAdviceNameAsInSource(method), AdviceType.AROUND, aroundAnnotation.value(), null, aspectName, aspectClassName, method, aspectDef);
            aspectDef.addAroundAdviceDefinition(adviceDef);
        }
    }

    private void parseBeforeAttributes(MethodInfo method, String aspectName, String aspectClassName, AspectDefinition aspectDef) {
        List beforeAnnotations = AsmAnnotations.getAnnotations("org.codehaus.aspectwerkz.annotation.Before", method);
        Iterator iterator = beforeAnnotations.iterator();
        while (iterator.hasNext()) {
            Before beforeAnnotation = (Before)iterator.next();
            if (beforeAnnotation == null) continue;
            AdviceDefinition adviceDef = DefinitionParserHelper.createAdviceDefinition(AspectAnnotationParser.getAdviceNameAsInSource(method), AdviceType.BEFORE, beforeAnnotation.value(), null, aspectName, aspectClassName, method, aspectDef);
            aspectDef.addBeforeAdviceDefinition(adviceDef);
        }
    }

    private void parseAfterAttributes(MethodInfo method, String aspectName, String aspectClassName, AspectDefinition aspectDef) {
        AdviceDefinition adviceDef;
        Object annotation;
        List afterAnnotations = AsmAnnotations.getAnnotations("org.codehaus.aspectwerkz.annotation.After", method);
        Iterator iterator = afterAnnotations.iterator();
        while (iterator.hasNext()) {
            annotation = (After)iterator.next();
            if (annotation == null) continue;
            adviceDef = DefinitionParserHelper.createAdviceDefinition(AspectAnnotationParser.getAdviceNameAsInSource(method), AdviceType.AFTER, annotation.value(), null, aspectName, aspectClassName, method, aspectDef);
            aspectDef.addAfterAdviceDefinition(adviceDef);
        }
        afterAnnotations = AsmAnnotations.getAnnotations("org.codehaus.aspectwerkz.annotation.AfterReturning", method);
        iterator = afterAnnotations.iterator();
        while (iterator.hasNext()) {
            annotation = (AfterReturning)iterator.next();
            if (annotation == null) continue;
            adviceDef = DefinitionParserHelper.createAdviceDefinition(AspectAnnotationParser.getAdviceNameAsInSource(method), AdviceType.AFTER_RETURNING, AspectAnnotationParser.getExpressionElseValue(annotation.value(), annotation.pointcut()), annotation.type(), aspectName, aspectClassName, method, aspectDef);
            aspectDef.addAfterAdviceDefinition(adviceDef);
        }
        afterAnnotations = AsmAnnotations.getAnnotations("org.codehaus.aspectwerkz.annotation.AfterThrowing", method);
        iterator = afterAnnotations.iterator();
        while (iterator.hasNext()) {
            annotation = (AfterThrowing)iterator.next();
            if (annotation == null) continue;
            adviceDef = DefinitionParserHelper.createAdviceDefinition(AspectAnnotationParser.getAdviceNameAsInSource(method), AdviceType.AFTER_THROWING, AspectAnnotationParser.getExpressionElseValue(annotation.value(), annotation.pointcut()), annotation.type(), aspectName, aspectClassName, method, aspectDef);
            aspectDef.addAfterAdviceDefinition(adviceDef);
        }
        afterAnnotations = AsmAnnotations.getAnnotations("org.codehaus.aspectwerkz.annotation.AfterFinally", method);
        iterator = afterAnnotations.iterator();
        while (iterator.hasNext()) {
            annotation = (AfterFinally)iterator.next();
            if (annotation == null) continue;
            adviceDef = DefinitionParserHelper.createAdviceDefinition(AspectAnnotationParser.getAdviceNameAsInSource(method), AdviceType.AFTER_FINALLY, annotation.value(), null, aspectName, aspectClassName, method, aspectDef);
            aspectDef.addAfterAdviceDefinition(adviceDef);
        }
    }

    private static String getAdviceNameAsInSource(MethodInfo methodInfo) {
        StringBuffer buffer = new StringBuffer(methodInfo.getName());
        if (methodInfo.getParameterNames() == null || methodInfo.getParameterNames().length != methodInfo.getParameterTypes().length || methodInfo.getParameterNames().length > 0 && methodInfo.getParameterNames()[0] == null) {
            return methodInfo.getName();
        }
        if (methodInfo.getParameterNames().length > 0) {
            buffer.append('(');
            for (int i = 0; i < methodInfo.getParameterNames().length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                String parameterName = methodInfo.getParameterNames()[i];
                buffer.append(methodInfo.getParameterTypes()[i].getName());
                buffer.append(' ').append(parameterName);
            }
            buffer.append(')');
        }
        return buffer.toString();
    }

    public static String getExpressionElseValue(String value, String pointcut) {
        if (!Strings.isNullOrEmpty(pointcut)) {
            return pointcut;
        }
        if (!Strings.isNullOrEmpty(value)) {
            return value;
        }
        throw new DefinitionException("neither expression nor value had a valid value");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

