/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.aspectwerkz.annotation;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.codehaus.aspectwerkz.annotation.AnnotationC;

public class AnnotationCTask
extends Task {
    private static final String CLASS_PATTERN = "**/*.class";
    private boolean m_verbose;
    private String m_includePattern;
    private Path m_classpath;
    private Path m_src;
    private File m_properties;
    private Path m_propertiesNested;
    private File m_destdir;
    private List m_filesets = new ArrayList();

    public void setProperties(File annotationFile) {
        this.m_properties = annotationFile;
    }

    public void setVerbose(boolean isVerbose) {
        this.m_verbose = isVerbose;
    }

    public void setCopytodest(String pattern) {
        this.m_includePattern = pattern;
    }

    public void setDestdir(File destdir) {
        this.m_destdir = destdir;
    }

    public Path createProperties() {
        if (this.m_propertiesNested == null) {
            this.m_propertiesNested = new Path(this.getProject());
        }
        return this.m_propertiesNested.createPath();
    }

    public Path createSrc() {
        if (this.m_src == null) {
            this.m_src = new Path(this.getProject());
        }
        return this.m_src.createPath();
    }

    public void setSrcdir(Path srcDir) {
        if (this.m_src == null) {
            this.m_src = srcDir;
        } else {
            this.m_src.append(srcDir);
        }
    }

    public void setSourcepath(Path sourcepath) {
        if (this.m_src == null) {
            this.m_src = sourcepath;
        } else {
            this.m_src.append(sourcepath);
        }
    }

    public Path createSourcepath() {
        if (this.m_src == null) {
            this.m_src = new Path(this.getProject());
        }
        return this.m_src.createPath();
    }

    public void setSourcepathRef(Reference r) {
        this.createSourcepath().setRefid(r);
    }

    public void setClasspath(Path classpath) {
        if (this.m_classpath == null) {
            this.m_classpath = classpath;
        } else {
            this.m_classpath.append(classpath);
        }
    }

    public Path createClasspath() {
        if (this.m_classpath == null) {
            this.m_classpath = new Path(this.getProject());
        }
        return this.m_classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void addFileset(FileSet fileset) {
        this.m_filesets.add(fileset);
    }

    public void execute() throws BuildException {
        try {
            if (this.m_classpath == null) {
                throw new BuildException("No classes specified [<classpath, classpath=.. classpathref=..]");
            }
            if (this.m_destdir == null && this.m_classpath.list().length > 1) {
                throw new BuildException("When using more than one classpath directory, it is mandatory to specify [destdir=..]");
            }
            if (this.m_filesets.size() == 0 && (this.m_src == null || this.m_src.size() == 0)) {
                throw new BuildException("No source specified [<include, <sourcepath, srcdir=..]");
            }
            if (this.m_properties != null && !this.m_properties.exists() && !this.m_properties.isFile()) {
                throw new BuildException("properties file specified but not a valid file [" + this.m_properties + "]");
            }
            ArrayList<String> allProperties = new ArrayList<String>();
            if (this.m_properties != null) {
                allProperties.add(this.m_properties.getAbsolutePath());
            }
            if (this.m_propertiesNested != null) {
                allProperties.addAll(this.getDirectories(this.m_propertiesNested));
            }
            List srcDirs = this.getDirectories(this.m_src);
            List srcFiles = this.getFilesetFiles(this.m_filesets);
            List classpathDirs = this.getDirectories(this.m_classpath);
            if (this.m_verbose) {
                System.out.println("Source dir   : " + this.dump(srcDirs));
                System.out.println("Source files : " + this.dump(srcFiles));
                System.out.println("Classpath    : " + this.dump(classpathDirs));
                System.out.println("Destdir      : " + this.m_destdir);
                System.out.println("Properties   : " + this.dump(allProperties));
                System.out.println("Copytodest   : " + this.m_includePattern);
            }
            AnnotationC.compile(this.m_verbose, srcDirs.toArray(new String[0]), srcFiles.toArray(new String[0]), classpathDirs.toArray(new String[0]), this.m_destdir == null ? null : this.m_destdir.getAbsolutePath(), allProperties.toArray(new String[0]));
            if (this.m_destdir != null) {
                if (this.m_verbose) {
                    System.out.println("Copying residual files to dest dir...");
                }
                this.copySourcesToDest();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException((Throwable)e);
        }
    }

    private List getFilesetFiles(List filesets) throws BuildException {
        ArrayList<String> files = new ArrayList<String>();
        Iterator iterator = filesets.iterator();
        while (iterator.hasNext()) {
            FileSet fileset = (FileSet)iterator.next();
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            for (int i = 0; i < ds.getIncludedFiles().length; ++i) {
                String file = ds.getIncludedFiles()[i];
                files.add(ds.getBasedir() + File.separator + file);
            }
        }
        return files;
    }

    private List getDirectories(Path path) throws BuildException {
        ArrayList<String> dirs = new ArrayList<String>();
        if (path == null) {
            return dirs;
        }
        for (int i = 0; i < path.list().length; ++i) {
            File dir = this.getProject().resolveFile(path.list()[i]);
            if (!dir.exists()) {
                throw new BuildException(" \"" + dir.getPath() + "\" does not exist!", this.getLocation());
            }
            dirs.add(dir.getAbsolutePath());
        }
        return dirs;
    }

    private String dump(List strings) {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = strings.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            sb.append(o.toString()).append(File.pathSeparator);
        }
        return sb.toString();
    }

    private void copySourcesToDest() throws BuildException {
        Copy copy = new Copy();
        copy.setProject(this.getProject());
        copy.setTodir(this.m_destdir);
        copy.setOverwrite(false);
        copy.setTaskName("copy");
        copy.setVerbose(this.m_verbose);
        List sourceDir = this.getDirectories(this.m_src);
        Iterator iterator = sourceDir.iterator();
        while (iterator.hasNext()) {
            String dir = (String)iterator.next();
            FileSet anonFs = new FileSet();
            anonFs.setIncludes(CLASS_PATTERN);
            if (this.m_includePattern != null) {
                anonFs.setIncludes(this.m_includePattern);
            }
            anonFs.setDir(new File(dir));
            copy.addFileset(anonFs);
        }
        copy.execute();
    }
}

