/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.AnnotationTargetKind;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.SourceContextImpl;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.PerClause;

public abstract class AbstractReferenceTypeDelegate
implements ReferenceTypeDelegate {
    public static final String UNKNOWN_SOURCE_FILE = "<Unknown>";
    private String sourcefilename = "<Unknown>";
    protected boolean exposedToWeaver;
    protected ReferenceType resolvedTypeX;
    private ISourceContext sourceContext = SourceContextImpl.UNKNOWN_SOURCE_CONTEXT;

    public AbstractReferenceTypeDelegate(ReferenceType resolvedTypeX, boolean exposedToWeaver) {
        this.resolvedTypeX = resolvedTypeX;
        this.exposedToWeaver = exposedToWeaver;
    }

    public final boolean isClass() {
        return !this.isAspect() && !this.isInterface();
    }

    public boolean doesNotExposeShadowMungers() {
        return false;
    }

    public boolean isExposedToWeaver() {
        return this.exposedToWeaver;
    }

    public ReferenceType getResolvedTypeX() {
        return this.resolvedTypeX;
    }

    public String stringifyDelegate() {
        Object mun;
        Iterator iter;
        int i;
        Collection tmungers;
        TypeVariable[] tv;
        Collection declares;
        Iterator iter2;
        int i2;
        ResolvedType[] interfaces;
        ResolvedMember[] methods;
        StringBuffer result = new StringBuffer();
        result.append("=== Delegate for " + this.getResolvedTypeX().getName() + "\n");
        result.append("isAspect?" + this.isAspect() + "\n");
        result.append("isAnnotationStyleAspect?" + this.isAnnotationStyleAspect() + "\n");
        result.append("isInterface?" + this.isInterface() + "\n");
        result.append("isEnum?" + this.isEnum() + "\n");
        result.append("isClass?" + this.isClass() + "\n");
        result.append("-\n");
        result.append("isAnnotation?" + this.isAnnotation() + "\n");
        result.append("retentionPolicy=" + this.getRetentionPolicy() + "\n");
        result.append("canAnnotationTargetType?" + this.canAnnotationTargetType() + "\n");
        AnnotationTargetKind[] kinds = this.getAnnotationTargetKinds();
        if (kinds != null && kinds.length > 0) {
            result.append("annotationTargetKinds:[");
            for (int i3 = 0; i3 < kinds.length; ++i3) {
                AnnotationTargetKind kind = kinds[i3];
                result.append(kind);
                if (i3 + 1 >= kinds.length) continue;
                result.append(" ");
            }
            result.append("]\n");
        }
        result.append("isAnnotationWithRuntimeRetention?" + this.isAnnotationWithRuntimeRetention() + "\n");
        result.append("-\n");
        result.append("isAnonymous?" + this.isAnonymous() + "\n");
        result.append("isNested?" + this.isNested() + "\n");
        result.append("-\n");
        result.append("isGeneric?" + this.isGeneric() + "\n");
        result.append("declaredGenericSignature=" + this.getDeclaredGenericSignature() + "\n");
        result.append("-\n");
        AnnotationX[] axs = this.getAnnotations();
        if (axs != null && axs.length > 0) {
            result.append("getAnnotations() returns: " + axs.length + " annotations\n");
            for (int i4 = 0; i4 < axs.length; ++i4) {
                AnnotationX annotationX = axs[i4];
                result.append("  #" + i4 + ") " + annotationX + "\n");
            }
        } else {
            result.append("getAnnotations() returns nothing\n");
        }
        ResolvedType[] axtypes = this.getAnnotationTypes();
        if (axtypes != null && axtypes.length > 0) {
            result.append("getAnnotationTypes() returns: " + axtypes.length + " annotations\n");
            for (int i5 = 0; i5 < axtypes.length; ++i5) {
                ResolvedType annotation = axtypes[i5];
                result.append("  #" + i5 + ") " + annotation + ":" + annotation.getClass() + "\n");
            }
        } else {
            result.append("getAnnotationTypes() returns nothing\n");
        }
        result.append("isExposedToWeaver?" + this.isExposedToWeaver() + "\n");
        result.append("getSuperclass?" + this.getSuperclass() + "\n");
        result.append("getResolvedTypeX?" + this.getResolvedTypeX() + "\n");
        result.append("--\n");
        ResolvedMember[] fields = this.getDeclaredFields();
        if (fields != null && fields.length > 0) {
            result.append("The fields: " + fields.length + "\n");
            for (int i6 = 0; i6 < fields.length; ++i6) {
                ResolvedMember member = fields[i6];
                result.append("f" + i6 + ") " + member.toDebugString() + "\n");
            }
        }
        if ((methods = this.getDeclaredMethods()) != null && methods.length > 0) {
            result.append("The methods: " + methods.length + "\n");
            for (int i7 = 0; i7 < methods.length; ++i7) {
                ResolvedMember member = methods[i7];
                result.append("m" + i7 + ") " + member.toDebugString() + "\n");
            }
        }
        if ((interfaces = this.getDeclaredInterfaces()) != null && interfaces.length > 0) {
            result.append("The interfaces: " + interfaces.length + "\n");
            for (int i8 = 0; i8 < interfaces.length; ++i8) {
                ResolvedType member = interfaces[i8];
                result.append("i" + i8 + ") " + member + "\n");
            }
        }
        result.append("getModifiers?" + this.getModifiers() + "\n");
        result.append("perclause=" + this.getPerClause() + "\n");
        result.append("aj:weaverstate=" + this.getWeaverState() + "\n");
        ResolvedMember[] pointcuts = this.getDeclaredPointcuts();
        if (pointcuts != null && pointcuts.length > 0) {
            result.append("The pointcuts: " + pointcuts.length + "\n");
            ArrayList<ResolvedMember> sortedSetOfPointcuts = new ArrayList<ResolvedMember>();
            for (i2 = 0; i2 < pointcuts.length; ++i2) {
                sortedSetOfPointcuts.add(pointcuts[i2]);
            }
            Collections.sort(sortedSetOfPointcuts);
            i2 = 0;
            iter2 = sortedSetOfPointcuts.iterator();
            while (iter2.hasNext()) {
                ResolvedMember member = (ResolvedMember)iter2.next();
                result.append("p" + i2 + ") " + member.toDebugString() + "\n");
                ++i2;
            }
        }
        if ((declares = this.getDeclares()).size() > 0) {
            result.append("The declares: " + declares.size() + "\n");
            i2 = 0;
            iter2 = declares.iterator();
            while (iter2.hasNext()) {
                Declare dec = (Declare)iter2.next();
                result.append("d" + i2 + ") " + dec.toString() + "\n");
                ++i2;
            }
        }
        if ((tv = this.getTypeVariables()) != null && tv.length > 0) {
            result.append("The type variables: " + tv.length + "\n");
            for (int i9 = 0; i9 < tv.length; ++i9) {
                result.append("tv" + i9 + ") " + tv[i9] + "\n");
            }
        }
        if ((tmungers = this.getTypeMungers()).size() > 0) {
            ArrayList sorted = new ArrayList();
            sorted.addAll(tmungers);
            Collections.sort(sorted, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    return arg0.toString().compareTo(arg1.toString());
                }
            });
            result.append("The type mungers: " + tmungers.size() + "\n");
            i = 0;
            iter = sorted.iterator();
            while (iter.hasNext()) {
                mun = (ConcreteTypeMunger)iter.next();
                result.append("tm" + i + ") " + mun.toString() + "\n");
                ++i;
            }
        }
        result.append("doesNotExposeShadowMungers?" + this.doesNotExposeShadowMungers() + "\n");
        Collection pas = this.getPrivilegedAccesses();
        if (pas != null && pas.size() > 0) {
            result.append("The privileged accesses: " + pas.size() + "\n");
            i = 0;
            iter = pas.iterator();
            while (iter.hasNext()) {
                mun = (ResolvedMember)iter.next();
                result.append("tm" + i + ") " + mun.toDebugString() + "\n");
                ++i;
            }
        }
        result.append("===");
        return result.toString();
    }

    public final String getSourcefilename() {
        return this.sourcefilename;
    }

    public final void setSourcefilename(String sourceFileName) {
        this.sourcefilename = sourceFileName;
        if (sourceFileName != null && sourceFileName.equals(UNKNOWN_SOURCE_FILE)) {
            this.sourcefilename = "Type '" + this.getResolvedTypeX().getName() + "' (no debug info available)";
        } else {
            String pname = this.getResolvedTypeX().getPackageName();
            if (pname != null) {
                this.sourcefilename = pname.replace('.', '/') + '/' + sourceFileName;
            }
        }
    }

    public ISourceLocation getSourceLocation() {
        return this.getSourceContext().makeSourceLocation(0, 0);
    }

    public ISourceContext getSourceContext() {
        return this.sourceContext;
    }

    public void setSourceContext(ISourceContext isc) {
        this.sourceContext = isc;
    }

    public abstract /* synthetic */ String getDeclaredGenericSignature();

    public abstract /* synthetic */ WeaverStateInfo getWeaverState();

    public abstract /* synthetic */ ResolvedType getSuperclass();

    public abstract /* synthetic */ int getModifiers();

    public abstract /* synthetic */ Collection getPrivilegedAccesses();

    public abstract /* synthetic */ Collection getTypeMungers();

    public abstract /* synthetic */ Collection getDeclares();

    public abstract /* synthetic */ PerClause getPerClause();

    public abstract /* synthetic */ TypeVariable[] getTypeVariables();

    public abstract /* synthetic */ ResolvedMember[] getDeclaredPointcuts();

    public abstract /* synthetic */ ResolvedMember[] getDeclaredMethods();

    public abstract /* synthetic */ ResolvedType[] getDeclaredInterfaces();

    public abstract /* synthetic */ ResolvedMember[] getDeclaredFields();

    public abstract /* synthetic */ ResolvedType[] getAnnotationTypes();

    public abstract /* synthetic */ AnnotationX[] getAnnotations();

    public abstract /* synthetic */ boolean hasAnnotation(UnresolvedType var1);

    public abstract /* synthetic */ boolean isNested();

    public abstract /* synthetic */ boolean isAnonymous();

    public abstract /* synthetic */ boolean isGeneric();

    public abstract /* synthetic */ boolean isAnnotationWithRuntimeRetention();

    public abstract /* synthetic */ AnnotationTargetKind[] getAnnotationTargetKinds();

    public abstract /* synthetic */ boolean canAnnotationTargetType();

    public abstract /* synthetic */ String getRetentionPolicy();

    public abstract /* synthetic */ boolean isAnnotation();

    public abstract /* synthetic */ boolean isEnum();

    public abstract /* synthetic */ boolean isInterface();

    public abstract /* synthetic */ boolean isAnnotationStyleAspect();

    public abstract /* synthetic */ boolean isAspect();

    public abstract /* synthetic */ void ensureDelegateConsistent();

    public abstract /* synthetic */ void addAnnotation(AnnotationX var1);
}

