/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.patterns.PerFromSuper;
import org.aspectj.weaver.patterns.PerObject;
import org.aspectj.weaver.patterns.PerThisOrTargetPointcutVisitor;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.TypePattern;

public class PerObjectInterfaceTypeMunger
extends ResolvedTypeMunger {
    private final UnresolvedType interfaceType;
    private final Pointcut testPointcut;
    private TypePattern lazyTestTypePattern;

    public PerObjectInterfaceTypeMunger(UnresolvedType aspectType, Pointcut testPointcut) {
        super(ResolvedTypeMunger.PerObjectInterface, null);
        this.testPointcut = testPointcut;
        this.interfaceType = AjcMemberMaker.perObjectInterfaceType(aspectType);
    }

    private TypePattern getTestTypePattern(ResolvedType aspectType) {
        if (this.lazyTestTypePattern == null) {
            boolean isPerThis;
            if (aspectType.getPerClause() instanceof PerFromSuper) {
                PerFromSuper ps = (PerFromSuper)aspectType.getPerClause();
                isPerThis = ((PerObject)ps.lookupConcretePerClause(aspectType)).isThis();
            } else {
                isPerThis = ((PerObject)aspectType.getPerClause()).isThis();
            }
            PerThisOrTargetPointcutVisitor v = new PerThisOrTargetPointcutVisitor(!isPerThis, aspectType);
            this.lazyTestTypePattern = v.getPerTypePointcut(this.testPointcut);
        }
        return this.lazyTestTypePattern;
    }

    public void write(DataOutputStream s) throws IOException {
        throw new RuntimeException("shouldn't be serialized");
    }

    public UnresolvedType getInterfaceType() {
        return this.interfaceType;
    }

    public Pointcut getTestPointcut() {
        return this.testPointcut;
    }

    public boolean matches(ResolvedType matchType, ResolvedType aspectType) {
        if (matchType.isInterface()) {
            return false;
        }
        return this.getTestTypePattern(aspectType).matchesStatically(matchType);
    }

    public boolean isLateMunger() {
        return true;
    }
}

