/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.HierarchyWalker;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.AspectJElementHierarchy;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;

public class ProgramElement
implements IProgramElement {
    private static final long serialVersionUID = 171673495267384449L;
    protected IProgramElement parent = null;
    protected String name = "";
    protected List children = new ArrayList();
    protected IMessage message = null;
    protected ISourceLocation sourceLocation = null;
    private List modifiers = new ArrayList();
    private List relations = new ArrayList();
    private IProgramElement.Kind kind;
    private IProgramElement.Accessibility accessibility;
    private String declaringType = "";
    private String formalComment = "";
    private boolean runnable = false;
    private boolean implementor = false;
    private boolean overrider = false;
    private String bytecodeName;
    private String bytecodeSignature;
    private String returnType;
    private List parameterNames = null;
    private List parameterTypes = null;
    private String details = null;
    private IProgramElement.ExtraInformation info;
    private static int AccPublic = 1;
    private static int AccPrivate = 2;
    private static int AccProtected = 4;
    private static int AccPrivileged = 6;
    private static int AccStatic = 8;
    private static int AccFinal = 16;
    private static int AccSynchronized = 32;
    private static int AccVolatile = 64;
    private static int AccTransient = 128;
    private static int AccNative = 256;
    private static int AccAbstract = 1024;
    private String sourceSignature;
    public static boolean shortITDNames = true;
    private String handle = null;

    public ProgramElement() {
    }

    public ProgramElement(String name, IProgramElement.Kind kind, List children) {
        this.name = name;
        this.kind = kind;
        this.setChildren(children);
    }

    public ProgramElement(String name, IProgramElement.Kind kind, ISourceLocation sourceLocation, int modifiers, String formalComment, List children) {
        this(name, kind, children);
        this.sourceLocation = sourceLocation;
        this.kind = kind;
        this.formalComment = formalComment;
        this.modifiers = ProgramElement.genModifiers(modifiers);
        this.accessibility = ProgramElement.genAccessibility(modifiers);
        this.cacheByHandle();
    }

    public ProgramElement(String name, IProgramElement.Kind kind, int modifiers, IProgramElement.Accessibility accessibility, String declaringType, String packageName, String formalComment, ISourceLocation sourceLocation, List relations, List children, boolean member) {
        this(name, kind, children);
        this.sourceLocation = sourceLocation;
        this.kind = kind;
        this.modifiers = ProgramElement.genModifiers(modifiers);
        this.accessibility = accessibility;
        this.declaringType = declaringType;
        this.formalComment = formalComment;
        this.relations = relations;
        this.cacheByHandle();
    }

    public List getModifiers() {
        return this.modifiers;
    }

    public IProgramElement.Accessibility getAccessibility() {
        return this.accessibility;
    }

    public void setAccessibility(IProgramElement.Accessibility a) {
        this.accessibility = a;
    }

    public String getDeclaringType() {
        return this.declaringType;
    }

    public String getPackageName() {
        if (this.kind == IProgramElement.Kind.PACKAGE) {
            return this.getName();
        }
        if (this.getParent() == null || !(this.getParent() instanceof IProgramElement)) {
            return "";
        }
        return this.getParent().getPackageName();
    }

    public IProgramElement.Kind getKind() {
        return this.kind;
    }

    public boolean isCode() {
        return this.kind.equals(IProgramElement.Kind.CODE);
    }

    public ISourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(ISourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public IMessage getMessage() {
        return this.message;
    }

    public void setMessage(IMessage message) {
        this.message = message;
    }

    public IProgramElement getParent() {
        return this.parent;
    }

    public void setParent(IProgramElement parent) {
        this.parent = parent;
    }

    public boolean isMemberKind() {
        return this.kind.isMember();
    }

    public void setRunnable(boolean value) {
        this.runnable = value;
    }

    public boolean isRunnable() {
        return this.runnable;
    }

    public boolean isImplementor() {
        return this.implementor;
    }

    public void setImplementor(boolean value) {
        this.implementor = value;
    }

    public boolean isOverrider() {
        return this.overrider;
    }

    public void setOverrider(boolean value) {
        this.overrider = value;
    }

    public List getRelations() {
        return this.relations;
    }

    public void setRelations(List relations) {
        if (relations.size() > 0) {
            this.relations = relations;
        }
    }

    public String getFormalComment() {
        return this.formalComment;
    }

    public String toString() {
        return this.toLabelString();
    }

    private static List genModifiers(int modifiers) {
        ArrayList<IProgramElement.Modifiers> modifiersList = new ArrayList<IProgramElement.Modifiers>();
        if ((modifiers & AccStatic) != 0) {
            modifiersList.add(IProgramElement.Modifiers.STATIC);
        }
        if ((modifiers & AccFinal) != 0) {
            modifiersList.add(IProgramElement.Modifiers.FINAL);
        }
        if ((modifiers & AccSynchronized) != 0) {
            modifiersList.add(IProgramElement.Modifiers.SYNCHRONIZED);
        }
        if ((modifiers & AccVolatile) != 0) {
            modifiersList.add(IProgramElement.Modifiers.VOLATILE);
        }
        if ((modifiers & AccTransient) != 0) {
            modifiersList.add(IProgramElement.Modifiers.TRANSIENT);
        }
        if ((modifiers & AccNative) != 0) {
            modifiersList.add(IProgramElement.Modifiers.NATIVE);
        }
        if ((modifiers & AccAbstract) != 0) {
            modifiersList.add(IProgramElement.Modifiers.ABSTRACT);
        }
        return modifiersList;
    }

    public static IProgramElement.Accessibility genAccessibility(int modifiers) {
        if ((modifiers & AccPublic) != 0) {
            return IProgramElement.Accessibility.PUBLIC;
        }
        if ((modifiers & AccPrivate) != 0) {
            return IProgramElement.Accessibility.PRIVATE;
        }
        if ((modifiers & AccProtected) != 0) {
            return IProgramElement.Accessibility.PROTECTED;
        }
        if ((modifiers & AccPrivileged) != 0) {
            return IProgramElement.Accessibility.PRIVILEGED;
        }
        return IProgramElement.Accessibility.PACKAGE;
    }

    public String getBytecodeName() {
        return this.bytecodeName;
    }

    public String getBytecodeSignature() {
        return this.bytecodeSignature;
    }

    public void setBytecodeName(String bytecodeName) {
        this.bytecodeName = bytecodeName;
    }

    public void setBytecodeSignature(String bytecodeSignature) {
        this.bytecodeSignature = bytecodeSignature;
    }

    public String getSourceSignature() {
        return this.sourceSignature;
    }

    public void setSourceSignature(String string) {
        this.sourceSignature = string;
    }

    public void setKind(IProgramElement.Kind kind) {
        this.kind = kind;
    }

    public void setCorrespondingType(String returnType) {
        this.returnType = returnType;
    }

    public String getCorrespondingType() {
        return this.returnType;
    }

    public String getName() {
        return this.name;
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
        if (children == null) {
            return;
        }
        Iterator it = children.iterator();
        while (it.hasNext()) {
            ((IProgramElement)it.next()).setParent(this);
        }
    }

    public void addChild(IProgramElement child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
        child.setParent(this);
    }

    public void addChild(int position, IProgramElement child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(position, child);
        child.setParent(this);
    }

    public boolean removeChild(IProgramElement child) {
        child.setParent(null);
        return this.children.remove(child);
    }

    public void setName(String string) {
        this.name = string;
    }

    public IProgramElement walk(HierarchyWalker walker) {
        if (this.children != null) {
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                IProgramElement child = (IProgramElement)it.next();
                walker.process(child);
            }
        }
        return this;
    }

    public String toLongString() {
        final StringBuffer buffer = new StringBuffer();
        HierarchyWalker walker = new HierarchyWalker(){
            private int depth = 0;

            public void preProcess(IProgramElement node) {
                for (int i = 0; i < this.depth; ++i) {
                    buffer.append(' ');
                }
                buffer.append(((Object)node).toString());
                buffer.append('\n');
                this.depth += 2;
            }

            public void postProcess(IProgramElement node) {
                this.depth -= 2;
            }
        };
        walker.process(this);
        return buffer.toString();
    }

    public void setModifiers(int i) {
        this.modifiers = ProgramElement.genModifiers(i);
    }

    public String toSignatureString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (this.parameterTypes != null) {
            sb.append('(');
            Iterator it = this.parameterTypes.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public String toLinkLabelString() {
        String label;
        if (this.kind == IProgramElement.Kind.CODE || this.kind == IProgramElement.Kind.INITIALIZER) {
            label = this.parent.getParent().getName() + ": ";
        } else if (this.kind.isInterTypeMember()) {
            if (shortITDNames) {
                label = "";
            } else {
                int dotIndex = this.name.indexOf(46);
                if (dotIndex != -1) {
                    return this.parent.getName() + ": " + this.toLabelString().substring(dotIndex + 1);
                }
                label = this.parent.getName() + '.';
            }
        } else {
            label = this.kind == IProgramElement.Kind.CLASS || this.kind == IProgramElement.Kind.ASPECT || this.kind == IProgramElement.Kind.INTERFACE ? "" : (this.kind.equals(IProgramElement.Kind.DECLARE_PARENTS) ? "" : (this.parent != null ? this.parent.getName() + '.' : "injar aspect: "));
        }
        label = label + this.toLabelString();
        return label;
    }

    public String toLabelString() {
        String label = this.toSignatureString();
        if (this.details != null) {
            label = label + ": " + this.details;
        }
        return label;
    }

    public String getHandleIdentifier() {
        if (null == this.handle && this.sourceLocation != null) {
            return AsmManager.getDefault().getHandleProvider().createHandleIdentifier(this.sourceLocation);
        }
        return this.handle;
    }

    public List getParameterNames() {
        return this.parameterNames;
    }

    public List getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterNames(List list) {
        this.parameterNames = list;
    }

    public void setParameterTypes(List list) {
        this.parameterTypes = list;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String string) {
        this.details = string;
    }

    public void setFormalComment(String formalComment) {
        this.formalComment = formalComment;
    }

    private void cacheByHandle() {
        String handle = this.getHandleIdentifier();
        if (handle != null) {
            AspectJElementHierarchy hierarchy = (AspectJElementHierarchy)AsmManager.getDefault().getHierarchy();
            hierarchy.cache(handle, this);
        }
    }

    public void setExtraInfo(IProgramElement.ExtraInformation info) {
        this.info = info;
    }

    public IProgramElement.ExtraInformation getExtraInfo() {
        return this.info;
    }
}

