/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.reflect.ReflectionBasedReferenceTypeDelegate;
import org.aspectj.weaver.reflect.ReflectionBasedResolvedMemberImpl;
import org.aspectj.weaver.reflect.ReflectionWorld;

public class ReflectionBasedReferenceTypeDelegateFactory {
    public static ReflectionBasedReferenceTypeDelegate createDelegate(ReferenceType forReferenceType, World inWorld) {
        try {
            ReflectionBasedReferenceTypeDelegate rbrtd;
            Class<?> c = Class.forName(forReferenceType.getName());
            if (LangUtil.is15VMOrGreater() && (rbrtd = ReflectionBasedReferenceTypeDelegateFactory.create15Delegate(forReferenceType, c, inWorld)) != null) {
                return rbrtd;
            }
            return new ReflectionBasedReferenceTypeDelegate(c, inWorld, forReferenceType);
        }
        catch (ClassNotFoundException cnfEx) {
            return null;
        }
    }

    private static ReflectionBasedReferenceTypeDelegate create15Delegate(ReferenceType forReferenceType, Class forClass, World inWorld) {
        try {
            Class<?> delegateClass = Class.forName("org.aspectj.weaver.reflect.Java15ReflectionBasedReferenceTypeDelegate");
            ReflectionBasedReferenceTypeDelegate ret = (ReflectionBasedReferenceTypeDelegate)delegateClass.newInstance();
            ret.initialize(forReferenceType, forClass, inWorld);
            return ret;
        }
        catch (ClassNotFoundException cnfEx) {
            return null;
        }
        catch (InstantiationException insEx) {
            return null;
        }
        catch (IllegalAccessException illAccEx) {
            return null;
        }
    }

    public static ResolvedMember createResolvedMember(java.lang.reflect.Member reflectMember, World inWorld) {
        if (reflectMember instanceof Method) {
            return ReflectionBasedReferenceTypeDelegateFactory.createResolvedMethod((Method)reflectMember, inWorld);
        }
        if (reflectMember instanceof Constructor) {
            return ReflectionBasedReferenceTypeDelegateFactory.createResolvedConstructor((Constructor)reflectMember, inWorld);
        }
        return ReflectionBasedReferenceTypeDelegateFactory.createResolvedField((Field)reflectMember, inWorld);
    }

    public static ResolvedMember createResolvedMethod(Method aMethod, World inWorld) {
        ReflectionBasedResolvedMemberImpl ret = new ReflectionBasedResolvedMemberImpl(Member.METHOD, (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aMethod.getDeclaringClass(), (ReflectionWorld)inWorld), aMethod.getModifiers(), (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aMethod.getReturnType(), (ReflectionWorld)inWorld), aMethod.getName(), (UnresolvedType[])ReflectionBasedReferenceTypeDelegateFactory.toResolvedTypeArray(aMethod.getParameterTypes(), inWorld), (UnresolvedType[])ReflectionBasedReferenceTypeDelegateFactory.toResolvedTypeArray(aMethod.getExceptionTypes(), inWorld), aMethod);
        return ret;
    }

    public static ResolvedMember createResolvedAdviceMember(Method aMethod, World inWorld) {
        return new ReflectionBasedResolvedMemberImpl(Member.ADVICE, (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aMethod.getDeclaringClass(), (ReflectionWorld)inWorld), aMethod.getModifiers(), (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aMethod.getReturnType(), (ReflectionWorld)inWorld), aMethod.getName(), (UnresolvedType[])ReflectionBasedReferenceTypeDelegateFactory.toResolvedTypeArray(aMethod.getParameterTypes(), inWorld), (UnresolvedType[])ReflectionBasedReferenceTypeDelegateFactory.toResolvedTypeArray(aMethod.getExceptionTypes(), inWorld), aMethod);
    }

    public static ResolvedMember createStaticInitMember(Class forType, World inWorld) {
        return new ResolvedMemberImpl(Member.STATIC_INITIALIZATION, ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(forType, (ReflectionWorld)inWorld), 8, ResolvedType.VOID, "<clinit>", new UnresolvedType[0], new UnresolvedType[0]);
    }

    public static ResolvedMember createResolvedConstructor(Constructor aConstructor, World inWorld) {
        return new ReflectionBasedResolvedMemberImpl(Member.CONSTRUCTOR, (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aConstructor.getDeclaringClass(), (ReflectionWorld)inWorld), aConstructor.getModifiers(), (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aConstructor.getDeclaringClass(), (ReflectionWorld)inWorld), "init", (UnresolvedType[])ReflectionBasedReferenceTypeDelegateFactory.toResolvedTypeArray(aConstructor.getParameterTypes(), inWorld), (UnresolvedType[])ReflectionBasedReferenceTypeDelegateFactory.toResolvedTypeArray(aConstructor.getExceptionTypes(), inWorld), aConstructor);
    }

    public static ResolvedMember createResolvedField(Field aField, World inWorld) {
        return new ReflectionBasedResolvedMemberImpl(Member.FIELD, (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aField.getDeclaringClass(), (ReflectionWorld)inWorld), aField.getModifiers(), (UnresolvedType)ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(aField.getType(), (ReflectionWorld)inWorld), aField.getName(), new UnresolvedType[0], aField);
    }

    public static ResolvedMember createHandlerMember(Class exceptionType, Class inType, World inWorld) {
        return new ResolvedMemberImpl(Member.HANDLER, ReflectionBasedReferenceTypeDelegateFactory.toResolvedType(inType, (ReflectionWorld)inWorld), 8, "<catch>", "(" + inWorld.resolve(exceptionType.getName()).getSignature() + ")V");
    }

    private static ResolvedType toResolvedType(Class aClass, ReflectionWorld aWorld) {
        return aWorld.resolve(aClass);
    }

    private static ResolvedType[] toResolvedTypeArray(Class[] classes, World inWorld) {
        ResolvedType[] ret = new ResolvedType[classes.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ((ReflectionWorld)inWorld).resolve(classes[i]);
        }
        return ret;
    }
}

