/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import org.aspectj.weaver.AnnotationX;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.TypeVariable;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.reflect.ReflectionBasedReferenceTypeDelegateFactory;
import org.aspectj.weaver.reflect.ReflectionWorld;

public class ReflectionBasedReferenceTypeDelegate
implements ReferenceTypeDelegate {
    protected Class myClass = null;
    private World world;
    private ReferenceType resolvedType;
    private ResolvedMember[] fields = null;
    private ResolvedMember[] methods = null;
    private ResolvedType[] interfaces = null;

    public ReflectionBasedReferenceTypeDelegate(Class forClass, World inWorld, ReferenceType resolvedType) {
        this.initialize(resolvedType, forClass, inWorld);
    }

    public ReflectionBasedReferenceTypeDelegate() {
    }

    public void initialize(ReferenceType aType, Class aClass, World aWorld) {
        this.myClass = aClass;
        this.resolvedType = aType;
        this.world = aWorld;
    }

    protected Class getBaseClass() {
        return this.myClass;
    }

    protected World getWorld() {
        return this.world;
    }

    protected ReflectionWorld getReflectionWorld() {
        return (ReflectionWorld)this.world;
    }

    public ReferenceType buildGenericType() {
        throw new UnsupportedOperationException("Shouldn't be asking for generic type at 1.4 source level or lower");
    }

    public void addAnnotation(AnnotationX annotationX) {
        throw new UnsupportedOperationException("Cannot add an annotation to a reflection based delegate");
    }

    public boolean isAspect() {
        return false;
    }

    public boolean isAnnotationStyleAspect() {
        return false;
    }

    public boolean isInterface() {
        return this.myClass.isInterface();
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isAnnotationWithRuntimeRetention() {
        return false;
    }

    public String getRetentionPolicy() {
        return null;
    }

    public boolean isClass() {
        return !this.myClass.isInterface() && !this.myClass.isPrimitive() && !this.myClass.isArray();
    }

    public boolean isGeneric() {
        return false;
    }

    public boolean isAnonymous() {
        return false;
    }

    public boolean isExposedToWeaver() {
        return false;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        return false;
    }

    public AnnotationX[] getAnnotations() {
        return new AnnotationX[0];
    }

    public ResolvedType[] getAnnotationTypes() {
        return new ResolvedType[0];
    }

    public ResolvedMember[] getDeclaredFields() {
        if (this.fields == null) {
            Field[] reflectFields = this.myClass.getDeclaredFields();
            this.fields = new ResolvedMember[reflectFields.length];
            for (int i = 0; i < reflectFields.length; ++i) {
                this.fields[i] = ReflectionBasedReferenceTypeDelegateFactory.createResolvedMember(reflectFields[i], this.world);
            }
        }
        return this.fields;
    }

    public ResolvedType[] getDeclaredInterfaces() {
        if (this.interfaces == null) {
            Class<?>[] reflectInterfaces = this.myClass.getInterfaces();
            this.interfaces = new ResolvedType[reflectInterfaces.length];
            for (int i = 0; i < reflectInterfaces.length; ++i) {
                this.interfaces[i] = this.getReflectionWorld().resolve(reflectInterfaces[i]);
            }
        }
        return this.interfaces;
    }

    public ResolvedMember[] getDeclaredMethods() {
        if (this.methods == null) {
            int i;
            Method[] reflectMethods = this.myClass.getDeclaredMethods();
            Constructor<?>[] reflectCons = this.myClass.getDeclaredConstructors();
            this.methods = new ResolvedMember[reflectMethods.length + reflectCons.length];
            for (i = 0; i < reflectMethods.length; ++i) {
                this.methods[i] = ReflectionBasedReferenceTypeDelegateFactory.createResolvedMember(reflectMethods[i], this.world);
            }
            for (i = 0; i < reflectCons.length; ++i) {
                this.methods[i + reflectMethods.length] = ReflectionBasedReferenceTypeDelegateFactory.createResolvedMember(reflectCons[i], this.world);
            }
        }
        return this.methods;
    }

    public ResolvedMember[] getDeclaredPointcuts() {
        return new ResolvedMember[0];
    }

    public TypeVariable[] getTypeVariables() {
        return new TypeVariable[0];
    }

    public PerClause getPerClause() {
        return null;
    }

    public Collection getDeclares() {
        return Collections.EMPTY_SET;
    }

    public Collection getTypeMungers() {
        return Collections.EMPTY_SET;
    }

    public Collection getPrivilegedAccesses() {
        return Collections.EMPTY_SET;
    }

    public int getModifiers() {
        return this.myClass.getModifiers();
    }

    public ResolvedType getSuperclass() {
        if (this.myClass.getSuperclass() == null) {
            return null;
        }
        return this.getReflectionWorld().resolve(this.myClass.getSuperclass());
    }

    public WeaverStateInfo getWeaverState() {
        return null;
    }

    public ReferenceType getResolvedTypeX() {
        return this.resolvedType;
    }

    public boolean doesNotExposeShadowMungers() {
        return false;
    }

    public String getDeclaredGenericSignature() {
        return null;
    }

    public void ensureDelegateConsistent() {
    }
}

